/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.Serializable;

public final class MinOptMax
implements Serializable {
    private static final long serialVersionUID = -4791524475122206142L;
    public static final MinOptMax ZERO = MinOptMax.getInstance(0);
    private final int min;
    private final int opt;
    private final int max;

    public static MinOptMax getInstance(int min2, int opt2, int max2) throws IllegalArgumentException {
        if (min2 > opt2) {
            throw new IllegalArgumentException("min (" + min2 + ") > opt (" + opt2 + ")");
        }
        if (max2 < opt2) {
            throw new IllegalArgumentException("max (" + max2 + ") < opt (" + opt2 + ")");
        }
        return new MinOptMax(min2, opt2, max2);
    }

    public static MinOptMax getInstance(int value2) {
        return new MinOptMax(value2, value2, value2);
    }

    private MinOptMax(int min2, int opt2, int max2) {
        assert (min2 <= opt2 && opt2 <= max2);
        this.min = min2;
        this.opt = opt2;
        this.max = max2;
    }

    public int getMin() {
        return this.min;
    }

    public int getOpt() {
        return this.opt;
    }

    public int getMax() {
        return this.max;
    }

    public int getShrink() {
        return this.opt - this.min;
    }

    public int getStretch() {
        return this.max - this.opt;
    }

    public MinOptMax plus(MinOptMax operand) {
        return new MinOptMax(this.min + operand.min, this.opt + operand.opt, this.max + operand.max);
    }

    public MinOptMax plus(int value2) {
        return new MinOptMax(this.min + value2, this.opt + value2, this.max + value2);
    }

    public MinOptMax minus(MinOptMax operand) throws ArithmeticException {
        this.checkCompatibility(this.getShrink(), operand.getShrink(), "shrink");
        this.checkCompatibility(this.getStretch(), operand.getStretch(), "stretch");
        return new MinOptMax(this.min - operand.min, this.opt - operand.opt, this.max - operand.max);
    }

    private void checkCompatibility(int thisElasticity, int operandElasticity, String msge) {
        if (thisElasticity < operandElasticity) {
            throw new ArithmeticException("Cannot subtract a MinOptMax from another MinOptMax that has less " + msge + " (" + thisElasticity + " < " + operandElasticity + ")");
        }
    }

    public MinOptMax minus(int value2) {
        return new MinOptMax(this.min - value2, this.opt - value2, this.max - value2);
    }

    public MinOptMax plusMin(int minOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min + minOperand, this.opt, this.max);
    }

    public MinOptMax minusMin(int minOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min - minOperand, this.opt, this.max);
    }

    public MinOptMax plusMax(int maxOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min, this.opt, this.max + maxOperand);
    }

    public MinOptMax minusMax(int maxOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min, this.opt, this.max - maxOperand);
    }

    public MinOptMax mult(int factor) throws IllegalArgumentException {
        if (factor < 0) {
            throw new IllegalArgumentException("factor < 0; was: " + factor);
        }
        if (factor == 1) {
            return this;
        }
        return MinOptMax.getInstance(this.min * factor, this.opt * factor, this.max * factor);
    }

    public boolean isNonZero() {
        return this.min != 0 || this.max != 0;
    }

    public boolean isStiff() {
        return this.min == this.max;
    }

    public boolean isElastic() {
        return this.min != this.opt || this.opt != this.max;
    }

    public MinOptMax extendMinimum(int newMin) {
        if (this.min < newMin) {
            int newOpt = Math.max(newMin, this.opt);
            int newMax = Math.max(newOpt, this.max);
            return MinOptMax.getInstance(newMin, newOpt, newMax);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MinOptMax minOptMax = (MinOptMax)obj;
        return this.opt == minOptMax.opt && this.max == minOptMax.max && this.min == minOptMax.min;
    }

    public int hashCode() {
        int result2 = this.min;
        result2 = 31 * result2 + this.opt;
        result2 = 31 * result2 + this.max;
        return result2;
    }

    public String toString() {
        return "MinOptMax[min = " + this.min + ", opt = " + this.opt + ", max = " + this.max + "]";
    }
}

