/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.AbstractElement;
import org.gedcom4j.model.Address;
import org.gedcom4j.model.Association;
import org.gedcom4j.model.ChangeDate;
import org.gedcom4j.model.FamilyChild;
import org.gedcom4j.model.FamilySpouse;
import org.gedcom4j.model.IndividualAttribute;
import org.gedcom4j.model.IndividualAttributeType;
import org.gedcom4j.model.IndividualEvent;
import org.gedcom4j.model.IndividualEventType;
import org.gedcom4j.model.LdsIndividualOrdinance;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.Note;
import org.gedcom4j.model.PersonalName;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.model.UserReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Individual
extends AbstractElement {
    public List<StringWithCustomTags> aliases = new ArrayList<StringWithCustomTags>();
    public List<Submitter> ancestorInterest = new ArrayList<Submitter>();
    public StringWithCustomTags ancestralFileNumber;
    public List<Association> associations = new ArrayList<Association>();
    public List<IndividualAttribute> attributes = new ArrayList<IndividualAttribute>();
    public ChangeDate changeDate;
    public List<AbstractCitation> citations = new ArrayList<AbstractCitation>();
    public List<Submitter> descendantInterest = new ArrayList<Submitter>();
    public List<IndividualEvent> events = new ArrayList<IndividualEvent>();
    public List<FamilyChild> familiesWhereChild = new ArrayList<FamilyChild>();
    public List<FamilySpouse> familiesWhereSpouse = new ArrayList<FamilySpouse>();
    public List<LdsIndividualOrdinance> ldsIndividualOrdinances = new ArrayList<LdsIndividualOrdinance>();
    public List<Multimedia> multimedia = new ArrayList<Multimedia>();
    public List<PersonalName> names = new ArrayList<PersonalName>();
    public List<Note> notes = new ArrayList<Note>();
    public StringWithCustomTags permanentRecFileNumber;
    public StringWithCustomTags recIdNumber;
    public StringWithCustomTags restrictionNotice;
    public StringWithCustomTags sex;
    public List<Submitter> submitters = new ArrayList<Submitter>();
    public List<UserReference> userReferences = new ArrayList<UserReference>();
    public String xref;
    public Address address;
    public List<StringWithCustomTags> phoneNumbers = new ArrayList<StringWithCustomTags>();
    public List<StringWithCustomTags> wwwUrls = new ArrayList<StringWithCustomTags>();
    public List<StringWithCustomTags> faxNumbers = new ArrayList<StringWithCustomTags>();
    public List<StringWithCustomTags> emails = new ArrayList<StringWithCustomTags>();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Individual other = (Individual)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.aliases == null ? other.aliases != null : !((Object)this.aliases).equals(other.aliases)) {
            return false;
        }
        if (this.ancestorInterest == null ? other.ancestorInterest != null : !((Object)this.ancestorInterest).equals(other.ancestorInterest)) {
            return false;
        }
        if (this.ancestralFileNumber == null ? other.ancestralFileNumber != null : !this.ancestralFileNumber.equals(other.ancestralFileNumber)) {
            return false;
        }
        if (this.associations == null ? other.associations != null : !((Object)this.associations).equals(other.associations)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !((Object)this.attributes).equals(other.attributes)) {
            return false;
        }
        if (this.changeDate == null ? other.changeDate != null : !this.changeDate.equals(other.changeDate)) {
            return false;
        }
        if (this.citations == null ? other.citations != null : !((Object)this.citations).equals(other.citations)) {
            return false;
        }
        if (this.descendantInterest == null ? other.descendantInterest != null : !((Object)this.descendantInterest).equals(other.descendantInterest)) {
            return false;
        }
        if (this.events == null ? other.events != null : !((Object)this.events).equals(other.events)) {
            return false;
        }
        if (this.familiesWhereChild == null ? other.familiesWhereChild != null : !((Object)this.familiesWhereChild).equals(other.familiesWhereChild)) {
            return false;
        }
        if (this.familiesWhereSpouse == null ? other.familiesWhereSpouse != null : !((Object)this.familiesWhereSpouse).equals(other.familiesWhereSpouse)) {
            return false;
        }
        if (this.ldsIndividualOrdinances == null ? other.ldsIndividualOrdinances != null : !((Object)this.ldsIndividualOrdinances).equals(other.ldsIndividualOrdinances)) {
            return false;
        }
        if (this.multimedia == null ? other.multimedia != null : !((Object)this.multimedia).equals(other.multimedia)) {
            return false;
        }
        if (this.names == null ? other.names != null : !((Object)this.names).equals(other.names)) {
            return false;
        }
        if (this.notes == null ? other.notes != null : !((Object)this.notes).equals(other.notes)) {
            return false;
        }
        if (this.permanentRecFileNumber == null ? other.permanentRecFileNumber != null : !this.permanentRecFileNumber.equals(other.permanentRecFileNumber)) {
            return false;
        }
        if (this.phoneNumbers == null ? other.phoneNumbers != null : !((Object)this.phoneNumbers).equals(other.phoneNumbers)) {
            return false;
        }
        if (this.wwwUrls == null ? other.wwwUrls != null : !((Object)this.wwwUrls).equals(other.wwwUrls)) {
            return false;
        }
        if (this.faxNumbers == null ? other.faxNumbers != null : !((Object)this.faxNumbers).equals(other.faxNumbers)) {
            return false;
        }
        if (this.emails == null ? other.emails != null : !((Object)this.emails).equals(other.emails)) {
            return false;
        }
        if (this.recIdNumber == null ? other.recIdNumber != null : !this.recIdNumber.equals(other.recIdNumber)) {
            return false;
        }
        if (this.restrictionNotice == null ? other.restrictionNotice != null : !this.restrictionNotice.equals(other.restrictionNotice)) {
            return false;
        }
        if (this.sex == null ? other.sex != null : !this.sex.equals(other.sex)) {
            return false;
        }
        if (this.submitters == null ? other.submitters != null : !((Object)this.submitters).equals(other.submitters)) {
            return false;
        }
        if (this.userReferences == null ? other.userReferences != null : !((Object)this.userReferences).equals(other.userReferences)) {
            return false;
        }
        return !(this.xref == null ? other.xref != null : !this.xref.equals(other.xref));
    }

    public String formattedName() {
        StringBuilder sb = new StringBuilder();
        for (PersonalName n : this.names) {
            if (sb.length() > 0) {
                sb.append(" aka ");
            }
            sb.append(n);
        }
        return sb.toString();
    }

    public Set<Individual> getAncestors() {
        HashSet<Individual> result2 = new HashSet<Individual>();
        for (FamilyChild f : this.familiesWhereChild) {
            if (f.family.husband != null) {
                result2.add(f.family.husband);
                result2.addAll(f.family.husband.getAncestors());
            }
            if (f.family.wife == null) continue;
            result2.add(f.family.wife);
            result2.addAll(f.family.wife.getAncestors());
        }
        return result2;
    }

    public List<IndividualAttribute> getAttributesOfType(IndividualAttributeType type) {
        ArrayList<IndividualAttribute> result2 = new ArrayList<IndividualAttribute>();
        for (IndividualAttribute ir : this.attributes) {
            if (ir.type != type) continue;
            result2.add(ir);
        }
        return result2;
    }

    public Set<Individual> getDescendants() {
        HashSet<Individual> result2 = new HashSet<Individual>();
        for (FamilySpouse f : this.familiesWhereSpouse) {
            result2.addAll(f.family.children);
            for (Individual i : f.family.children) {
                if (i == this || result2.contains(i)) continue;
                result2.addAll(i.getDescendants());
            }
        }
        return result2;
    }

    public List<IndividualEvent> getEventsOfType(IndividualEventType type) {
        ArrayList<IndividualEvent> result2 = new ArrayList<IndividualEvent>();
        for (IndividualEvent ie : this.events) {
            if (ie.type != type) continue;
            result2.add(ie);
        }
        return result2;
    }

    public Set<Individual> getSpouses() {
        HashSet<Individual> result2 = new HashSet<Individual>();
        for (FamilySpouse f : this.familiesWhereSpouse) {
            if (this != f.family.husband && f.family.husband != null) {
                result2.add(f.family.husband);
            }
            if (this == f.family.wife || f.family.wife == null) continue;
            result2.add(f.family.wife);
        }
        return result2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        if (this.xref != null) {
            return 31 * result2 + this.xref.hashCode();
        }
        result2 = 31 * result2;
        result2 = 31 * result2 + (this.address == null ? 0 : this.address.hashCode());
        result2 = 31 * result2 + (this.aliases == null ? 0 : ((Object)this.aliases).hashCode());
        result2 = 31 * result2 + (this.ancestorInterest == null ? 0 : ((Object)this.ancestorInterest).hashCode());
        result2 = 31 * result2 + (this.ancestralFileNumber == null ? 0 : this.ancestralFileNumber.hashCode());
        result2 = 31 * result2 + (this.associations == null ? 0 : ((Object)this.associations).hashCode());
        result2 = 31 * result2 + (this.attributes == null ? 0 : ((Object)this.attributes).hashCode());
        result2 = 31 * result2 + (this.changeDate == null ? 0 : this.changeDate.hashCode());
        result2 = 31 * result2 + (this.citations == null ? 0 : ((Object)this.citations).hashCode());
        result2 = 31 * result2 + (this.descendantInterest == null ? 0 : ((Object)this.descendantInterest).hashCode());
        result2 = 31 * result2 + (this.events == null ? 0 : ((Object)this.events).hashCode());
        result2 = 31 * result2 + (this.familiesWhereChild == null ? 0 : ((Object)this.familiesWhereChild).hashCode());
        result2 = 31 * result2 + (this.familiesWhereSpouse == null ? 0 : ((Object)this.familiesWhereSpouse).hashCode());
        result2 = 31 * result2 + (this.ldsIndividualOrdinances == null ? 0 : ((Object)this.ldsIndividualOrdinances).hashCode());
        result2 = 31 * result2 + (this.multimedia == null ? 0 : ((Object)this.multimedia).hashCode());
        result2 = 31 * result2 + (this.names == null ? 0 : ((Object)this.names).hashCode());
        result2 = 31 * result2 + (this.notes == null ? 0 : ((Object)this.notes).hashCode());
        result2 = 31 * result2 + (this.permanentRecFileNumber == null ? 0 : this.permanentRecFileNumber.hashCode());
        result2 = 31 * result2 + (this.phoneNumbers == null ? 0 : ((Object)this.phoneNumbers).hashCode());
        result2 = 31 * result2 + (this.faxNumbers == null ? 0 : ((Object)this.faxNumbers).hashCode());
        result2 = 31 * result2 + (this.wwwUrls == null ? 0 : ((Object)this.wwwUrls).hashCode());
        result2 = 31 * result2 + (this.emails == null ? 0 : ((Object)this.emails).hashCode());
        result2 = 31 * result2 + (this.recIdNumber == null ? 0 : this.recIdNumber.hashCode());
        result2 = 31 * result2 + (this.restrictionNotice == null ? 0 : this.restrictionNotice.hashCode());
        result2 = 31 * result2 + (this.sex == null ? 0 : this.sex.hashCode());
        result2 = 31 * result2 + (this.submitters == null ? 0 : ((Object)this.submitters).hashCode());
        result2 = 31 * result2 + (this.userReferences == null ? 0 : ((Object)this.userReferences).hashCode());
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formattedName());
        for (StringWithCustomTags stringWithCustomTags : this.aliases) {
            if (sb.length() > 0) {
                sb.append(" aka ");
            }
            sb.append(stringWithCustomTags);
        }
        if (sb.length() == 0) {
            sb.append("Unknown name");
        }
        for (FamilySpouse familySpouse : this.familiesWhereSpouse) {
            sb.append(", spouse of ");
            if (familySpouse.family.husband == this) {
                if (familySpouse.family.wife == null) {
                    sb.append("unknown");
                    continue;
                }
                sb.append(familySpouse.family.wife.formattedName());
                continue;
            }
            if (familySpouse.family.husband == null) {
                sb.append("unknown");
                continue;
            }
            sb.append(familySpouse.family.husband.formattedName());
        }
        for (FamilyChild familyChild : this.familiesWhereChild) {
            sb.append(", child of ");
            if (familyChild.family.wife != null) {
                sb.append(familyChild.family.wife.formattedName());
                sb.append(" and ");
            }
            if (familyChild.family.husband == null) {
                sb.append("unknown");
                continue;
            }
            sb.append(familyChild.family.husband.formattedName());
        }
        boolean found = false;
        for (IndividualEvent b : this.getEventsOfType(IndividualEventType.BIRTH)) {
            if (!found) {
                sb.append(", b.");
            } else {
                sb.append(" / ");
            }
            sb.append(b.date);
            found = true;
        }
        for (IndividualEvent d : this.getEventsOfType(IndividualEventType.DEATH)) {
            if (!found) {
                sb.append(", d.");
            } else {
                sb.append(" / ");
            }
            sb.append(d.date);
            found = true;
        }
        return sb.toString();
    }
}

