/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.AbstractElement;
import org.gedcom4j.model.Address;
import org.gedcom4j.model.AdoptedByWhichParent;
import org.gedcom4j.model.Association;
import org.gedcom4j.model.ChangeDate;
import org.gedcom4j.model.CharacterSet;
import org.gedcom4j.model.CitationData;
import org.gedcom4j.model.CitationWithSource;
import org.gedcom4j.model.CitationWithoutSource;
import org.gedcom4j.model.Corporation;
import org.gedcom4j.model.EventRecorded;
import org.gedcom4j.model.Family;
import org.gedcom4j.model.FamilyChild;
import org.gedcom4j.model.FamilyEvent;
import org.gedcom4j.model.FamilyEventType;
import org.gedcom4j.model.FamilySpouse;
import org.gedcom4j.model.FileReference;
import org.gedcom4j.model.Gedcom;
import org.gedcom4j.model.GedcomVersion;
import org.gedcom4j.model.Header;
import org.gedcom4j.model.HeaderSourceData;
import org.gedcom4j.model.Individual;
import org.gedcom4j.model.IndividualAttribute;
import org.gedcom4j.model.IndividualAttributeType;
import org.gedcom4j.model.IndividualEvent;
import org.gedcom4j.model.IndividualEventType;
import org.gedcom4j.model.LdsIndividualOrdinance;
import org.gedcom4j.model.LdsIndividualOrdinanceType;
import org.gedcom4j.model.LdsSpouseSealing;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.NameVariation;
import org.gedcom4j.model.Note;
import org.gedcom4j.model.PersonalName;
import org.gedcom4j.model.PersonalNameVariation;
import org.gedcom4j.model.Place;
import org.gedcom4j.model.Repository;
import org.gedcom4j.model.RepositoryCitation;
import org.gedcom4j.model.Source;
import org.gedcom4j.model.SourceCallNumber;
import org.gedcom4j.model.SourceData;
import org.gedcom4j.model.SourceSystem;
import org.gedcom4j.model.StringTree;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submission;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.model.SupportedVersion;
import org.gedcom4j.model.Trailer;
import org.gedcom4j.model.UnsupportedVersionException;
import org.gedcom4j.model.UserReference;
import org.gedcom4j.parser.GedcomParserException;
import org.gedcom4j.parser.GedcomParserHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomParser {
    public Gedcom gedcom = new Gedcom();
    public List<String> errors = new ArrayList<String>();
    public List<String> warnings = new ArrayList<String>();
    public boolean verbose = false;

    private boolean g55() {
        return this.gedcom != null && this.gedcom.header != null && this.gedcom.header.gedcomVersion != null && SupportedVersion.V5_5.equals((Object)this.gedcom.header.gedcomVersion.versionNumber);
    }

    private Family getFamily(String xref) {
        Family f = this.gedcom.families.get(xref);
        if (f == null) {
            f = new Family();
            f.xref = xref;
            this.gedcom.families.put(xref, f);
        }
        return f;
    }

    private Individual getIndividual(String xref) {
        Individual i = this.gedcom.individuals.get(xref);
        if (i == null) {
            i = new Individual();
            i.xref = xref;
            this.gedcom.individuals.put(xref, i);
        }
        return i;
    }

    private Multimedia getMultimedia(String xref) {
        Multimedia m = this.gedcom.multimedia.get(xref);
        if (m == null) {
            m = new Multimedia();
            m.xref = xref;
            this.gedcom.multimedia.put(xref, m);
        }
        return m;
    }

    private Note getNote(String xref) {
        Note note = this.gedcom.notes.get(xref);
        if (note == null) {
            note = new Note();
            note.xref = xref;
            this.gedcom.notes.put(xref, note);
        }
        return note;
    }

    private Repository getRepository(String xref) {
        Repository r = this.gedcom.repositories.get(xref);
        if (r == null) {
            r = new Repository();
            r.xref = xref;
            this.gedcom.repositories.put(xref, r);
        }
        return r;
    }

    private Source getSource(String xref) {
        Source src = this.gedcom.sources.get(xref);
        if (src == null) {
            src = new Source(xref);
            this.gedcom.sources.put(src.xref, src);
        }
        return src;
    }

    private Submitter getSubmitter(String xref) {
        Submitter i = this.gedcom.submitters.get(xref);
        if (i == null) {
            i = new Submitter();
            i.xref = xref;
            this.gedcom.submitters.put(xref, i);
        }
        return i;
    }

    private void loadAddress(StringTree st, Address address) {
        if (st.value != null) {
            address.lines.add(st.value);
        }
        for (StringTree ch : st.children) {
            if ("ADR1".equals(ch.tag)) {
                address.addr1 = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADR2".equals(ch.tag)) {
                address.addr2 = new StringWithCustomTags(ch);
                continue;
            }
            if ("CITY".equals(ch.tag)) {
                address.city = new StringWithCustomTags(ch);
                continue;
            }
            if ("STAE".equals(ch.tag)) {
                address.stateProvince = new StringWithCustomTags(ch);
                continue;
            }
            if ("POST".equals(ch.tag)) {
                address.postalCode = new StringWithCustomTags(ch);
                continue;
            }
            if ("CTRY".equals(ch.tag)) {
                address.country = new StringWithCustomTags(ch);
                continue;
            }
            if ("CONC".equals(ch.tag)) {
                if (address.lines.size() == 0) {
                    address.lines.add(ch.value);
                    continue;
                }
                address.lines.set(address.lines.size() - 1, address.lines.get(address.lines.size() - 1) + ch.value);
                continue;
            }
            if ("CONT".equals(ch.tag)) {
                address.lines.add(ch.value == null ? "" : ch.value);
                continue;
            }
            this.unknownTag(ch, address);
        }
    }

    private void loadAssociation(StringTree st, List<Association> associations) {
        Association a = new Association();
        associations.add(a);
        a.associatedEntityXref = st.value;
        for (StringTree ch : st.children) {
            if ("RELA".equals(ch.tag)) {
                a.relationship = new StringWithCustomTags(ch);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, a.notes);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, a.citations);
                continue;
            }
            if ("TYPE".equals(ch.tag)) {
                a.associatedEntityType = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, a);
        }
    }

    private void loadChangeDate(StringTree st, ChangeDate changeDate) {
        for (StringTree ch : st.children) {
            if ("DATE".equals(ch.tag)) {
                changeDate.date = new StringWithCustomTags(ch.value);
                if (ch.children.isEmpty()) continue;
                changeDate.time = new StringWithCustomTags(ch.children.get(0));
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, changeDate.notes);
                continue;
            }
            this.unknownTag(ch, changeDate);
        }
    }

    private void loadCitation(StringTree st, List<AbstractCitation> list2) {
        AbstractCitation citation;
        if (GedcomParserHelper.referencesAnotherNode(st)) {
            citation = new CitationWithSource();
            this.loadCitationWithSource(st, citation);
        } else {
            citation = new CitationWithoutSource();
            this.loadCitationWithoutSource(st, citation);
        }
        list2.add(citation);
    }

    private void loadCitationData(StringTree st, CitationData d) {
        for (StringTree ch : st.children) {
            if ("DATE".equals(ch.tag)) {
                d.entryDate = new StringWithCustomTags(ch);
                continue;
            }
            if ("TEXT".equals(ch.tag)) {
                ArrayList<String> ls = new ArrayList<String>();
                d.sourceText.add(ls);
                this.loadMultiLinesOfText(ch, ls, d);
                continue;
            }
            this.unknownTag(ch, d);
        }
    }

    private void loadCitationWithoutSource(StringTree st, AbstractCitation citation) {
        CitationWithoutSource cws = (CitationWithoutSource)citation;
        cws.description.add(st.value);
        for (StringTree ch : st.children) {
            if ("CONT".equals(ch.tag)) {
                cws.description.add(ch.value == null ? "" : ch.value);
                continue;
            }
            if ("CONC".equals(ch.tag)) {
                if (cws.description.size() == 0) {
                    cws.description.add(ch.value);
                    continue;
                }
                cws.description.set(cws.description.size() - 1, cws.description.get(cws.description.size() - 1) + ch.value);
                continue;
            }
            if ("TEXT".equals(ch.tag)) {
                ArrayList<String> ls = new ArrayList<String>();
                cws.textFromSource.add(ls);
                this.loadMultiLinesOfText(ch, ls, cws);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, cws.notes);
                continue;
            }
            this.unknownTag(ch, citation);
        }
    }

    private void loadCitationWithSource(StringTree st, AbstractCitation citation) {
        CitationWithSource cws = (CitationWithSource)citation;
        Source src = null;
        if (GedcomParserHelper.referencesAnotherNode(st)) {
            src = this.getSource(st.value);
        }
        cws.source = src;
        for (StringTree ch : st.children) {
            if ("PAGE".equals(ch.tag)) {
                cws.whereInSource = new StringWithCustomTags(ch);
                continue;
            }
            if ("EVEN".equals(ch.tag)) {
                cws.eventCited = new StringWithCustomTags(ch.value);
                if (ch.children == null) continue;
                for (StringTree gc : ch.children) {
                    if ("ROLE".equals(gc.tag)) {
                        cws.roleInEvent = new StringWithCustomTags(gc);
                        continue;
                    }
                    this.unknownTag(gc, cws.eventCited);
                }
                continue;
            }
            if ("DATA".equals(ch.tag)) {
                CitationData d = new CitationData();
                cws.data.add(d);
                this.loadCitationData(ch, d);
                continue;
            }
            if ("QUAY".equals(ch.tag)) {
                cws.certainty = new StringWithCustomTags(ch);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, cws.notes);
                continue;
            }
            this.unknownTag(ch, citation);
        }
    }

    private void loadCorporation(StringTree st, Corporation corporation) {
        corporation.businessName = st.value;
        for (StringTree ch : st.children) {
            if ("ADDR".equals(ch.tag)) {
                corporation.address = new Address();
                this.loadAddress(ch, corporation.address);
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                corporation.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                corporation.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL was specified for the corporation in the source system on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                corporation.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax number was specified for the corporation in the source system on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                corporation.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but emails was specified for the corporation in the source system on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            this.unknownTag(ch, corporation);
        }
    }

    private void loadFamily(StringTree st) {
        Family f = this.getFamily(st.id);
        for (StringTree ch : st.children) {
            if ("HUSB".equals(ch.tag)) {
                f.husband = this.getIndividual(ch.value);
                continue;
            }
            if ("WIFE".equals(ch.tag)) {
                f.wife = this.getIndividual(ch.value);
                continue;
            }
            if ("CHIL".equals(ch.tag)) {
                f.children.add(this.getIndividual(ch.value));
                continue;
            }
            if ("NCHI".equals(ch.tag)) {
                f.numChildren = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, f.citations);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, f.multimedia);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                f.automatedRecordId = new StringWithCustomTags(ch);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                f.changeDate = new ChangeDate();
                this.loadChangeDate(ch, f.changeDate);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, f.notes);
                continue;
            }
            if ("RESN".equals(ch.tag)) {
                f.restrictionNotice = new StringWithCustomTags(ch);
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but restriction notice was specified for family on line " + ch.lineNum + " , which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("RFN".equals(ch.tag)) {
                f.recFileNumber = new StringWithCustomTags(ch);
                continue;
            }
            if (FamilyEventType.isValidTag(ch.tag)) {
                this.loadFamilyEvent(ch, f.events);
                continue;
            }
            if ("SLGS".equals(ch.tag)) {
                this.loadLdsSpouseSealing(ch, f.ldsSpouseSealings);
                continue;
            }
            if ("SUBM".equals(ch.tag)) {
                f.submitters.add(this.getSubmitter(ch.value));
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                f.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            this.unknownTag(ch, f);
        }
    }

    private void loadFamilyEvent(StringTree st, List<FamilyEvent> events2) {
        FamilyEvent e = new FamilyEvent();
        events2.add(e);
        e.type = FamilyEventType.getFromTag(st.tag);
        e.yNull = st.value;
        for (StringTree ch : st.children) {
            if ("TYPE".equals(ch.tag)) {
                e.subType = new StringWithCustomTags(ch);
                continue;
            }
            if ("DATE".equals(ch.tag)) {
                e.date = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                e.place = new Place();
                this.loadPlace(ch, e.place);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, e.multimedia);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, e.notes);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, e.citations);
                continue;
            }
            if ("RESN".equals(ch.tag)) {
                e.restrictionNotice = new StringWithCustomTags(ch);
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but restriction notice was specified for family event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("RELI".equals(ch.tag)) {
                e.religiousAffiliation = new StringWithCustomTags(ch);
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but religious affiliation was specified for family event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("AGE".equals(ch.tag)) {
                e.age = new StringWithCustomTags(ch);
                continue;
            }
            if ("CAUS".equals(ch.tag)) {
                e.cause = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADDR".equals(ch.tag)) {
                e.address = new Address();
                this.loadAddress(ch, e.address);
                continue;
            }
            if ("AGNC".equals(ch.tag)) {
                e.respAgency = new StringWithCustomTags(ch);
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                e.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                e.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL was specified for " + (Object)((Object)e.type) + " family event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                e.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax number was specified for " + (Object)((Object)e.type) + " family event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                e.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but email was specified for " + (Object)((Object)e.type) + " family event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("HUSB".equals(ch.tag)) {
                e.husbandAge = new StringWithCustomTags(ch.children.get(0));
                continue;
            }
            if ("WIFE".equals(ch.tag)) {
                e.wifeAge = new StringWithCustomTags(ch.children.get(0));
                continue;
            }
            this.unknownTag(ch, e);
        }
    }

    private void loadFamilyWhereChild(StringTree st, List<FamilyChild> familiesWhereChild) {
        Family f = this.getFamily(st.value);
        FamilyChild fc = new FamilyChild();
        familiesWhereChild.add(fc);
        fc.family = f;
        for (StringTree ch : st.children) {
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, fc.notes);
                continue;
            }
            if ("PEDI".equals(ch.tag)) {
                fc.pedigree = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADOP".equals(ch.tag)) {
                fc.adoptedBy = AdoptedByWhichParent.valueOf(ch.value);
                continue;
            }
            if ("STAT".equals(ch.tag)) {
                fc.status = new StringWithCustomTags(ch);
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but status was specified for child-to-family link on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            this.unknownTag(ch, fc);
        }
    }

    private void loadFamilyWhereSpouse(StringTree st, List<FamilySpouse> familiesWhereSpouse2) {
        Family f = this.getFamily(st.value);
        FamilySpouse fs = new FamilySpouse();
        fs.family = f;
        familiesWhereSpouse2.add(fs);
        for (StringTree ch : st.children) {
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, fs.notes);
                continue;
            }
            this.unknownTag(ch, fs);
        }
    }

    private void loadFileReference55(Multimedia m, List<StringTree> children2) {
        FileReference currentFileRef = new FileReference();
        m.fileReferences.add(currentFileRef);
        for (StringTree ch : children2) {
            if ("FORM".equals(ch.tag)) {
                currentFileRef.format = new StringWithCustomTags(ch);
                continue;
            }
            if ("TITL".equals(ch.tag)) {
                m.embeddedTitle = new StringWithCustomTags(ch);
                continue;
            }
            if ("FILE".equals(ch.tag)) {
                currentFileRef.referenceToFile = new StringWithCustomTags(ch);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, m.notes);
                continue;
            }
            this.unknownTag(ch, m);
        }
    }

    private void loadFileReferences(Multimedia m, StringTree st) {
        int fileTagCount = 0;
        int formTagCount = 0;
        for (StringTree ch : st.children) {
            if ("FILE".equals(ch.tag)) {
                ++fileTagCount;
            }
            if (!"FORM".equals(ch.tag)) continue;
            ++formTagCount;
        }
        if (fileTagCount > 1 && this.g55()) {
            this.warnings.add("GEDCOM version is 5.5, but multiple files referenced in multimedia reference on line " + st.lineNum + ", which is only allowed in 5.5.1. " + "Data will be loaded, but cannot be written back out unless the GEDCOM version is changed to 5.5.1");
        }
        if (formTagCount == 0 && this.g55()) {
            this.warnings.add("GEDCOM version is 5.5, but there is not a FORM tag in the multimedia link on line " + st.lineNum + ", a scenario which is only allowed in 5.5.1. " + "Data will be loaded, but cannot be written back out unless the GEDCOM version is changed to 5.5.1");
        }
        if (formTagCount > 1) {
            this.errors.add("Multiple FORM tags were found for a multimedia file reference at line " + st.lineNum + " - this is not compliant with any GEDCOM standard - data not loaded");
            return;
        }
        if (fileTagCount > 1 || formTagCount < fileTagCount) {
            this.loadFileReferences551(m, st.children);
        } else {
            this.loadFileReference55(m, st.children);
        }
    }

    private void loadFileReferences551(Multimedia m, List<StringTree> children2) {
        for (StringTree ch : children2) {
            if ("FILE".equals(ch.tag)) {
                FileReference fr = new FileReference();
                m.fileReferences.add(fr);
                fr.referenceToFile = new StringWithCustomTags(ch);
                if (ch.children.size() != 1) {
                    this.errors.add("Missing or multiple children nodes found under FILE node - GEDCOM 5.5.1 standard requires exactly 1 FORM node");
                }
                for (StringTree gch : ch.children) {
                    if ("FORM".equals(gch.tag)) {
                        fr.format = new StringWithCustomTags(gch.value);
                        for (StringTree ggch : ch.children) {
                            if ("MEDI".equals(ggch.tag)) {
                                fr.mediaType = new StringWithCustomTags(ggch);
                                continue;
                            }
                            this.unknownTag(ggch, fr);
                        }
                        continue;
                    }
                    this.unknownTag(gch, fr);
                }
                continue;
            }
            if ("TITL".equals(ch.tag)) {
                for (FileReference fr : m.fileReferences) {
                    fr.title = new StringWithCustomTags(ch.tag);
                }
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, m.notes);
                if (this.g55()) continue;
                this.warnings.add("Gedcom version was 5.5.1, but a NOTE was found on a multimedia link on line " + ch.lineNum + ", which is no longer supported. " + "Data will be loaded, but cannot be written back out unless the GEDCOM version is changed to 5.5");
                continue;
            }
            this.unknownTag(ch, m);
        }
    }

    private void loadGedcomVersion(StringTree st, GedcomVersion gedcomVersion) {
        for (StringTree ch : st.children) {
            if ("VERS".equals(ch.tag)) {
                SupportedVersion vn = null;
                try {
                    vn = SupportedVersion.forString(ch.value);
                }
                catch (UnsupportedVersionException e) {
                    this.errors.add(e.getMessage());
                }
                gedcomVersion.versionNumber = vn;
                continue;
            }
            if ("FORM".equals(ch.tag)) {
                gedcomVersion.gedcomForm = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, gedcomVersion);
        }
    }

    private void loadHeader(StringTree st) {
        Header header;
        this.gedcom.header = header = new Header();
        for (StringTree ch : st.children) {
            if ("SOUR".equals(ch.tag)) {
                header.sourceSystem = new SourceSystem();
                this.loadSourceSystem(ch, header.sourceSystem);
                continue;
            }
            if ("DEST".equals(ch.tag)) {
                header.destinationSystem = new StringWithCustomTags(ch);
                continue;
            }
            if ("DATE".equals(ch.tag)) {
                header.date = new StringWithCustomTags(ch);
                if (ch.children.isEmpty()) continue;
                header.time = new StringWithCustomTags(ch.children.get(0));
                continue;
            }
            if ("CHAR".equals(ch.tag)) {
                header.characterSet = new CharacterSet();
                header.characterSet.characterSetName = new StringWithCustomTags(ch);
                if (ch.children.isEmpty()) continue;
                header.characterSet.versionNum = new StringWithCustomTags(ch.children.get(0));
                continue;
            }
            if ("SUBM".equals(ch.tag)) {
                header.submitter = this.getSubmitter(ch.value);
                continue;
            }
            if ("FILE".equals(ch.tag)) {
                header.fileName = new StringWithCustomTags(ch);
                continue;
            }
            if ("GEDC".equals(ch.tag)) {
                header.gedcomVersion = new GedcomVersion();
                this.loadGedcomVersion(ch, header.gedcomVersion);
                continue;
            }
            if ("COPR".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, header.copyrightData, header);
                if (!this.g55() || header.copyrightData.size() <= 1) continue;
                this.warnings.add("GEDCOM version is 5.5, but multiple lines of copyright data were specified, which is only allowed in GEDCOM 5.5.1.   Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("SUBN".equals(ch.tag)) {
                if (header.submission != null) continue;
                header.submission = this.gedcom.submission;
                continue;
            }
            if ("LANG".equals(ch.tag)) {
                header.language = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                header.placeHierarchy = new StringWithCustomTags(ch.children.get(0));
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, header.notes, header);
                continue;
            }
            this.unknownTag(ch, header);
        }
    }

    private void loadHeaderSourceData(StringTree st, HeaderSourceData sourceData) {
        sourceData.name = st.value;
        for (StringTree ch : st.children) {
            if ("DATE".equals(ch.tag)) {
                sourceData.publishDate = new StringWithCustomTags(ch);
                continue;
            }
            if ("COPR".equals(ch.tag)) {
                sourceData.copyright = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, sourceData);
        }
    }

    private void loadIndividual(StringTree st) {
        Individual i = new Individual();
        this.gedcom.individuals.put(st.id, i);
        i.xref = st.id;
        for (StringTree ch : st.children) {
            if ("NAME".equals(ch.tag)) {
                PersonalName pn = new PersonalName();
                i.names.add(pn);
                this.loadPersonalName(ch, pn);
                continue;
            }
            if ("SEX".equals(ch.tag)) {
                i.sex = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADDR".equals(ch.tag)) {
                i.address = new Address();
                this.loadAddress(ch, i.address);
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                i.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                i.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL was specified for individual " + i.xref + " on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                i.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax was specified for individual " + i.xref + "on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                i.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but email was specified for individual " + i.xref + " on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if (IndividualEventType.isValidTag(ch.tag)) {
                this.loadIndividualEvent(ch, i.events);
                continue;
            }
            if (IndividualAttributeType.isValidTag(ch.tag)) {
                this.loadIndividualAttribute(ch, i.attributes);
                continue;
            }
            if (LdsIndividualOrdinanceType.isValidTag(ch.tag)) {
                this.loadLdsIndividualOrdinance(ch, i.ldsIndividualOrdinances);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, i.notes);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                i.changeDate = new ChangeDate();
                this.loadChangeDate(ch, i.changeDate);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                i.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("RFN".equals(ch.tag)) {
                i.permanentRecFileNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, i.multimedia);
                continue;
            }
            if ("RESN".equals(ch.tag)) {
                i.restrictionNotice = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, i.citations);
                continue;
            }
            if ("ALIA".equals(ch.tag)) {
                i.aliases.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("FAMS".equals(ch.tag)) {
                this.loadFamilyWhereSpouse(ch, i.familiesWhereSpouse);
                continue;
            }
            if ("FAMC".equals(ch.tag)) {
                this.loadFamilyWhereChild(ch, i.familiesWhereChild);
                continue;
            }
            if ("ASSO".equals(ch.tag)) {
                this.loadAssociation(ch, i.associations);
                continue;
            }
            if ("ANCI".equals(ch.tag)) {
                i.ancestorInterest.add(this.getSubmitter(ch.value));
                continue;
            }
            if ("DESI".equals(ch.tag)) {
                i.descendantInterest.add(this.getSubmitter(ch.value));
                continue;
            }
            if ("AFN".equals(ch.tag)) {
                i.ancestralFileNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                i.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            if ("SUBM".equals(ch.tag)) {
                i.submitters.add(this.getSubmitter(ch.value));
                continue;
            }
            this.unknownTag(ch, i);
        }
    }

    private void loadIndividualAttribute(StringTree st, List<IndividualAttribute> attributes) {
        IndividualAttribute a = new IndividualAttribute();
        attributes.add(a);
        a.type = IndividualAttributeType.getFromTag(st.tag);
        if (IndividualAttributeType.FACT.equals((Object)a.type) && this.g55()) {
            this.warnings.add("FACT tag specified on a GEDCOM 5.5 file at line " + st.lineNum + ", but FACT was not added until 5.5.1." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
        }
        a.description = new StringWithCustomTags(st.value);
        for (StringTree ch : st.children) {
            if ("TYPE".equals(ch.tag)) {
                a.subType = new StringWithCustomTags(ch);
                continue;
            }
            if ("DATE".equals(ch.tag)) {
                a.date = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                a.place = new Place();
                this.loadPlace(ch, a.place);
                continue;
            }
            if ("AGE".equals(ch.tag)) {
                a.age = new StringWithCustomTags(ch);
                continue;
            }
            if ("CAUS".equals(ch.tag)) {
                a.cause = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, a.citations);
                continue;
            }
            if ("AGNC".equals(ch.tag)) {
                a.respAgency = new StringWithCustomTags(ch);
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                a.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                a.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL was specified for " + (Object)((Object)a.type) + " attribute on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                a.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax was specified for " + (Object)((Object)a.type) + " attribute on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                a.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but email was specified for " + (Object)((Object)a.type) + " attribute on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("ADDR".equals(ch.tag)) {
                a.address = new Address();
                this.loadAddress(ch, a.address);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, a.multimedia);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, a.notes);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, a.citations);
                continue;
            }
            if ("CONC".equals(ch.tag)) {
                if (a.description == null) {
                    a.description = new StringWithCustomTags(ch);
                    continue;
                }
                a.description.value = a.description.value + ch.value;
                continue;
            }
            this.unknownTag(ch, a);
        }
    }

    private void loadIndividualEvent(StringTree st, List<IndividualEvent> events2) {
        IndividualEvent e = new IndividualEvent();
        events2.add(e);
        e.type = IndividualEventType.getFromTag(st.tag);
        e.yNull = st.value;
        for (StringTree ch : st.children) {
            if ("TYPE".equals(ch.tag)) {
                e.subType = new StringWithCustomTags(ch);
                continue;
            }
            if ("DATE".equals(ch.tag)) {
                e.date = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                e.place = new Place();
                this.loadPlace(ch, e.place);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, e.multimedia);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, e.notes);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, e.citations);
                continue;
            }
            if ("AGE".equals(ch.tag)) {
                e.age = new StringWithCustomTags(ch);
                continue;
            }
            if ("CAUS".equals(ch.tag)) {
                e.cause = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADDR".equals(ch.tag)) {
                e.address = new Address();
                this.loadAddress(ch, e.address);
                continue;
            }
            if ("AGNC".equals(ch.tag)) {
                e.respAgency = new StringWithCustomTags(ch);
                continue;
            }
            if ("RESN".equals(ch.tag)) {
                e.restrictionNotice = new StringWithCustomTags(ch);
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but restriction notice was specified for individual event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("RELI".equals(ch.tag)) {
                e.religiousAffiliation = new StringWithCustomTags(ch);
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but religious affiliation was specified for individual event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                e.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                e.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL was specified on " + (Object)((Object)e.type) + " event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                e.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax was specified on " + (Object)((Object)e.type) + " event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                e.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but email was specified on " + (Object)((Object)e.type) + " event on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("CONC".equals(ch.tag)) {
                if (e.description == null) {
                    e.description = new StringWithCustomTags(ch);
                    continue;
                }
                e.description.value = e.description.value + ch.value;
                continue;
            }
            if ("CONT".equals(ch.tag)) {
                if (e.description == null) {
                    e.description = new StringWithCustomTags(ch.value == null ? "" : ch.value);
                    continue;
                }
                e.description.value = e.description.value + "\n" + ch.value;
                continue;
            }
            if ("FAMC".equals(ch.tag)) {
                ArrayList<FamilyChild> families = new ArrayList<FamilyChild>();
                this.loadFamilyWhereChild(ch, families);
                if (families.isEmpty()) continue;
                e.family = (FamilyChild)families.get(0);
                continue;
            }
            this.unknownTag(ch, e);
        }
    }

    private void loadLdsIndividualOrdinance(StringTree st, List<LdsIndividualOrdinance> ldsIndividualOrdinances) {
        LdsIndividualOrdinance o = new LdsIndividualOrdinance();
        ldsIndividualOrdinances.add(o);
        o.type = LdsIndividualOrdinanceType.getFromTag(st.tag);
        o.yNull = st.value;
        for (StringTree ch : st.children) {
            if ("DATE".equals(ch.tag)) {
                o.date = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                o.place = new StringWithCustomTags(ch);
                continue;
            }
            if ("STAT".equals(ch.tag)) {
                o.status = new StringWithCustomTags(ch);
                continue;
            }
            if ("TEMP".equals(ch.tag)) {
                o.temple = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, o.citations);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, o.notes);
                continue;
            }
            if ("FAMC".equals(ch.tag)) {
                ArrayList<FamilyChild> families = new ArrayList<FamilyChild>();
                this.loadFamilyWhereChild(ch, families);
                if (families.isEmpty()) continue;
                o.familyWhereChild = (FamilyChild)families.get(0);
                continue;
            }
            this.unknownTag(ch, o);
        }
    }

    private void loadLdsSpouseSealing(StringTree st, List<LdsSpouseSealing> ldsSpouseSealings) {
        LdsSpouseSealing o = new LdsSpouseSealing();
        ldsSpouseSealings.add(o);
        for (StringTree ch : st.children) {
            if ("DATE".equals(ch.tag)) {
                o.date = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                o.place = new StringWithCustomTags(ch);
                continue;
            }
            if ("STAT".equals(ch.tag)) {
                o.status = new StringWithCustomTags(ch);
                continue;
            }
            if ("TEMP".equals(ch.tag)) {
                o.temple = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, o.citations);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, o.notes);
                continue;
            }
            this.unknownTag(ch, o);
        }
    }

    private void loadMultiLinesOfText(StringTree st, List<String> listOfString, AbstractElement element) {
        if (st.value != null) {
            listOfString.add(st.value);
        }
        for (StringTree ch : st.children) {
            if ("CONT".equals(ch.tag)) {
                if (ch.value == null) {
                    listOfString.add("");
                    continue;
                }
                listOfString.add(ch.value);
                continue;
            }
            if ("CONC".equals(ch.tag)) {
                if (ch.value == null) continue;
                if (listOfString.size() == 0) {
                    listOfString.add(ch.value);
                    continue;
                }
                listOfString.set(listOfString.size() - 1, listOfString.get(listOfString.size() - 1) + ch.value);
                continue;
            }
            this.unknownTag(ch, element);
        }
    }

    private void loadMultimediaLink(StringTree st, List<Multimedia> multimedia) {
        Multimedia m = null;
        if (GedcomParserHelper.referencesAnotherNode(st)) {
            m = this.getMultimedia(st.value);
        } else {
            m = new Multimedia();
            this.loadFileReferences(m, st);
        }
        multimedia.add(m);
    }

    private void loadMultimediaRecord(StringTree st) {
        int fileTagCount = 0;
        for (StringTree ch : st.children) {
            if (!"FILE".equals(ch.tag)) continue;
            ++fileTagCount;
        }
        if (fileTagCount > 0) {
            if (this.g55()) {
                this.warnings.add("GEDCOM version was 5.5, but a 5.5.1-style multimedia record was found at line " + st.lineNum + ". " + "Data will be loaded, but might have problems being written until the version is for the data is changed to 5.5.1");
            }
            this.loadMultimediaRecord551(st);
        } else {
            if (!this.g55()) {
                this.warnings.add("GEDCOM version is 5.5.1, but a 5.5-style multimedia record was found at line " + st.lineNum + ". " + "Data will be loaded, but might have problems being written until the version is for the data is changed to 5.5.1");
            }
            this.loadMultimediaRecord55(st);
        }
    }

    private void loadMultimediaRecord55(StringTree st) {
        Multimedia m = this.getMultimedia(st.id);
        for (StringTree ch : st.children) {
            if ("FORM".equals(ch.tag)) {
                m.embeddedMediaFormat = new StringWithCustomTags(ch);
                continue;
            }
            if ("TITL".equals(ch.tag)) {
                m.embeddedTitle = new StringWithCustomTags(ch);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, m.notes);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, m.citations);
                continue;
            }
            if ("BLOB".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, m.blob, m);
                if (this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5.1, but a BLOB tag was found at line " + ch.lineNum + ". " + "Data will be loaded but will not be writeable unless GEDCOM version is changed to 5.5.1");
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                ArrayList<Multimedia> continuedObjects = new ArrayList<Multimedia>();
                this.loadMultimediaLink(ch, continuedObjects);
                m.continuedObject = (Multimedia)continuedObjects.get(0);
                if (this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5.1, but a chained OBJE tag was found at line " + ch.lineNum + ". " + "Data will be loaded but will not be writeable unless GEDCOM version is changed to 5.5.1");
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                m.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                m.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                m.changeDate = new ChangeDate();
                this.loadChangeDate(ch, m.changeDate);
                continue;
            }
            this.unknownTag(ch, m);
        }
    }

    private void loadMultimediaRecord551(StringTree st) {
        Multimedia m = this.getMultimedia(st.id);
        for (StringTree ch : st.children) {
            if ("FILE".equals(ch.tag)) {
                FileReference fr = new FileReference();
                m.fileReferences.add(fr);
                fr.referenceToFile = new StringWithCustomTags(ch);
                for (StringTree gch : ch.children) {
                    if ("FORM".equals(gch.tag)) {
                        fr.format = new StringWithCustomTags(gch.value);
                        if (gch.children.size() != 1) continue;
                        StringTree ggch = gch.children.get(0);
                        if ("TYPE".equals(ggch.tag)) {
                            fr.mediaType = new StringWithCustomTags(ggch);
                            continue;
                        }
                        this.unknownTag(ggch, fr);
                        continue;
                    }
                    if ("TITL".equals(gch.tag)) {
                        fr.title = new StringWithCustomTags(gch);
                        continue;
                    }
                    this.unknownTag(gch, fr);
                }
                if (fr.format != null) continue;
                this.errors.add("FORM tag not found under FILE reference on line " + st.lineNum);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, m.notes);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, m.citations);
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                m.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                m.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                m.changeDate = new ChangeDate();
                this.loadChangeDate(ch, m.changeDate);
                continue;
            }
            this.unknownTag(ch, m);
        }
    }

    private void loadNote(StringTree st, List<Note> notes) {
        Note note = null;
        if (GedcomParserHelper.referencesAnotherNode(st)) {
            note = this.getNote(st.value);
            notes.add(note);
            return;
        }
        if (st.id != null) {
            note = this.getNote(st.id);
        } else {
            note = new Note();
            notes.add(note);
        }
        note.lines.add(st.value);
        for (StringTree ch : st.children) {
            if ("CONC".equals(ch.tag)) {
                if (note.lines.size() == 0) {
                    note.lines.add(ch.value);
                    continue;
                }
                String lastNote = note.lines.get(note.lines.size() - 1);
                if (lastNote == null || lastNote.length() == 0) {
                    note.lines.set(note.lines.size() - 1, ch.value);
                    continue;
                }
                note.lines.set(note.lines.size() - 1, lastNote + ch.value);
                continue;
            }
            if ("CONT".equals(ch.tag)) {
                note.lines.add(ch.value == null ? "" : ch.value);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, note.citations);
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                note.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                note.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                note.changeDate = new ChangeDate();
                this.loadChangeDate(ch, note.changeDate);
                continue;
            }
            this.unknownTag(ch, note);
        }
    }

    private void loadPersonalName(StringTree st, PersonalName pn) {
        pn.basic = st.value;
        for (StringTree ch : st.children) {
            PersonalNameVariation pnv;
            if ("NPFX".equals(ch.tag)) {
                pn.prefix = new StringWithCustomTags(ch);
                continue;
            }
            if ("GIVN".equals(ch.tag)) {
                pn.givenName = new StringWithCustomTags(ch);
                continue;
            }
            if ("NICK".equals(ch.tag)) {
                pn.nickname = new StringWithCustomTags(ch);
                continue;
            }
            if ("SPFX".equals(ch.tag)) {
                pn.surnamePrefix = new StringWithCustomTags(ch);
                continue;
            }
            if ("SURN".equals(ch.tag)) {
                pn.surname = new StringWithCustomTags(ch);
                continue;
            }
            if ("NSFX".equals(ch.tag)) {
                pn.suffix = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, pn.citations);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, pn.notes);
                continue;
            }
            if ("ROMN".equals(ch.tag)) {
                pnv = new PersonalNameVariation();
                pn.romanized.add(pnv);
                this.loadPersonalNameVariation(ch, pnv);
                continue;
            }
            if ("FONE".equals(ch.tag)) {
                pnv = new PersonalNameVariation();
                pn.phonetic.add(pnv);
                this.loadPersonalNameVariation(ch, pnv);
                continue;
            }
            this.unknownTag(ch, pn);
        }
    }

    private void loadPersonalNameVariation(StringTree st, PersonalNameVariation pnv) {
        pnv.variation = st.value;
        for (StringTree ch : st.children) {
            if ("NPFX".equals(ch.tag)) {
                pnv.prefix = new StringWithCustomTags(ch);
                continue;
            }
            if ("GIVN".equals(ch.tag)) {
                pnv.givenName = new StringWithCustomTags(ch);
                continue;
            }
            if ("NICK".equals(ch.tag)) {
                pnv.nickname = new StringWithCustomTags(ch);
                continue;
            }
            if ("SPFX".equals(ch.tag)) {
                pnv.surnamePrefix = new StringWithCustomTags(ch);
                continue;
            }
            if ("SURN".equals(ch.tag)) {
                pnv.surname = new StringWithCustomTags(ch);
                continue;
            }
            if ("NSFX".equals(ch.tag)) {
                pnv.suffix = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, pnv.citations);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, pnv.notes);
                continue;
            }
            if ("TYPE".equals(ch.tag)) {
                pnv.variationType = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, pnv);
        }
    }

    private void loadPlace(StringTree st, Place place) {
        place.placeName = st.value;
        for (StringTree ch : st.children) {
            NameVariation nv;
            if ("FORM".equals(ch.tag)) {
                place.placeFormat = new StringWithCustomTags(ch);
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadCitation(ch, place.citations);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, place.notes);
                continue;
            }
            if ("CONC".equals(ch.tag)) {
                place.placeName = place.placeName + (new StringWithCustomTags(ch) == null ? "" : ch.value);
                continue;
            }
            if ("CONT".equals(ch.tag)) {
                place.placeName = place.placeName + "\n" + (ch.value == null ? "" : ch.value);
                continue;
            }
            if ("ROMN".equals(ch.tag)) {
                if (this.g55()) {
                    this.warnings.add("GEDCOM version is 5.5 but a romanized variation was specified on a place on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                }
                nv = new NameVariation();
                place.romanized.add(nv);
                nv.variation = ch.value;
                for (StringTree gch : ch.children) {
                    if ("TYPE".equals(gch.tag)) {
                        nv.variationType = new StringWithCustomTags(gch);
                        continue;
                    }
                    this.unknownTag(gch, nv);
                }
                continue;
            }
            if ("FONE".equals(ch.tag)) {
                if (this.g55()) {
                    this.warnings.add("GEDCOM version is 5.5 but a phonetic variation was specified on a place on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                }
                nv = new NameVariation();
                place.phonetic.add(nv);
                nv.variation = ch.value;
                for (StringTree gch : ch.children) {
                    if ("TYPE".equals(gch.tag)) {
                        nv.variationType = new StringWithCustomTags(gch);
                        continue;
                    }
                    this.unknownTag(gch, nv);
                }
                continue;
            }
            if ("MAP".equals(ch.tag)) {
                if (this.g55()) {
                    this.warnings.add("GEDCOM version is 5.5 but a map coordinate was specified on a place on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                }
                for (StringTree gch : ch.children) {
                    if ("LAT".equals(gch.tag)) {
                        place.latitude = new StringWithCustomTags(gch);
                        continue;
                    }
                    if ("LONG".equals(gch.tag)) {
                        place.longitude = new StringWithCustomTags(gch);
                        continue;
                    }
                    this.unknownTag(gch, place);
                }
                continue;
            }
            this.unknownTag(ch, place);
        }
    }

    private void loadRepository(StringTree st) {
        Repository r = this.getRepository(st.id);
        for (StringTree ch : st.children) {
            if ("NAME".equals(ch.tag)) {
                r.name = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADDR".equals(ch.tag)) {
                r.address = new Address();
                this.loadAddress(ch, r.address);
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                r.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                r.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL was specified on repository " + r.xref + " on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                r.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax was specified on repository " + r.xref + " on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                r.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but email was specified on repository " + r.xref + " on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, r.notes);
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                r.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                r.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                r.changeDate = new ChangeDate();
                this.loadChangeDate(ch, r.changeDate);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                r.changeDate = new ChangeDate();
                this.loadChangeDate(ch, r.changeDate);
                continue;
            }
            this.unknownTag(ch, r);
        }
    }

    private RepositoryCitation loadRepositoryCitation(StringTree st, Source s2) {
        RepositoryCitation r = new RepositoryCitation();
        r.repositoryXref = st.value;
        for (StringTree ch : st.children) {
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, r.notes);
                continue;
            }
            if ("CALN".equals(ch.tag)) {
                SourceCallNumber scn = new SourceCallNumber();
                r.callNumbers.add(scn);
                scn.callNumber = new StringWithCustomTags(ch.value);
                for (StringTree gch : ch.children) {
                    if ("MEDI".equals(gch.tag)) {
                        scn.mediaType = new StringWithCustomTags(gch);
                        continue;
                    }
                    this.unknownTag(gch, scn.callNumber);
                }
                continue;
            }
            this.unknownTag(ch, r);
        }
        return r;
    }

    private void loadRootItems(StringTree st) throws GedcomParserException {
        for (StringTree ch : st.children) {
            if ("HEAD".equals(ch.tag)) {
                this.loadHeader(ch);
                continue;
            }
            if ("SUBM".equals(ch.tag)) {
                this.loadSubmitter(ch);
                continue;
            }
            if ("INDI".equals(ch.tag)) {
                this.loadIndividual(ch);
                continue;
            }
            if ("SUBN".equals(ch.tag)) {
                this.loadSubmission(ch);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadRootNote(ch);
                continue;
            }
            if ("FAM".equals(ch.tag)) {
                this.loadFamily(ch);
                continue;
            }
            if ("TRLR".equals(ch.tag)) {
                this.gedcom.trailer = new Trailer();
                continue;
            }
            if ("SOUR".equals(ch.tag)) {
                this.loadSource(ch);
                continue;
            }
            if ("REPO".equals(ch.tag)) {
                this.loadRepository(ch);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaRecord(ch);
                continue;
            }
            this.unknownTag(ch, this.gedcom);
        }
    }

    private void loadRootNote(StringTree ch) throws GedcomParserException {
        ArrayList<Note> dummyList = new ArrayList<Note>();
        this.loadNote(ch, dummyList);
        if (dummyList.size() > 0) {
            throw new GedcomParserException("At root level NOTE structures should have @ID@'s");
        }
    }

    private void loadSource(StringTree st) {
        Source s2 = this.getSource(st.id);
        for (StringTree ch : st.children) {
            if ("DATA".equals(ch.tag)) {
                s2.data = new SourceData();
                this.loadSourceData(ch, s2.data);
                continue;
            }
            if ("TITL".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, s2.title, s2);
                continue;
            }
            if ("PUBL".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, s2.publicationFacts, s2);
                continue;
            }
            if ("TEXT".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, s2.sourceText, s2);
                continue;
            }
            if ("ABBR".equals(ch.tag)) {
                s2.sourceFiledBy = new StringWithCustomTags(ch);
                continue;
            }
            if ("AUTH".equals(ch.tag)) {
                this.loadMultiLinesOfText(ch, s2.originatorsAuthors, s2);
                continue;
            }
            if ("REPO".equals(ch.tag)) {
                s2.repositoryCitation = this.loadRepositoryCitation(ch, s2);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, s2.notes);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, s2.multimedia);
                continue;
            }
            if ("REFN".equals(ch.tag)) {
                UserReference u = new UserReference();
                s2.userReferences.add(u);
                this.loadUserReference(ch, u);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                s2.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                s2.changeDate = new ChangeDate();
                this.loadChangeDate(ch, s2.changeDate);
                continue;
            }
            this.unknownTag(ch, s2);
        }
    }

    private void loadSourceData(StringTree st, SourceData data2) {
        for (StringTree ch : st.children) {
            if ("EVEN".equals(ch.tag)) {
                this.loadSourceDataEventRecorded(ch, data2);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, data2.notes);
                continue;
            }
            if ("AGNC".equals(ch.tag)) {
                data2.respAgency = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, data2);
        }
    }

    private void loadSourceDataEventRecorded(StringTree st, SourceData data2) {
        EventRecorded e = new EventRecorded();
        data2.eventsRecorded.add(e);
        e.eventType = st.value;
        for (StringTree ch : st.children) {
            if ("DATE".equals(ch.tag)) {
                e.datePeriod = new StringWithCustomTags(ch);
                continue;
            }
            if ("PLAC".equals(ch.tag)) {
                e.jurisdiction = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, data2);
        }
    }

    private void loadSourceSystem(StringTree st, SourceSystem sourceSystem) {
        sourceSystem.systemId = st.value;
        for (StringTree ch : st.children) {
            if ("VERS".equals(ch.tag)) {
                sourceSystem.versionNum = new StringWithCustomTags(ch);
                continue;
            }
            if ("NAME".equals(ch.tag)) {
                sourceSystem.productName = new StringWithCustomTags(ch);
                continue;
            }
            if ("CORP".equals(ch.tag)) {
                sourceSystem.corporation = new Corporation();
                this.loadCorporation(ch, sourceSystem.corporation);
                continue;
            }
            if ("DATA".equals(ch.tag)) {
                sourceSystem.sourceData = new HeaderSourceData();
                this.loadHeaderSourceData(ch, sourceSystem.sourceData);
                continue;
            }
            this.unknownTag(ch, sourceSystem);
        }
    }

    private void loadSubmission(StringTree st) {
        Submission s2;
        this.gedcom.submission = s2 = new Submission(st.id);
        if (this.gedcom.header == null) {
            this.gedcom.header = new Header();
        }
        if (this.gedcom.header.submission == null) {
            this.gedcom.header.submission = s2;
        }
        for (StringTree ch : st.children) {
            if ("SUBM".equals(ch.tag)) {
                this.gedcom.submission.submitter = this.getSubmitter(ch.value);
                continue;
            }
            if ("FAMF".equals(ch.tag)) {
                this.gedcom.submission.nameOfFamilyFile = new StringWithCustomTags(ch);
                continue;
            }
            if ("TEMP".equals(ch.tag)) {
                this.gedcom.submission.templeCode = new StringWithCustomTags(ch);
                continue;
            }
            if ("ANCE".equals(ch.tag)) {
                this.gedcom.submission.ancestorsCount = new StringWithCustomTags(ch);
                continue;
            }
            if ("DESC".equals(ch.tag)) {
                this.gedcom.submission.descendantsCount = new StringWithCustomTags(ch);
                continue;
            }
            if ("ORDI".equals(ch.tag)) {
                this.gedcom.submission.ordinanceProcessFlag = new StringWithCustomTags(ch);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                this.gedcom.submission.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            this.unknownTag(ch, this.gedcom.submission);
        }
    }

    private void loadSubmitter(StringTree st) {
        Submitter submitter = this.getSubmitter(st.id);
        for (StringTree ch : st.children) {
            if ("NAME".equals(ch.tag)) {
                submitter.name = new StringWithCustomTags(ch);
                continue;
            }
            if ("ADDR".equals(ch.tag)) {
                submitter.address = new Address();
                this.loadAddress(ch, submitter.address);
                continue;
            }
            if ("PHON".equals(ch.tag)) {
                submitter.phoneNumbers.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("WWW".equals(ch.tag)) {
                submitter.wwwUrls.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but WWW URL number was specified on submitter on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("FAX".equals(ch.tag)) {
                submitter.faxNumbers.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but fax number was specified on submitter on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("EMAIL".equals(ch.tag)) {
                submitter.emails.add(new StringWithCustomTags(ch));
                if (!this.g55()) continue;
                this.warnings.add("GEDCOM version is 5.5 but email was specified on submitter on line " + ch.lineNum + ", which is a GEDCOM 5.5.1 feature." + "  Data loaded but cannot be re-written unless GEDCOM version changes.");
                continue;
            }
            if ("LANG".equals(ch.tag)) {
                submitter.languagePref.add(new StringWithCustomTags(ch));
                continue;
            }
            if ("CHAN".equals(ch.tag)) {
                submitter.changeDate = new ChangeDate();
                this.loadChangeDate(ch, submitter.changeDate);
                continue;
            }
            if ("OBJE".equals(ch.tag)) {
                this.loadMultimediaLink(ch, submitter.multimedia);
                continue;
            }
            if ("RIN".equals(ch.tag)) {
                submitter.recIdNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("RFN".equals(ch.tag)) {
                submitter.regFileNumber = new StringWithCustomTags(ch);
                continue;
            }
            if ("NOTE".equals(ch.tag)) {
                this.loadNote(ch, submitter.notes);
                continue;
            }
            this.unknownTag(ch, submitter);
        }
    }

    private void loadUserReference(StringTree st, UserReference u) {
        u.referenceNum = st.value;
        if (!st.children.isEmpty()) {
            u.type = st.children.get((int)0).value;
        }
    }

    private void unknownTag(StringTree node, AbstractElement element) {
        if (node.tag.startsWith("_")) {
            element.customTags.add(node);
            return;
        }
        this.unknownTagNoUserDefinedTagsAllowed(node);
    }

    private void unknownTagNoUserDefinedTagsAllowed(StringTree node) {
        StringBuilder sb = new StringBuilder("Line " + node.lineNum + ": Cannot handle tag ");
        sb.append(node.tag);
        StringTree st = node;
        while (st.parent != null) {
            st = st.parent;
            sb.append(", child of ").append(st.tag);
            if (st.id != null) {
                sb.append(" ").append(st.id);
            }
            sb.append(" on line ").append(st.lineNum);
        }
        this.errors.add(sb.toString());
    }

    public void dumpErrorsAndWarnings() {
        if (this.errors.isEmpty()) {
            System.out.println("No errors.");
        } else {
            System.out.println("Errors:");
            for (String e : this.errors) {
                System.out.println("  " + e);
            }
        }
        if (this.warnings.isEmpty()) {
            System.out.println("No warnings.");
        } else {
            System.out.println("Warnings:");
            for (String w : this.warnings) {
                System.out.println("  " + w);
            }
        }
    }

    public void load(BufferedInputStream stream) throws IOException, GedcomParserException {
        if (this.verbose) {
            System.out.println("Loading and parsing GEDCOM from input stream");
        }
        StringTree stringTree = GedcomParserHelper.readStream(stream);
        this.loadRootItems(stringTree);
        if (this.verbose) {
            this.dumpErrorsAndWarnings();
        }
    }

    public void load(String filename) throws IOException, GedcomParserException {
        if (this.verbose) {
            System.out.println("Loading and parsing GEDCOM from file " + filename);
        }
        StringTree stringTree = GedcomParserHelper.readFile(filename);
        this.loadRootItems(stringTree);
        if (this.verbose) {
            this.dumpErrorsAndWarnings();
        }
    }
}

