/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import java.util.List;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.CitationWithSource;
import org.gedcom4j.model.CitationWithoutSource;
import org.gedcom4j.model.Note;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.GedcomValidator;

class CitationValidator
extends AbstractValidator {
    AbstractCitation citation;

    public CitationValidator(GedcomValidator rootValidator, AbstractCitation citation) {
        this.rootValidator = rootValidator;
        this.citation = citation;
    }

    protected void validate() {
        if (this.citation == null) {
            this.addError("Citation is null");
            return;
        }
        if (this.citation instanceof CitationWithSource) {
            CitationWithSource c = (CitationWithSource)this.citation;
            if (c.source == null) {
                this.addError("CitationWithSource requires a non-null source reference", c);
            }
            this.checkOptionalString(c.whereInSource, "where within source", (Object)c);
            this.checkOptionalString(c.eventCited, "event type cited from", (Object)c);
            if (c.eventCited != null) {
                this.checkOptionalString(c.roleInEvent, "role in event", (Object)c);
            } else if (c.roleInEvent != null) {
                this.addError("CitationWithSource has role in event but a null event");
            }
            this.checkOptionalString(c.certainty, "certainty/quality", (Object)c);
        } else if (this.citation instanceof CitationWithoutSource) {
            CitationWithoutSource c = (CitationWithoutSource)this.citation;
            this.checkStringList(c.description, "description on a citation without a source", true);
            if (c.textFromSource == null) {
                if (this.rootValidator.autorepair) {
                    c.textFromSource = new ArrayList<List<String>>();
                    this.addInfo("Text from source collection (the list of lists) was null in CitationWithoutSource - autorepaired", this.citation);
                } else {
                    this.addError("Text from source collection (the list of lists) is null in CitationWithoutSource", this.citation);
                }
            } else {
                for (List<String> sl : c.textFromSource) {
                    if (sl == null) {
                        this.addError("Text from source collection (the list of lists) in CitationWithoutSource contains a null", this.citation);
                        continue;
                    }
                    this.checkStringList(sl, "one of the sublists in the textFromSource collection on a source citation", true);
                }
            }
        } else {
            throw new IllegalStateException("AbstractCitation references must be either CitationWithSource instances or CitationWithoutSource instances");
        }
        if (this.citation.notes == null) {
            if (this.rootValidator.autorepair) {
                this.citation.notes = new ArrayList<Note>();
                this.addInfo("Notes collection was null on " + this.citation.getClass().getSimpleName() + " - autorepaired");
            } else {
                this.addError("Notes collection is null on " + this.citation.getClass().getSimpleName());
            }
        } else {
            this.checkNotes(this.citation.notes, this.citation);
        }
    }
}

