/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import java.util.Iterator;
import org.gedcom4j.io.Encoding;
import org.gedcom4j.model.CharacterSet;
import org.gedcom4j.model.Corporation;
import org.gedcom4j.model.GedcomVersion;
import org.gedcom4j.model.Header;
import org.gedcom4j.model.HeaderSourceData;
import org.gedcom4j.model.SourceSystem;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.model.SupportedVersion;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.AddressValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.SubmitterValidator;

class HeaderValidator
extends AbstractValidator {
    private final Header header;

    public HeaderValidator(GedcomValidator gedcomValidator, Header header) {
        this.rootValidator = gedcomValidator;
        this.header = header;
    }

    protected void validate() {
        this.checkCharacterSet();
        if (this.header.copyrightData == null) {
            if (this.rootValidator.autorepair) {
                this.header.copyrightData = new ArrayList<String>();
                this.rootValidator.addInfo("Copyright data collection was null - repaired", this.header);
            } else {
                this.rootValidator.addError("Copyright data collection is null - must be at least an empty collection", this.header);
            }
        }
        this.checkCustomTags(this.header);
        this.checkOptionalString(this.header.date, "date", (Object)this.header);
        this.checkOptionalString(this.header.destinationSystem, "destination system", (Object)this.header);
        this.checkOptionalString(this.header.fileName, "filename", (Object)this.header);
        if (this.header.gedcomVersion == null) {
            if (this.rootValidator.autorepair) {
                this.header.gedcomVersion = new GedcomVersion();
                this.rootValidator.addInfo("GEDCOM version in header was null - repaired", this.header);
            } else {
                this.rootValidator.addError("GEDCOM version in header must be specified", this.header);
                return;
            }
        }
        if (this.header.gedcomVersion.versionNumber == null) {
            if (this.rootValidator.autorepair) {
                this.header.gedcomVersion.versionNumber = SupportedVersion.V5_5_1;
                this.rootValidator.addInfo("GEDCOM version number in header was null - repaired", this.header);
            } else {
                this.rootValidator.addError("GEDCOM version number in header must be specified", this.header);
                return;
            }
        }
        this.checkCustomTags(this.header.gedcomVersion);
        this.checkOptionalString(this.header.language, "language", (Object)this.header);
        if (this.header.notes == null) {
            if (this.rootValidator.autorepair) {
                this.header.notes = new ArrayList<String>();
                this.rootValidator.addInfo("Notes collection in header was null - repaired", this.header);
            } else {
                this.rootValidator.addError("Notes collection in header is null - must be at least an empty collection", this.header);
            }
        }
        this.checkOptionalString(this.header.placeHierarchy, "place hierarchy", (Object)this.header);
        this.checkSourceSystem();
        if (this.header.submitter == null) {
            if (this.rootValidator.autorepair) {
                if (this.rootValidator.gedcom.submitters != null && this.rootValidator.gedcom.submitters.size() > 0) {
                    Iterator<Submitter> i$ = this.rootValidator.gedcom.submitters.values().iterator();
                    if (i$.hasNext()) {
                        Submitter s2;
                        this.header.submitter = s2 = i$.next();
                    }
                } else {
                    this.rootValidator.addError("Submitter not specified in header, and autorepair could not find a submitter to select as default", this.header);
                }
            } else {
                this.rootValidator.addError("Submitter not specified in header", this.header);
            }
            return;
        }
        new SubmitterValidator(this.rootValidator, this.header.submitter).validate();
        if (this.header.submission != null) {
            this.rootValidator.validateSubmission(this.header.submission);
        }
        this.checkOptionalString(this.header.time, "time", (Object)this.header);
    }

    private void checkCharacterSet() {
        if (this.header.characterSet == null) {
            if (this.rootValidator.autorepair) {
                this.header.characterSet = new CharacterSet();
                this.rootValidator.addInfo("Header did not have a character set defined - corrected.", this.header);
            } else {
                this.rootValidator.addError("Header has no character set defined", this.header);
                return;
            }
        }
        if (this.header.characterSet.characterSetName == null) {
            if (this.rootValidator.autorepair) {
                this.header.characterSet.characterSetName = new StringWithCustomTags("ANSEL");
                this.rootValidator.addInfo("Character set name was not defined", this.header.characterSet);
            } else {
                this.rootValidator.addError("Character set name was not defined", this.header.characterSet);
                return;
            }
        }
        if (!Encoding.isValidCharacterSetName(this.header.characterSet.characterSetName.value)) {
            this.rootValidator.addError("Character set name is not one of the supported encodings (" + Encoding.getSupportedCharacterSetNames() + ")", this.header.characterSet.characterSetName);
        }
        this.checkOptionalString(this.header.characterSet.characterSetName, "character set name", (Object)this.header.characterSet);
        this.checkOptionalString(this.header.characterSet.versionNum, "character set version number", (Object)this.header.characterSet);
        this.checkCustomTags(this.header.characterSet);
    }

    private void checkSourceSystem() {
        SourceSystem ss = this.header.sourceSystem;
        if (ss == null) {
            if (this.rootValidator.autorepair) {
                this.header.sourceSystem = ss = new SourceSystem();
                this.rootValidator.addInfo("No source system specified in header - repaired", this.header);
            } else {
                this.rootValidator.addError("No source system specified in header", this.header);
                return;
            }
        }
        this.checkCustomTags(ss);
        if (ss.corporation != null) {
            Corporation c = ss.corporation;
            this.checkCustomTags(c);
            if (c.address != null) {
                new AddressValidator(this.rootValidator, c.address).validate();
            }
            if (c.businessName == null || c.businessName.trim().length() == 0) {
                if (this.rootValidator.autorepair) {
                    c.businessName = "UNSPECIFIED";
                    this.rootValidator.addInfo("Corporation for source system exists but had no name - repaired", c);
                } else {
                    this.rootValidator.addError("Corporation for source system exists but has no name", c);
                }
            }
        }
        this.checkOptionalString(ss.productName, "product name", (Object)ss);
        if (ss.sourceData != null) {
            HeaderSourceData sd = ss.sourceData;
            if (sd.name == null || sd.name.trim().length() == 0) {
                if (this.rootValidator.autorepair) {
                    sd.name = "UNSPECIFIED";
                    this.rootValidator.addInfo("Source data was specified for source system, but name of source data was not specified - repaired", sd);
                } else {
                    this.rootValidator.addError("Source data is specified for source system, but name of source data is not specified", sd);
                }
            }
            this.checkOptionalString(sd.copyright, "copyright", (Object)sd);
            this.checkOptionalString(sd.publishDate, "publish date", (Object)sd);
            this.checkCustomTags(sd);
        }
        if (ss.systemId == null) {
            if (this.rootValidator.autorepair) {
                ss.systemId = "UNSPECIFIED";
                this.rootValidator.addInfo("System ID was not specified in source system in header - repaired", ss);
            } else {
                this.rootValidator.addError("System ID must be specified in source system in header", ss);
            }
        }
        this.checkOptionalString(ss.versionNum, "source system version number", (Object)ss);
    }
}

