/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.NameVariation;
import org.gedcom4j.model.Place;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.NameVariationValidator;

public class PlaceValidator
extends AbstractValidator {
    private Place place;

    public PlaceValidator(GedcomValidator rootValidator, Place place) {
        this.rootValidator = rootValidator;
        this.place = place;
    }

    protected void validate() {
        if (this.place == null) {
            this.addError("Place is null and cannot be validated or repaired");
            return;
        }
        if (this.place.citations == null) {
            if (this.rootValidator.autorepair) {
                this.place.citations = new ArrayList<AbstractCitation>();
                this.rootValidator.addInfo("Event had null list of citations - repaired", this.place);
            } else {
                this.rootValidator.addError("Event has null list of citations", this.place);
            }
        }
        for (AbstractCitation c : this.place.citations) {
            new CitationValidator(this.rootValidator, c).validate();
        }
        this.checkCustomTags(this.place);
        this.checkOptionalString(this.place.latitude, "latitude", (Object)this.place);
        this.checkOptionalString(this.place.longitude, "longitude", (Object)this.place);
        this.checkNotes(this.place.notes, this.place);
        this.checkOptionalString(this.place.placeFormat, "place format", (Object)this.place);
        if (this.place.placeName == null) {
            if (this.rootValidator.autorepair) {
                this.addError("Place name was unspecified and cannot be repaired");
            } else {
                this.addError("Place name was unspecified");
            }
        }
        if (this.place.phonetic == null) {
            if (this.rootValidator.autorepair) {
                this.place.phonetic = new ArrayList<NameVariation>();
                this.rootValidator.addInfo("Event had null list of phonetic name variations - repaired", this.place);
            } else {
                this.rootValidator.addError("Event has null list of phonetic name variations", this.place);
            }
        }
        for (NameVariation nv : this.place.phonetic) {
            new NameVariationValidator(this.rootValidator, nv).validate();
        }
        if (this.place.romanized == null) {
            if (this.rootValidator.autorepair) {
                this.place.romanized = new ArrayList<NameVariation>();
                this.rootValidator.addInfo("Event had null list of romanized name variations - repaired", this.place);
            } else {
                this.rootValidator.addError("Event has null list of romanized name variations", this.place);
            }
        }
        for (NameVariation nv : this.place.romanized) {
            new NameVariationValidator(this.rootValidator, nv).validate();
        }
    }
}

