/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import org.gedcom4j.model.Address;
import org.gedcom4j.model.Repository;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.AddressValidator;
import org.gedcom4j.validate.GedcomValidator;

class RepositoryValidator
extends AbstractValidator {
    private final Repository repository;

    public RepositoryValidator(GedcomValidator gedcomValidator, Repository repository) {
        this.rootValidator = gedcomValidator;
        this.repository = repository;
    }

    protected void validate() {
        if (this.repository == null) {
            this.addError("Repository being validated is null");
            return;
        }
        this.checkXref(this.repository);
        this.checkOptionalString(this.repository.name, "name", (Object)this.repository);
        this.checkChangeDate(this.repository.changeDate, this.repository);
        this.checkStringTagList(this.repository.emails, "email list", false);
        this.checkUserReferences(this.repository.userReferences, this.repository);
        this.checkOptionalString(this.repository.recIdNumber, "automated record id", (Object)this.repository);
        this.checkStringTagList(this.repository.phoneNumbers, "phone numbers", false);
        this.checkNotes(this.repository.notes, this.repository);
        Address a = this.repository.address;
        if (a != null) {
            new AddressValidator(this.rootValidator, a).validate();
        }
    }
}

