/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.math.BigInteger;

class DToA {
    private static final int DTOBASESTR_BUFFER_SIZE = 1078;
    static final int DTOSTR_STANDARD = 0;
    static final int DTOSTR_STANDARD_EXPONENTIAL = 1;
    static final int DTOSTR_FIXED = 2;
    static final int DTOSTR_EXPONENTIAL = 3;
    static final int DTOSTR_PRECISION = 4;
    private static final int Frac_mask = 1048575;
    private static final int Exp_shift = 20;
    private static final int Exp_msk1 = 0x100000;
    private static final long Frac_maskL = 0xFFFFFFFFFFFFFL;
    private static final int Exp_shiftL = 52;
    private static final long Exp_msk1L = 0x10000000000000L;
    private static final int Bias = 1023;
    private static final int P = 53;
    private static final int Exp_shift1 = 20;
    private static final int Exp_mask = 0x7FF00000;
    private static final int Exp_mask_shifted = 2047;
    private static final int Bndry_mask = 1048575;
    private static final int Log2P = 1;
    private static final int Sign_bit = Integer.MIN_VALUE;
    private static final int Exp_11 = 0x3FF00000;
    private static final int Ten_pmax = 22;
    private static final int Quick_max = 14;
    private static final int Bletch = 16;
    private static final int Frac_mask1 = 1048575;
    private static final int Int_max = 14;
    private static final int n_bigtens = 5;
    private static final double[] tens = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final double[] bigtens = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final int[] dtoaModes = new int[]{0, 0, 3, 2, 2};

    DToA() {
    }

    private static char BASEDIGIT(int n) {
        return (char)(n >= 10 ? 87 + n : 48 + n);
    }

    private static int lo0bits(int n) {
        int n2 = n;
        if ((n2 & 7) != 0) {
            if ((n2 & 1) != 0) {
                return 0;
            }
            if ((n2 & 2) != 0) {
                return 1;
            }
            return 2;
        }
        int n3 = 0;
        if ((n2 & 0xFFFF) == 0) {
            n3 = 16;
            n2 >>>= 16;
        }
        if ((n2 & 0xFF) == 0) {
            n3 += 8;
            n2 >>>= 8;
        }
        if ((n2 & 0xF) == 0) {
            n3 += 4;
            n2 >>>= 4;
        }
        if ((n2 & 3) == 0) {
            n3 += 2;
            n2 >>>= 2;
        }
        if ((n2 & 1) == 0) {
            ++n3;
            if (((n2 >>>= 1) & 1) == 0) {
                return 32;
            }
        }
        return n3;
    }

    private static int hi0bits(int n) {
        int n2 = 0;
        if ((n & 0xFFFF0000) == 0) {
            n2 = 16;
            n <<= 16;
        }
        if ((n & 0xFF000000) == 0) {
            n2 += 8;
            n <<= 8;
        }
        if ((n & 0xF0000000) == 0) {
            n2 += 4;
            n <<= 4;
        }
        if ((n & 0xC0000000) == 0) {
            n2 += 2;
            n <<= 2;
        }
        if ((n & Integer.MIN_VALUE) == 0) {
            ++n2;
            if ((n & 0x40000000) == 0) {
                return 32;
            }
        }
        return n2;
    }

    private static void stuffBits(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    private static BigInteger d2b(double d, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        byte[] byArray;
        int n3;
        long l = Double.doubleToLongBits(d);
        int n4 = (int)(l >>> 32);
        int n5 = (int)l;
        int n6 = n4 & 0xFFFFF;
        int n7 = (n4 &= Integer.MAX_VALUE) >>> 20;
        if (n7 != 0) {
            n6 |= 0x100000;
        }
        if ((n3 = n5) != 0) {
            byArray = new byte[8];
            n2 = DToA.lo0bits(n3);
            n3 >>>= n2;
            if (n2 != 0) {
                DToA.stuffBits(byArray, 4, n3 | n6 << 32 - n2);
                n6 >>= n2;
            } else {
                DToA.stuffBits(byArray, 4, n3);
            }
            DToA.stuffBits(byArray, 0, n6);
            n = n6 != 0 ? 2 : 1;
        } else {
            byArray = new byte[4];
            n2 = DToA.lo0bits(n6);
            DToA.stuffBits(byArray, 0, n6 >>>= n2);
            n2 += 32;
            n = 1;
        }
        if (n7 != 0) {
            nArray[0] = n7 - 1023 - 52 + n2;
            nArray2[0] = 53 - n2;
        } else {
            nArray[0] = n7 - 1023 - 52 + 1 + n2;
            nArray2[0] = 32 * n - DToA.hi0bits(n6);
        }
        return new BigInteger(byArray);
    }

    static String JS_dtobasestr(int n, double d) {
        Object object;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n2;
        String string2;
        boolean bl;
        if (2 > n || n > 36) {
            throw new IllegalArgumentException("Bad base: " + n);
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "Infinity" : "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (d >= 0.0) {
            bl = false;
        } else {
            bl = true;
            d = -d;
        }
        double d2 = Math.floor(d);
        long l = (long)d2;
        if ((double)l == d2) {
            string2 = Long.toString(bl ? -l : l, n);
        } else {
            long l2 = Double.doubleToLongBits(d2);
            n2 = (int)(l2 >> 52) & 0x7FF;
            long l3 = n2 == 0 ? (l2 & 0xFFFFFFFFFFFFFL) << 1 : l2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (bl) {
                l3 = -l3;
            }
            bigInteger2 = BigInteger.valueOf(l3);
            if ((n2 -= 1075) > 0) {
                bigInteger2 = bigInteger2.shiftLeft(n2);
            } else if (n2 < 0) {
                bigInteger2 = bigInteger2.shiftRight(-n2);
            }
            string2 = bigInteger2.toString(n);
        }
        if (d == d2) {
            return string2;
        }
        char[] cArray = new char[1078];
        int n3 = 0;
        double d3 = d - d2;
        long l4 = Double.doubleToLongBits(d);
        int n4 = (int)(l4 >> 32);
        int n5 = (int)l4;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        bigInteger2 = DToA.d2b(d3, nArray, nArray2);
        int n6 = -(n4 >>> 20 & 0x7FF);
        if (n6 == 0) {
            n6 = -1;
        }
        n6 += 1076;
        BigInteger bigInteger3 = bigInteger = BigInteger.valueOf(1L);
        if (n5 == 0 && (n4 & 0xFFFFF) == 0 && (n4 & 0x7FE00000) != 0) {
            ++n6;
            bigInteger3 = BigInteger.valueOf(2L);
        }
        bigInteger2 = bigInteger2.shiftLeft(nArray[0] + n6);
        BigInteger bigInteger4 = BigInteger.valueOf(1L);
        bigInteger4 = bigInteger4.shiftLeft(n6);
        BigInteger bigInteger5 = BigInteger.valueOf(n);
        boolean bl2 = false;
        do {
            int n7;
            bigInteger2 = bigInteger2.multiply(bigInteger5);
            object = bigInteger2.divideAndRemainder(bigInteger4);
            bigInteger2 = object[1];
            n2 = (char)object[0].intValue();
            if (bigInteger == bigInteger3) {
                bigInteger = bigInteger3 = bigInteger.multiply(bigInteger5);
            } else {
                bigInteger = bigInteger.multiply(bigInteger5);
                bigInteger3 = bigInteger3.multiply(bigInteger5);
            }
            int n8 = bigInteger2.compareTo(bigInteger);
            BigInteger bigInteger6 = bigInteger4.subtract(bigInteger3);
            int n9 = n7 = bigInteger6.signum() <= 0 ? 1 : bigInteger2.compareTo(bigInteger6);
            if (n7 == 0 && (n5 & 1) == 0) {
                if (n8 > 0) {
                    ++n2;
                }
                bl2 = true;
            } else if (n8 < 0 || n8 == 0 && (n5 & 1) == 0) {
                if (n7 > 0 && (n7 = (bigInteger2 = bigInteger2.shiftLeft(1)).compareTo(bigInteger4)) > 0) {
                    ++n2;
                }
                bl2 = true;
            } else if (n7 > 0) {
                ++n2;
                bl2 = true;
            }
            cArray[n3++] = DToA.BASEDIGIT(n2);
        } while (!bl2);
        object = new StringBuffer(string2.length() + 1 + n3);
        ((StringBuffer)object).append(string2);
        ((StringBuffer)object).append('.');
        ((StringBuffer)object).append(cArray, 0, n3);
        return ((StringBuffer)object).toString();
    }

    static int word0(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l >> 32);
    }

    static double setWord0(double d, int n) {
        long l = Double.doubleToLongBits(d);
        l = (long)n << 32 | l & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    static int word1(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)l;
    }

    static BigInteger pow5mult(BigInteger bigInteger, int n) {
        return bigInteger.multiply(BigInteger.valueOf(5L).pow(n));
    }

    static boolean roundOff(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        while (n != 0) {
            char c;
            if ((c = stringBuffer.charAt(--n)) == '9') continue;
            stringBuffer.setCharAt(n, (char)(c + '\u0001'));
            stringBuffer.setLength(n + 1);
            return false;
        }
        stringBuffer.setLength(0);
        return true;
    }

    static int JS_dtoa(double d, int n, boolean bl, int n2, boolean[] blArray, StringBuffer stringBuffer) {
        char c;
        long l;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2;
        double d2;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if ((DToA.word0(d) & Integer.MIN_VALUE) != 0) {
            blArray[0] = true;
            d = DToA.setWord0(d, DToA.word0(d) & Integer.MAX_VALUE);
        } else {
            blArray[0] = false;
        }
        if ((DToA.word0(d) & 0x7FF00000) == 0x7FF00000) {
            stringBuffer.append(DToA.word1(d) == 0 && (DToA.word0(d) & 0xFFFFF) == 0 ? "Infinity" : "NaN");
            return 9999;
        }
        if (d == 0.0) {
            stringBuffer.setLength(0);
            stringBuffer.append('0');
            return 1;
        }
        BigInteger bigInteger3 = DToA.d2b(d, nArray, nArray2);
        int n9 = DToA.word0(d) >>> 20 & 0x7FF;
        if (n9 != 0) {
            d2 = DToA.setWord0(d, DToA.word0(d) & 0xFFFFF | 0x3FF00000);
            n9 -= 1023;
            bl2 = false;
        } else {
            n9 = nArray2[0] + nArray[0] + 1074;
            long l2 = n9 > 32 ? (long)(DToA.word0(d) << 64 - n9 | DToA.word1(d) >>> n9 - 32) : (long)(DToA.word1(d) << 32 - n9);
            d2 = DToA.setWord0(l2, DToA.word0(l2) - 0x1F00000);
            n9 -= 1075;
            bl2 = true;
        }
        double d3 = (d2 - 1.5) * 0.289529654602168 + 0.1760912590558 + (double)n9 * 0.301029995663981;
        int n10 = (int)d3;
        if (d3 < 0.0 && d3 != (double)n10) {
            --n10;
        }
        boolean bl3 = true;
        if (n10 >= 0 && n10 <= 22) {
            if (d < tens[n10]) {
                --n10;
            }
            bl3 = false;
        }
        if ((n8 = nArray2[0] - n9 - 1) >= 0) {
            n7 = 0;
            n6 = n8;
        } else {
            n7 = -n8;
            n6 = 0;
        }
        if (n10 >= 0) {
            n5 = 0;
            n4 = n10;
            n6 += n10;
        } else {
            n7 -= n10;
            n5 = -n10;
            n4 = 0;
        }
        if (n < 0 || n > 9) {
            n = 0;
        }
        boolean bl4 = true;
        if (n > 5) {
            n -= 4;
            bl4 = false;
        }
        boolean bl5 = true;
        int n11 = 0;
        int n12 = 0;
        switch (n) {
            case 0: 
            case 1: {
                n11 = -1;
                n12 = -1;
                n9 = 18;
                n2 = 0;
                break;
            }
            case 2: {
                bl5 = false;
            }
            case 4: {
                if (n2 <= 0) {
                    n2 = 1;
                }
                n11 = n9 = n2;
                n12 = n9;
                break;
            }
            case 3: {
                bl5 = false;
            }
            case 5: {
                n12 = n9 = n2 + n10 + 1;
                n11 = n9 - 1;
                if (n9 > 0) break;
                n9 = 1;
            }
        }
        boolean bl6 = false;
        if (n12 >= 0 && n12 <= 14 && bl4) {
            int n13;
            int n14;
            block105: {
                n9 = 0;
                d2 = d;
                n14 = n10;
                n13 = n12;
                int n15 = 2;
                if (n10 > 0) {
                    d3 = tens[n10 & 0xF];
                    n8 = n10 >> 4;
                    if ((n8 & 0x10) != 0) {
                        n8 &= 0xF;
                        d /= bigtens[4];
                        ++n15;
                    }
                    while (n8 != 0) {
                        if ((n8 & 1) != 0) {
                            ++n15;
                            d3 *= bigtens[n9];
                        }
                        n8 >>= 1;
                        ++n9;
                    }
                    d /= d3;
                } else {
                    n3 = -n10;
                    if (n3 != 0) {
                        d *= tens[n3 & 0xF];
                        n8 = n3 >> 4;
                        while (n8 != 0) {
                            if ((n8 & 1) != 0) {
                                ++n15;
                                d *= bigtens[n9];
                            }
                            n8 >>= 1;
                            ++n9;
                        }
                    }
                }
                if (bl3 && d < 1.0 && n12 > 0) {
                    if (n11 <= 0) {
                        bl6 = true;
                    } else {
                        n12 = n11;
                        --n10;
                        d *= 10.0;
                        ++n15;
                    }
                }
                double d4 = (double)n15 * d + 7.0;
                d4 = DToA.setWord0(d4, DToA.word0(d4) - 0x3400000);
                if (n12 == 0) {
                    bigInteger2 = null;
                    bigInteger = null;
                    if ((d -= 5.0) > d4) {
                        stringBuffer.append('1');
                        return ++n10 + 1;
                    }
                    if (d < -d4) {
                        stringBuffer.setLength(0);
                        stringBuffer.append('0');
                        return 1;
                    }
                    bl6 = true;
                }
                if (!bl6) {
                    bl6 = true;
                    if (bl5) {
                        d4 = 0.5 / tens[n12 - 1] - d4;
                        n9 = 0;
                        while (true) {
                            l = (long)d;
                            d -= (double)l;
                            stringBuffer.append((char)(48L + l));
                            if (d < d4) {
                                return n10 + 1;
                            }
                            if (1.0 - d < d4) {
                                int n16;
                                block104: {
                                    do {
                                        n16 = stringBuffer.charAt(stringBuffer.length() - 1);
                                        stringBuffer.setLength(stringBuffer.length() - 1);
                                        if (n16 != 57) break block104;
                                    } while (stringBuffer.length() != 0);
                                    ++n10;
                                    n16 = 48;
                                }
                                stringBuffer.append((char)(n16 + '\u0001'));
                                return n10 + 1;
                            }
                            if (++n9 < n12) {
                                d4 *= 10.0;
                                d *= 10.0;
                                continue;
                            }
                            break block105;
                            break;
                        }
                    }
                    d4 *= tens[n12 - 1];
                    n9 = 1;
                    while (true) {
                        l = (long)d;
                        d -= (double)l;
                        stringBuffer.append((char)(48L + l));
                        if (n9 == n12) {
                            if (d > 0.5 + d4) {
                                int n17;
                                block106: {
                                    do {
                                        n17 = stringBuffer.charAt(stringBuffer.length() - 1);
                                        stringBuffer.setLength(stringBuffer.length() - 1);
                                        if (n17 != 57) break block106;
                                    } while (stringBuffer.length() != 0);
                                    ++n10;
                                    n17 = 48;
                                }
                                stringBuffer.append((char)(n17 + '\u0001'));
                                return n10 + 1;
                            }
                            if (!(d < 0.5 - d4)) break;
                            DToA.stripTrailingZeroes(stringBuffer);
                            return n10 + 1;
                        }
                        ++n9;
                        d *= 10.0;
                    }
                }
            }
            if (bl6) {
                stringBuffer.setLength(0);
                d = d2;
                n10 = n14;
                n12 = n13;
            }
        }
        if (nArray[0] >= 0 && n10 <= 14) {
            d3 = tens[n10];
            if (n2 < 0 && n12 <= 0) {
                bigInteger2 = null;
                bigInteger = null;
                if (n12 < 0 || d < 5.0 * d3 || !bl && d == 5.0 * d3) {
                    stringBuffer.setLength(0);
                    stringBuffer.append('0');
                    return 1;
                }
                stringBuffer.append('1');
                return ++n10 + 1;
            }
            n9 = 1;
            while (true) {
                l = (long)(d / d3);
                d -= (double)l * d3;
                stringBuffer.append((char)(48L + l));
                if (n9 == n12) {
                    int n18;
                    block107: {
                        if (!((d += d) > d3) && (d != d3 || (l & 1L) == 0L && !bl)) break;
                        do {
                            n18 = stringBuffer.charAt(stringBuffer.length() - 1);
                            stringBuffer.setLength(stringBuffer.length() - 1);
                            if (n18 != 57) break block107;
                        } while (stringBuffer.length() != 0);
                        ++n10;
                        n18 = 48;
                    }
                    stringBuffer.append((char)(n18 + '\u0001'));
                    break;
                }
                if ((d *= 10.0) == 0.0) break;
                ++n9;
            }
            return n10 + 1;
        }
        int n19 = n7;
        int n20 = n5;
        BigInteger bigInteger4 = null;
        bigInteger2 = null;
        if (bl5) {
            if (n < 2) {
                n9 = bl2 ? nArray[0] + 1075 : 54 - nArray2[0];
            } else {
                n8 = n12 - 1;
                if (n20 >= n8) {
                    n20 -= n8;
                } else {
                    n4 += (n8 -= n20);
                    n5 += n8;
                    n20 = 0;
                }
                n9 = n12;
                if (n9 < 0) {
                    n19 -= n9;
                    n9 = 0;
                }
            }
            n7 += n9;
            n6 += n9;
            bigInteger2 = BigInteger.valueOf(1L);
        }
        if (n19 > 0 && n6 > 0) {
            n9 = n19 < n6 ? n19 : n6;
            n7 -= n9;
            n19 -= n9;
            n6 -= n9;
        }
        if (n5 > 0) {
            if (bl5) {
                if (n20 > 0) {
                    BigInteger bigInteger5;
                    bigInteger2 = DToA.pow5mult(bigInteger2, n20);
                    bigInteger3 = bigInteger5 = bigInteger2.multiply(bigInteger3);
                }
                if ((n8 = n5 - n20) != 0) {
                    bigInteger3 = DToA.pow5mult(bigInteger3, n8);
                }
            } else {
                bigInteger3 = DToA.pow5mult(bigInteger3, n5);
            }
        }
        bigInteger = BigInteger.valueOf(1L);
        if (n4 > 0) {
            bigInteger = DToA.pow5mult(bigInteger, n4);
        }
        boolean bl7 = false;
        if (n < 2 && DToA.word1(d) == 0 && (DToA.word0(d) & 0xFFFFF) == 0 && (DToA.word0(d) & 0x7FE00000) != 0) {
            ++n7;
            ++n6;
            bl7 = true;
        }
        byte[] byArray = bigInteger.toByteArray();
        int n21 = 0;
        for (int i = 0; i < 4; ++i) {
            n21 <<= 8;
            if (i >= byArray.length) continue;
            n21 |= byArray[i] & 0xFF;
        }
        n9 = (n4 != 0 ? 32 - DToA.hi0bits(n21) : 1) + n6 & 0x1F;
        if (n9 != 0) {
            n9 = 32 - n9;
        }
        if (n9 > 4) {
            n7 += (n9 -= 4);
            n19 += n9;
            n6 += n9;
        } else if (n9 < 4) {
            n7 += (n9 += 28);
            n19 += n9;
            n6 += n9;
        }
        if (n7 > 0) {
            bigInteger3 = bigInteger3.shiftLeft(n7);
        }
        if (n6 > 0) {
            bigInteger = bigInteger.shiftLeft(n6);
        }
        if (bl3 && bigInteger3.compareTo(bigInteger) < 0) {
            --n10;
            bigInteger3 = bigInteger3.multiply(BigInteger.valueOf(10L));
            if (bl5) {
                bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(10L));
            }
            n12 = n11;
        }
        if (n12 <= 0 && n > 2) {
            if (n12 < 0 || (n9 = bigInteger3.compareTo(bigInteger = bigInteger.multiply(BigInteger.valueOf(5L)))) < 0 || n9 == 0 && !bl) {
                stringBuffer.setLength(0);
                stringBuffer.append('0');
                return 1;
            }
            stringBuffer.append('1');
            return ++n10 + 1;
        }
        if (bl5) {
            if (n19 > 0) {
                bigInteger2 = bigInteger2.shiftLeft(n19);
            }
            bigInteger4 = bigInteger2;
            if (bl7) {
                bigInteger2 = bigInteger4;
                bigInteger2 = bigInteger2.shiftLeft(1);
            }
            n9 = 1;
            while (true) {
                BigInteger[] bigIntegerArray = bigInteger3.divideAndRemainder(bigInteger);
                bigInteger3 = bigIntegerArray[1];
                c = (char)(bigIntegerArray[0].intValue() + 48);
                n8 = bigInteger3.compareTo(bigInteger4);
                BigInteger bigInteger6 = bigInteger.subtract(bigInteger2);
                int n22 = n3 = bigInteger6.signum() <= 0 ? 1 : bigInteger3.compareTo(bigInteger6);
                if (n3 == 0 && n == 0 && (DToA.word1(d) & 1) == 0) {
                    if (c == '9') {
                        stringBuffer.append('9');
                        if (DToA.roundOff(stringBuffer)) {
                            ++n10;
                            stringBuffer.append('1');
                        }
                        return n10 + 1;
                    }
                    if (n8 > 0) {
                        c = (char)(c + '\u0001');
                    }
                    stringBuffer.append(c);
                    return n10 + 1;
                }
                if (n8 < 0 || n8 == 0 && n == 0 && (DToA.word1(d) & 1) == 0) {
                    if (n3 > 0 && ((n3 = (bigInteger3 = bigInteger3.shiftLeft(1)).compareTo(bigInteger)) > 0 || n3 == 0 && ((c & '\u0001') == 1 || bl))) {
                        char c2 = c;
                        c = (char)(c + '\u0001');
                        if (c2 == '9') {
                            stringBuffer.append('9');
                            if (DToA.roundOff(stringBuffer)) {
                                ++n10;
                                stringBuffer.append('1');
                            }
                            return n10 + 1;
                        }
                    }
                    stringBuffer.append(c);
                    return n10 + 1;
                }
                if (n3 > 0) {
                    if (c == '9') {
                        stringBuffer.append('9');
                        if (DToA.roundOff(stringBuffer)) {
                            ++n10;
                            stringBuffer.append('1');
                        }
                        return n10 + 1;
                    }
                    stringBuffer.append((char)(c + '\u0001'));
                    return n10 + 1;
                }
                stringBuffer.append(c);
                if (n9 != n12) {
                    bigInteger3 = bigInteger3.multiply(BigInteger.valueOf(10L));
                    if (bigInteger4 == bigInteger2) {
                        bigInteger4 = bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(10L));
                    } else {
                        bigInteger4 = bigInteger4.multiply(BigInteger.valueOf(10L));
                        bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(10L));
                    }
                    ++n9;
                    continue;
                }
                break;
            }
        } else {
            n9 = 1;
            while (true) {
                BigInteger[] bigIntegerArray = bigInteger3.divideAndRemainder(bigInteger);
                bigInteger3 = bigIntegerArray[1];
                c = (char)(bigIntegerArray[0].intValue() + 48);
                stringBuffer.append(c);
                if (n9 >= n12) break;
                bigInteger3 = bigInteger3.multiply(BigInteger.valueOf(10L));
                ++n9;
            }
        }
        bigInteger3 = bigInteger3.shiftLeft(1);
        n8 = bigInteger3.compareTo(bigInteger);
        if (n8 > 0 || n8 == 0 && ((c & '\u0001') == 1 || bl)) {
            if (DToA.roundOff(stringBuffer)) {
                stringBuffer.append('1');
                return ++n10 + 1;
            }
        } else {
            DToA.stripTrailingZeroes(stringBuffer);
        }
        return n10 + 1;
    }

    private static void stripTrailingZeroes(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        while (n-- > 0 && stringBuffer.charAt(n) == '0') {
        }
        stringBuffer.setLength(n + 1);
    }

    static void JS_dtostr(StringBuffer stringBuffer, int n, int n2, double d) {
        boolean[] blArray = new boolean[1];
        if (n == 2 && (d >= 1.0E21 || d <= -1.0E21)) {
            n = 0;
        }
        int n3 = DToA.JS_dtoa(d, dtoaModes[n], n >= 2, n2, blArray, stringBuffer);
        int n4 = stringBuffer.length();
        if (n3 != 9999) {
            boolean bl = false;
            int n5 = 0;
            switch (n) {
                case 0: {
                    if (n3 < -5 || n3 > 21) {
                        bl = true;
                        break;
                    }
                    n5 = n3;
                    break;
                }
                case 2: {
                    if (n2 >= 0) {
                        n5 = n3 + n2;
                        break;
                    }
                    n5 = n3;
                    break;
                }
                case 3: {
                    n5 = n2;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 4: {
                    n5 = n2;
                    if (n3 >= -5 && n3 <= n2) break;
                    bl = true;
                }
            }
            if (n4 < n5) {
                int n6 = n5;
                n4 = n5;
                do {
                    stringBuffer.append('0');
                } while (stringBuffer.length() != n6);
            }
            if (bl) {
                if (n4 != 1) {
                    stringBuffer.insert(1, '.');
                }
                stringBuffer.append('e');
                if (n3 - 1 >= 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(n3 - 1);
            } else if (n3 != n4) {
                if (n3 > 0) {
                    stringBuffer.insert(n3, '.');
                } else {
                    for (int i = 0; i < 1 - n3; ++i) {
                        stringBuffer.insert(0, '0');
                    }
                    stringBuffer.insert(1, '.');
                }
            }
        }
        if (blArray[0] && (DToA.word0(d) != Integer.MIN_VALUE || DToA.word1(d) != 0) && ((DToA.word0(d) & 0x7FF00000) != 0x7FF00000 || DToA.word1(d) == 0 && (DToA.word0(d) & 0xFFFFF) == 0)) {
            stringBuffer.insert(0, '-');
        }
    }
}

