/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ScriptRuntime;

class DefaultErrorReporter
implements ErrorReporter {
    static final DefaultErrorReporter instance = new DefaultErrorReporter();
    private boolean forEval;
    private ErrorReporter chainedReporter;

    private DefaultErrorReporter() {
    }

    static ErrorReporter forEval(ErrorReporter errorReporter) {
        DefaultErrorReporter defaultErrorReporter = new DefaultErrorReporter();
        defaultErrorReporter.forEval = true;
        defaultErrorReporter.chainedReporter = errorReporter;
        return defaultErrorReporter;
    }

    public void warning(String string2, String string3, int n, String string4, int n2) {
        if (this.chainedReporter != null) {
            this.chainedReporter.warning(string2, string3, n, string4, n2);
        }
    }

    public void error(String string2, String string3, int n, String string4, int n2) {
        if (this.forEval) {
            throw ScriptRuntime.constructError("SyntaxError", string2, string3, n, string4, n2);
        }
        if (this.chainedReporter == null) {
            throw this.runtimeError(string2, string3, n, string4, n2);
        }
        this.chainedReporter.error(string2, string3, n, string4, n2);
    }

    public EvaluatorException runtimeError(String string2, String string3, int n, String string4, int n2) {
        if (this.chainedReporter != null) {
            return this.chainedReporter.runtimeError(string2, string3, n, string4, n2);
        }
        return new EvaluatorException(string2, string3, n, string4, n2);
    }
}

