/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.CharArrayWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.mozilla.javascript.Interpreter;

public abstract class RhinoException
extends RuntimeException {
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Interpreter.captureInterpreterStackInfo(this);
    }

    RhinoException(String string2) {
        super(string2);
        Interpreter.captureInterpreterStackInfo(this);
    }

    public final String getMessage() {
        String string2 = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(" (");
        if (this.sourceName != null) {
            stringBuffer.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            stringBuffer.append('#');
            stringBuffer.append(this.lineNumber);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = string2;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = n;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = n;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = string2;
    }

    final void recordErrorOrigin(String string2, int n, String string3, int n2) {
        if (n == -1) {
            n = 0;
        }
        if (string2 != null) {
            this.initSourceName(string2);
        }
        if (n != 0) {
            this.initLineNumber(n);
        }
        if (string3 != null) {
            this.initLineSource(string3);
        }
        if (n2 != 0) {
            this.initColumnNumber(n2);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(charArrayWriter));
        String string2 = charArrayWriter.toString();
        return Interpreter.getPatchedStack(this, string2);
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.print(this.generateStackTrace());
        }
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.print(this.generateStackTrace());
        }
    }
}

