/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import antlr.CharScanner;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ASTExpr;
import org.antlr.stringtemplate.language.ActionLexer;
import org.antlr.stringtemplate.language.ActionParser;
import org.antlr.stringtemplate.language.AttributeReflectionController;
import org.antlr.stringtemplate.language.ConditionalExpr;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.FormalArgument;
import org.antlr.stringtemplate.language.NewlineRef;
import org.antlr.stringtemplate.language.StringTemplateAST;
import org.antlr.stringtemplate.language.TemplateParser;

public class StringTemplate {
    public static final String VERSION = "2.1";
    static boolean debugMode = false;
    static boolean lintMode = false;
    protected List referencedAttributes = null;
    protected String name = "anonymous";
    private static int templateCounter = 0;
    protected int templateID = StringTemplate.getNextTemplateCounter();
    protected StringTemplate enclosingInstance = null;
    protected List embeddedInstances = null;
    protected Map argumentContext = null;
    protected StringTemplateAST argumentsAST = null;
    protected Map formalArguments = FormalArgument.UNKNOWN;
    protected StringTemplateGroup group = defaultGroup;
    StringTemplateErrorListener listener = null;
    protected String pattern;
    protected Map attributes;
    protected List chunks;
    protected static StringTemplateGroup defaultGroup = new StringTemplateGroup("defaultGroup", ".");
    static /* synthetic */ Class class$org$antlr$stringtemplate$StringTemplate;
    static /* synthetic */ Class class$java$io$Reader;

    private static synchronized int getNextTemplateCounter() {
        return ++templateCounter;
    }

    public static void resetTemplateCounter() {
        templateCounter = 0;
    }

    public StringTemplate() {
        if (debugMode) {
            this.debug("new StringTemplate():" + this.getTemplateID());
        }
    }

    public StringTemplate(String string) {
        this(null, string);
        if (debugMode) {
            this.debug("new StringTemplate(template):" + this.getTemplateID());
        }
    }

    public StringTemplate(String string, Class clazz) {
        this();
        this.setGroup(new StringTemplateGroup("angleBracketsGroup", clazz));
        this.setTemplate(string);
    }

    public StringTemplate(StringTemplateGroup stringTemplateGroup, String string) {
        this();
        if (debugMode) {
            this.debug("new StringTemplate(group, [" + string + "]):" + this.getTemplateID());
        }
        if (stringTemplateGroup != null) {
            this.setGroup(stringTemplateGroup);
        }
        this.setTemplate(string);
    }

    protected void dup(StringTemplate stringTemplate, StringTemplate stringTemplate2) {
        if (debugMode) {
            this.debug("dup template ID " + stringTemplate.getTemplateID() + " to get " + stringTemplate2.getTemplateID());
        }
        stringTemplate2.pattern = stringTemplate.pattern;
        stringTemplate2.chunks = stringTemplate.chunks;
        stringTemplate2.formalArguments = stringTemplate.formalArguments;
        stringTemplate2.name = stringTemplate.name;
        stringTemplate2.group = stringTemplate.group;
        stringTemplate2.listener = stringTemplate.listener;
    }

    public StringTemplate getInstanceOf() {
        if (debugMode) {
            this.debug("getInstanceOf(" + this.getName() + ")");
        }
        StringTemplate stringTemplate = this.group.createStringTemplate();
        this.dup(this, stringTemplate);
        return stringTemplate;
    }

    public StringTemplate getEnclosingInstance() {
        return this.enclosingInstance;
    }

    public void setEnclosingInstance(StringTemplate stringTemplate) {
        if (this == stringTemplate) {
            throw new IllegalArgumentException("cannot embed template " + this.getName() + " in itself");
        }
        this.enclosingInstance = stringTemplate;
        this.enclosingInstance.addEmbeddedInstance(this);
    }

    public void addEmbeddedInstance(StringTemplate stringTemplate) {
        if (this.embeddedInstances == null) {
            this.embeddedInstances = new LinkedList();
        }
        this.embeddedInstances.add(stringTemplate);
    }

    public Map getArgumentContext() {
        return this.argumentContext;
    }

    public void setArgumentContext(Map map) {
        this.argumentContext = map;
    }

    public StringTemplateAST getArgumentsAST() {
        return this.argumentsAST;
    }

    public void setArgumentsAST(StringTemplateAST stringTemplateAST) {
        this.argumentsAST = stringTemplateAST;
    }

    public String getName() {
        return this.name;
    }

    public String getOutermostName() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostName();
        }
        return this.getName();
    }

    public void setName(String string) {
        this.name = string;
    }

    public StringTemplateGroup getGroup() {
        return this.group;
    }

    public void setGroup(StringTemplateGroup stringTemplateGroup) {
        this.group = stringTemplateGroup;
    }

    public void setTemplate(String string) {
        this.pattern = string;
        this.breakTemplateIntoChunks();
    }

    public String getTemplate() {
        return this.pattern;
    }

    public void setErrorListener(StringTemplateErrorListener stringTemplateErrorListener) {
        this.listener = stringTemplateErrorListener;
    }

    public StringTemplateErrorListener getErrorListener() {
        if (this.listener == null) {
            return this.group.getErrorListener();
        }
        return this.listener;
    }

    public void reset() {
        this.attributes = new HashMap();
    }

    public void setPredefinedAttributes() {
        if (!StringTemplate.inLintMode()) {
            return;
        }
        if (this.formalArguments != FormalArgument.UNKNOWN) {
            this.defineFormalArgument("attributes");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.rawSetAttribute(this.attributes, "attributes", new AttributeReflectionController(this).toString());
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (debugMode) {
            this.debug(this.getName() + ".setAttribute(" + string + ", " + object + ")");
        }
        if (object == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (object instanceof StringTemplate) {
            ((StringTemplate)object).setEnclosingInstance(this);
        } else {
            object = ASTExpr.convertArrayToList(object);
        }
        Object v = this.attributes.get(string);
        if (v != null) {
            ArrayList<Object> arrayList = null;
            if (v instanceof ArrayList) {
                arrayList = (ArrayList<Object>)v;
                if (object instanceof List) {
                    List list = (List)object;
                    for (int i = 0; arrayList != list && i < list.size(); ++i) {
                        arrayList.add(list.get(i));
                    }
                } else {
                    arrayList.add(object);
                }
            } else {
                arrayList = new ArrayList<Object>();
                this.rawSetAttribute(this.attributes, string, arrayList);
                arrayList.add(v);
                if (object instanceof List) {
                    List list = (List)object;
                    for (int i = 0; i < list.size(); ++i) {
                        arrayList.add(list.get(i));
                    }
                } else {
                    arrayList.add(object);
                }
            }
        } else {
            this.rawSetAttribute(this.attributes, string, object);
        }
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, new Integer(n));
    }

    public void setAttribute(String string, Object object, Object object2) {
        this.setAttribute(string, new Object[]{object, object2});
    }

    public void setAttribute(String string, Object object, Object object2, Object object3) {
        this.setAttribute(string, new Object[]{object, object2, object3});
    }

    public void setAttribute(String string, Object object, Object object2, Object object3, Object object4) {
        this.setAttribute(string, new Object[]{object, object2, object3, object4});
    }

    public void setAttribute(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        this.setAttribute(string, new Object[]{object, object2, object3, object4, object5});
    }

    protected void setAttribute(String string, Object[] objectArray) {
        ArrayList arrayList = new ArrayList();
        String string2 = this.parseAggregateAttributeSpec(string, arrayList);
        if (objectArray == null || arrayList.size() == 0) {
            throw new IllegalArgumentException("missing properties or values for '" + string + "'");
        }
        if (objectArray.length != arrayList.size()) {
            throw new IllegalArgumentException("number of properties in '" + string + "' != number of values");
        }
        Aggregate aggregate = new Aggregate();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof StringTemplate) {
                ((StringTemplate)object).setEnclosingInstance(this);
            } else {
                object = ASTExpr.convertArrayToList(object);
            }
            aggregate.put((String)arrayList.get(i), object);
        }
        this.setAttribute(string2, aggregate);
    }

    protected String parseAggregateAttributeSpec(String string, List list) {
        String string2;
        int n = string.indexOf(46);
        if (n <= 0) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + string);
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1, string.length());
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "{,}", true);
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equals("{")) {
            string2 = stringTokenizer.nextToken();
            list.add(string2);
            string2 = stringTokenizer.nextToken();
            while (string2.equals(",")) {
                string2 = stringTokenizer.nextToken();
                list.add(string2);
                string2 = stringTokenizer.nextToken();
            }
            if (string2.equals("}")) {
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + string);
        }
        return string3;
    }

    public void rawSetAttribute(Map map, String string, Object object) {
        if (debugMode) {
            this.debug(this.getName() + ".rawSetAttribute(" + string + ", " + object + ")");
        }
        if (this.formalArguments != FormalArgument.UNKNOWN && this.getFormalArgument(string) == null) {
            throw new NoSuchElementException("no such attribute: " + string + " in template " + this.getName() + " or in enclosing template");
        }
        if (object == null) {
            return;
        }
        map.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.get(this, string);
    }

    public int write(StringTemplateWriter stringTemplateWriter) throws IOException {
        int n = 0;
        this.setPredefinedAttributes();
        for (int i = 0; this.chunks != null && i < this.chunks.size(); ++i) {
            Expr expr = (Expr)this.chunks.get(i);
            int n2 = expr.write(this, stringTemplateWriter);
            if (n2 == 0 && i - 1 >= 0 && this.chunks.get(i - 1) instanceof NewlineRef && i + 1 < this.chunks.size() && this.chunks.get(i + 1) instanceof NewlineRef) {
                ++i;
            }
            n += n2;
        }
        if (lintMode) {
            this.checkForTrouble();
        }
        return n;
    }

    public Object get(StringTemplate stringTemplate, String string) {
        Object object;
        if (stringTemplate == null) {
            return null;
        }
        if (lintMode) {
            stringTemplate.trackAttributeReference(string);
        }
        Object object2 = null;
        if (stringTemplate.attributes != null) {
            object2 = stringTemplate.attributes.get(string);
        }
        if (object2 == null && (object = stringTemplate.getArgumentContext()) != null) {
            object2 = object.get(string);
        }
        if (object2 == null && stringTemplate.getFormalArgument(string) != null) {
            return null;
        }
        if (object2 == null && stringTemplate.enclosingInstance != null) {
            object = this.get(stringTemplate.enclosingInstance, string);
            if (object == null) {
                this.checkNullAttributeAgainstFormalArguments(stringTemplate, string);
            }
            object2 = object;
        }
        return object2;
    }

    protected void breakTemplateIntoChunks() {
        if (this.pattern == null) {
            return;
        }
        try {
            Class clazz = this.group.getTemplateLexerClass();
            Constructor constructor = clazz.getConstructor(class$org$antlr$stringtemplate$StringTemplate == null ? (class$org$antlr$stringtemplate$StringTemplate = StringTemplate.class$("org.antlr.stringtemplate.StringTemplate")) : class$org$antlr$stringtemplate$StringTemplate, class$java$io$Reader == null ? (class$java$io$Reader = StringTemplate.class$("java.io.Reader")) : class$java$io$Reader);
            CharScanner charScanner = (CharScanner)constructor.newInstance(this, new StringReader(this.pattern));
            charScanner.setTokenObjectClass("org.antlr.stringtemplate.language.ChunkToken");
            TemplateParser templateParser = new TemplateParser((TokenStream)charScanner);
            templateParser.template(this);
        }
        catch (Exception exception) {
            String string = "<unknown>";
            String string2 = this.getOutermostName();
            if (this.getName() != null) {
                string = this.getName();
            }
            if (string2 != null && !string.equals(string2)) {
                string = string + " nested in " + string2;
            }
            this.error("problem parsing template '" + string + "'", exception);
        }
    }

    public ASTExpr parseAction(String string) {
        ActionLexer actionLexer = new ActionLexer(new StringReader(string.toString()));
        ActionParser actionParser = new ActionParser((TokenStream)actionLexer, this);
        actionParser.setASTNodeClass("org.antlr.stringtemplate.language.StringTemplateAST");
        ASTExpr aSTExpr = null;
        try {
            Map map = actionParser.action();
            AST aST = actionParser.getAST();
            if (aST != null) {
                aSTExpr = aST.getType() == 7 ? new ConditionalExpr(this, aST) : new ASTExpr(this, aST, map);
            }
        }
        catch (RecognitionException recognitionException) {
            this.error("Can't parse chunk: " + string.toString(), recognitionException);
        }
        catch (TokenStreamException tokenStreamException) {
            this.error("Can't parse chunk: " + string.toString(), tokenStreamException);
        }
        return aSTExpr;
    }

    public int getTemplateID() {
        return this.templateID;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public List getChunks() {
        return this.chunks;
    }

    public void addChunk(Expr expr) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(expr);
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public Map getFormArguments() {
        return this.formalArguments;
    }

    public void setFormalArguments(Map map) {
        this.formalArguments = map;
    }

    public FormalArgument lookupFormalArgument(String string) {
        FormalArgument formalArgument = this.getFormalArgument(string);
        if (formalArgument == null && this.enclosingInstance != null) {
            formalArgument = this.enclosingInstance.lookupFormalArgument(string);
        }
        return formalArgument;
    }

    public FormalArgument getFormalArgument(String string) {
        return (FormalArgument)this.formalArguments.get(string);
    }

    public void defineEmptyFormalArgumentList() {
        this.setFormalArguments(new HashMap());
    }

    public void defineFormalArgument(String string) {
        FormalArgument formalArgument = new FormalArgument(string);
        if (this.formalArguments == FormalArgument.UNKNOWN) {
            this.formalArguments = new HashMap();
        }
        this.formalArguments.put(string, formalArgument);
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void warning(String string) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().warning(string);
        } else {
            System.err.println("StringTemplate: warning: " + string);
        }
    }

    public void debug(String string) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().debug(string);
        } else {
            System.err.println("StringTemplate: debug: " + string);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().error(string, throwable);
        } else if (throwable != null) {
            System.err.println("StringTemplate: error: " + string + ": " + throwable.toString());
        } else {
            System.err.println("StringTemplate: error: " + string);
        }
    }

    public static void setLintMode(boolean bl) {
        lintMode = bl;
    }

    public static boolean inLintMode() {
        return lintMode;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean bl) {
        debugMode = bl;
    }

    protected void trackAttributeReference(String string) {
        if (this.referencedAttributes == null) {
            this.referencedAttributes = new ArrayList();
        }
        this.referencedAttributes.add(string);
    }

    public static boolean isRecursiveEnclosingInstance(StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            return false;
        }
        StringTemplate stringTemplate2 = stringTemplate.enclosingInstance;
        if (stringTemplate2 == stringTemplate) {
            return true;
        }
        while (stringTemplate2 != null) {
            if (stringTemplate2 == stringTemplate) {
                return true;
            }
            stringTemplate2 = stringTemplate2.enclosingInstance;
        }
        return false;
    }

    public String getEnclosingInstanceStackTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<StringTemplate> hashSet = new HashSet<StringTemplate>();
        StringTemplate stringTemplate = this;
        while (stringTemplate != null) {
            if (hashSet.contains(stringTemplate)) {
                stringBuffer.append(stringTemplate.getTemplateDeclaratorString());
                stringBuffer.append(" (start of recursive cycle)");
                stringBuffer.append("\n");
                stringBuffer.append("...");
                break;
            }
            hashSet.add(stringTemplate);
            stringBuffer.append(stringTemplate.getTemplateDeclaratorString());
            if (stringTemplate.attributes != null) {
                stringBuffer.append(", attributes=[");
                int n = 0;
                Iterator iterator = stringTemplate.attributes.keySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = (String)iterator.next();
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    ++n;
                    stringBuffer.append(string);
                    Object v = stringTemplate.attributes.get(string);
                    if (v instanceof StringTemplate) {
                        object = (StringTemplate)v;
                        stringBuffer.append("=");
                        stringBuffer.append("<");
                        stringBuffer.append(((StringTemplate)object).getName());
                        stringBuffer.append("()@");
                        stringBuffer.append(String.valueOf(((StringTemplate)object).getTemplateID()));
                        stringBuffer.append(">");
                        continue;
                    }
                    if (!(v instanceof List)) continue;
                    stringBuffer.append("=List[..");
                    object = (List)v;
                    int n2 = 0;
                    for (int i = 0; i < object.size(); ++i) {
                        Object e = object.get(i);
                        if (!(e instanceof StringTemplate)) continue;
                        if (n2 > 0) {
                            stringBuffer.append(", ");
                        }
                        ++n2;
                        StringTemplate stringTemplate2 = (StringTemplate)e;
                        stringBuffer.append("<");
                        stringBuffer.append(stringTemplate2.getName());
                        stringBuffer.append("()@");
                        stringBuffer.append(String.valueOf(stringTemplate2.getTemplateID()));
                        stringBuffer.append(">");
                    }
                    stringBuffer.append("..]");
                }
                stringBuffer.append("]");
            }
            if (stringTemplate.referencedAttributes != null) {
                stringBuffer.append(", references=");
                stringBuffer.append(stringTemplate.referencedAttributes);
            }
            stringBuffer.append(">\n");
            stringTemplate = stringTemplate.enclosingInstance;
        }
        return stringBuffer.toString();
    }

    public String getTemplateDeclaratorString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        stringBuffer.append(this.formalArguments.keySet());
        stringBuffer.append(")@");
        stringBuffer.append(String.valueOf(this.getTemplateID()));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected void checkNullAttributeAgainstFormalArguments(StringTemplate stringTemplate, String string) {
        if (stringTemplate.getFormArguments() == FormalArgument.UNKNOWN) {
            if (stringTemplate.enclosingInstance != null) {
                this.checkNullAttributeAgainstFormalArguments(stringTemplate.enclosingInstance, string);
            }
            return;
        }
        FormalArgument formalArgument = this.lookupFormalArgument(string);
        if (formalArgument == null) {
            throw new NoSuchElementException("no such attribute: " + string);
        }
    }

    protected void checkForTrouble() {
        if (this.attributes == null) {
            return;
        }
        Set set = this.attributes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.referencedAttributes == null || this.referencedAttributes.contains(string) || string.equals("attributes")) continue;
            this.warning(this.getName() + ": set but not used: " + string);
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template-" + this.getName() + ":");
        stringBuffer.append("chunks=");
        stringBuffer.append(this.chunks.toString());
        stringBuffer.append("attributes=[");
        Set set = this.attributes.keySet();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            String string = (String)iterator.next();
            stringBuffer.append(string + "=");
            Object v = this.attributes.get(string);
            if (v instanceof StringTemplate) {
                stringBuffer.append(((StringTemplate)v).toDebugString());
            } else {
                stringBuffer.append(v);
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void printDebugString() {
        System.out.println("template-" + this.getName() + ":");
        System.out.print("chunks=");
        System.out.println(this.chunks.toString());
        if (this.attributes == null) {
            return;
        }
        System.out.print("attributes=[");
        Set set = this.attributes.keySet();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            Object v;
            if (n > 0) {
                System.out.print(',');
            }
            if ((v = this.attributes.get(string = (String)iterator.next())) instanceof StringTemplate) {
                System.out.print(string + "=");
                ((StringTemplate)v).printDebugString();
            } else if (v instanceof List) {
                ArrayList arrayList = (ArrayList)v;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    System.out.print(string + "[" + i + "] is " + e.getClass().getName() + "=");
                    if (e instanceof StringTemplate) {
                        ((StringTemplate)e).printDebugString();
                        continue;
                    }
                    System.out.println(e);
                }
            } else {
                System.out.print(string + "=");
                System.out.println(v);
            }
            ++n;
        }
        System.out.print("]\n");
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        StringTemplateWriter stringTemplateWriter = this.group.getStringTemplateWriter(stringWriter);
        try {
            this.write(stringTemplateWriter);
        }
        catch (IOException iOException) {
            this.error("Got IOException writing to StringWriter????");
        }
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Aggregate {
        protected HashMap properties = new HashMap();

        protected void put(String string, Object object) {
            this.properties.put(string, object);
        }

        public Object get(String string) {
            return this.properties.get(string);
        }
    }
}

