/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.databinding.DeserializationContext;
import org.apache.axis2.databinding.Deserializer;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.axis2.rpc.RPCMethod;
import org.apache.axis2.rpc.RPCParameter;
import org.apache.axis2.rpc.RPCResponseElement;
import org.apache.axis2.rpc.RPCValues;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;

public class RPCInOutMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    public static final String RPCMETHOD_PROPERTY = "rpc.method";

    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        SOAPEnvelope env = inMessage.getEnvelope();
        SOAPBody body = env.getBody();
        OMElement rpcElement = body.getFirstElement();
        OperationContext oc = inMessage.getOperationContext();
        AxisOperation axisOperation = oc.getAxisOperation();
        RPCMethod method = (RPCMethod)axisOperation.getParameter(RPCMETHOD_PROPERTY).getValue();
        if (method == null) {
            throw new AxisFault("Couldn't find RPCMethod in AxisOperation");
        }
        Method javaMethod = method.getJavaMethod();
        Object[] arguments = null;
        Object targetObject = this.getTheImplementationObject(inMessage);
        DeserializationContext dserContext = new DeserializationContext();
        RPCValues values = null;
        try {
            values = this.deserializeRPCElement(dserContext, method, rpcElement);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        arguments = new Object[method.getNumInParams()];
        Iterator params = method.getInParams();
        for (int i = 0; i < arguments.length; ++i) {
            RPCParameter param = (RPCParameter)((Object)params.next());
            arguments[i] = param.getValue(values);
        }
        Object returnValue = null;
        try {
            returnValue = javaMethod.invoke(targetObject, arguments);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        RPCValues responseValues = new RPCValues();
        RPCParameter responseParam = method.getResponseParameter();
        if (responseParam != null) {
            responseValues.setValue(responseParam.getQName(), returnValue);
        }
        try {
            SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope responseEnv = factory.createSOAPEnvelope();
            SOAPBody respBody = factory.createSOAPBody(responseEnv);
            new RPCResponseElement(method, responseValues, (OMElement)respBody);
            outMessage.setEnvelope(responseEnv);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public RPCValues deserializeRPCElement(DeserializationContext dserContext, RPCMethod method, OMElement rpcElement) throws Exception {
        RPCValues values = new RPCValues();
        Iterator args = rpcElement.getChildElements();
        HashMap<QName, Integer> elementCounts = new HashMap<QName, Integer>();
        while (args.hasNext()) {
            OMElement arg = (OMElement)args.next();
            QName qname = arg.getQName();
            RPCParameter param = method.getParameter(qname);
            if (param == null) continue;
            Integer count = (Integer)elementCounts.get(qname);
            if (count == null) {
                count = new Integer(0);
            }
            elementCounts.put(qname, new Integer(count + 1));
            Deserializer dser = param.getDeserializer(count, values);
            try {
                dserContext.deserialize(arg.getXMLStreamReader(), dser);
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
        if (dserContext.isIncomplete()) {
            try {
                dserContext.processRest(rpcElement);
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
            if (dserContext.isIncomplete()) {
                throw new AxisFault("Unresolved multirefs!");
            }
        }
        return values;
    }
}

