/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.SchemaConstants;

public class BeanWriterMetaInfoHolder {
    private boolean ordered = false;
    private boolean anonymous = false;
    private boolean extension = false;
    private String extensionClassName = "";
    private Map elementToSchemaQNameMap = new HashMap();
    private Map elementToJavaClassMap = new HashMap();
    private Map specialTypeFlagMap = new HashMap();
    private Map qNameMaxOccursCountMap = new HashMap();
    private Map qNameMinOccursCountMap = new HashMap();
    private Map qNameOrderMap = new HashMap();

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public void setExtensionClassName(String extensionClassName) {
        this.extensionClassName = extensionClassName;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName) {
        this.registerMapping(qName, schemaName, javaClassName, SchemaConstants.ELEMENT_TYPE);
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName, Integer type) {
        this.elementToJavaClassMap.put(qName, javaClassName);
        this.elementToSchemaQNameMap.put(qName, schemaName);
        this.specialTypeFlagMap.put(qName, type);
    }

    public QName getSchemaQNameForQName(QName eltQName) {
        return (QName)this.elementToSchemaQNameMap.get(eltQName);
    }

    public String getClassNameForQName(QName eltQName) {
        return (String)this.elementToJavaClassMap.get(eltQName);
    }

    public boolean getAttributeStatusForQName(QName qName) {
        Integer attribState = (Integer)this.specialTypeFlagMap.get(qName);
        return attribState != null && attribState.equals(SchemaConstants.ATTRIBUTE_TYPE);
    }

    public boolean getAnyStatusForQName(QName qName) {
        Integer anyState = (Integer)this.specialTypeFlagMap.get(qName);
        return anyState != null && anyState.equals(SchemaConstants.ANY);
    }

    public boolean getArrayStatusForQName(QName qName) {
        Integer anyState = (Integer)this.specialTypeFlagMap.get(qName);
        return anyState != null && anyState.equals(SchemaConstants.ANY_ARRAY_TYPE);
    }

    public boolean getAnyAttributeStatusForQName(QName qName) {
        Integer anyState = (Integer)this.specialTypeFlagMap.get(qName);
        return anyState != null && anyState.equals(SchemaConstants.ANY_ATTRIBUTE_TYPE);
    }

    public void clearTables() {
        this.elementToJavaClassMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToJavaClassMap.clear();
        this.specialTypeFlagMap.clear();
        this.qNameMaxOccursCountMap.clear();
        this.qNameMinOccursCountMap.clear();
        this.qNameOrderMap.clear();
    }

    public void addMinOccurs(QName qName, long minOccurs) {
        this.qNameMinOccursCountMap.put(qName, new Long(minOccurs));
    }

    public void registerQNameIndex(QName qName, int index) {
        this.qNameOrderMap.put(new Integer(index), qName);
    }

    public long getMinOccurs(QName qName) {
        Long l = (Long)this.qNameMinOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public long getMaxOccurs(QName qName) {
        Long l = (Long)this.qNameMaxOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public void addMaxOccurs(QName qName, long maxOccurs) {
        this.qNameMaxOccursCountMap.put(qName, new Long(maxOccurs));
    }

    public Iterator getElementQNameIterator() {
        return this.elementToJavaClassMap.keySet().iterator();
    }

    public QName[] getQNameArray() {
        Set keySet = this.elementToJavaClassMap.keySet();
        return keySet.toArray(new QName[keySet.size()]);
    }

    public QName[] getOrderedQNameArray() {
        Set set = this.qNameOrderMap.keySet();
        int count = set.size();
        Object[] keys = set.toArray(new Integer[count]);
        Arrays.sort(keys);
        QName[] returnQNames = new QName[count];
        for (int i = 0; i < keys.length; ++i) {
            returnQNames[i] = (QName)this.qNameOrderMap.get(keys[i]);
        }
        return returnQNames;
    }
}

