/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import org.apache.axis2.wsdl.builder.WOMBuilderFactory;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.CommandLineOption;
import org.apache.axis2.wsdl.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.wsdl.WSDLDescription;

public class CodeGenerationEngine {
    private List moduleEndpoints = new ArrayList();
    private CodeGenConfiguration configuration;

    public CodeGenerationEngine(CodeGenConfiguration configuration) throws CodeGenerationException {
        this.configuration = configuration;
        this.loadExtensions();
    }

    public CodeGenerationEngine(CommandLineOptionParser parser) throws CodeGenerationException {
        WSDLDescription wom;
        Map allOptions = parser.getAllOptions();
        try {
            CommandLineOption option = (CommandLineOption)allOptions.get("uri");
            wom = this.getWOM(option.getOptionValue());
        }
        catch (WSDLException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), e);
        }
        this.configuration = new CodeGenConfiguration(wom, allOptions);
        this.loadExtensions();
    }

    private void loadExtensions() throws CodeGenerationException {
        String[] extensions = ConfigPropertyFileLoader.getExtensionClassNames();
        for (int i = 0; i < extensions.length; ++i) {
            this.addExtension((CodeGenExtension)this.getObjectFromClassName(extensions[i]));
        }
    }

    private void addExtension(CodeGenExtension ext) {
        ext.init(this.configuration);
        this.moduleEndpoints.add(ext);
    }

    public void generate() throws CodeGenerationException {
        try {
            for (int i = 0; i < this.moduleEndpoints.size(); ++i) {
                ((CodeGenExtension)this.moduleEndpoints.get(i)).engage();
            }
            TypeMapper mapper = this.configuration.getTypeMapper();
            if (mapper == null) {
                throw new CodeGenerationException(CodegenMessages.getMessage("engine.noProperDatabindingException"));
            }
            Map emitterMap = ConfigPropertyFileLoader.getLanguageEmitterMap();
            String className = emitterMap.get(this.configuration.getOutputLanguage()).toString();
            if (className == null) {
                throw new Exception(CodegenMessages.getMessage("engine.emitterMissing"));
            }
            Emitter emitter = (Emitter)this.getObjectFromClassName(className);
            emitter.setCodeGenConfiguration(this.configuration);
            emitter.setMapper(mapper);
            if (this.configuration.isServerSide()) {
                emitter.emitSkeleton();
            }
            if (!this.configuration.isServerSide() || this.configuration.isWriteTestCase()) {
                emitter.emitStub();
            }
        }
        catch (ClassCastException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wrongEmitter"), e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private WSDLDescription getWOM(String uri) throws WSDLException {
        return WOMBuilderFactory.getBuilder((int)1).build(uri).getDescription();
    }

    private Object getObjectFromClassName(String className) throws CodeGenerationException {
        try {
            Class<?> extensionClass = this.getClass().getClassLoader().loadClass(className);
            return extensionClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.extensionLoadProblem"), e);
        }
        catch (InstantiationException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.extensionInstantiationProblem"), e);
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.illegalExtension"), e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }
}

