/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.CommandLineOption;
import org.apache.axis2.wsdl.util.CommandLineOptionConstants;

class CodegenConfigLoader
implements CommandLineOptionConstants {
    CodegenConfigLoader() {
    }

    public static void loadConfig(CodeGenConfiguration config, Map optionMap) {
        CommandLineOption portNameOption;
        CommandLineOption unwrapClassesOption;
        CommandLineOption dataBindingOption;
        CommandLineOption langOption;
        CommandLineOption packageOption;
        boolean syncFlagPresent;
        String outputLocation = ".";
        CommandLineOption outputLocationOption = CodegenConfigLoader.loadOption("o", "output", optionMap);
        if (outputLocationOption != null) {
            outputLocation = outputLocationOption.getOptionValue();
        }
        File outputLocationFile = new File(outputLocation);
        config.setOutputLocation(outputLocationFile);
        if (outputLocationFile.exists()) {
            if (outputLocationFile.isFile()) {
                throw new RuntimeException(CodegenMessages.getMessage("options.notADirectoryException"));
            }
        } else {
            outputLocationFile.mkdirs();
        }
        config.setServerSide(CodegenConfigLoader.loadOption("ss", "server-side", optionMap) != null);
        config.setGenerateDeployementDescriptor(CodegenConfigLoader.loadOption("sd", "service-description", optionMap) != null);
        config.setWriteTestCase(CodegenConfigLoader.loadOption("t", "t", optionMap) != null);
        boolean asyncFlagPresent = CodegenConfigLoader.loadOption("a", "async", optionMap) != null;
        boolean bl = syncFlagPresent = CodegenConfigLoader.loadOption("s", "sync", optionMap) != null;
        if (asyncFlagPresent) {
            config.setAsyncOn(true);
            config.setSyncOn(false);
        }
        if (syncFlagPresent) {
            config.setAsyncOn(false);
            config.setSyncOn(true);
        }
        if ((packageOption = CodegenConfigLoader.loadOption("p", "package", optionMap)) != null) {
            config.setPackageName(packageOption.getOptionValue());
        }
        if ((langOption = CodegenConfigLoader.loadOption("l", "language", optionMap)) != null) {
            config.setOutputLanguage(langOption.getOptionValue());
        }
        if ((dataBindingOption = CodegenConfigLoader.loadOption("d", "databinding-method", optionMap)) != null) {
            config.setDatabindingType(dataBindingOption.getOptionValue());
        }
        if ((unwrapClassesOption = CodegenConfigLoader.loadOption("u", "unpack-classes", optionMap)) != null) {
            config.setPackClasses(false);
        }
        config.setPortName((portNameOption = CodegenConfigLoader.loadOption("pn", "port-name", optionMap)) != null ? portNameOption.getOptionValue() : null);
        CommandLineOption serviceNameOption = CodegenConfigLoader.loadOption("sn", "service-name", optionMap);
        config.setServiceName(serviceNameOption != null ? serviceNameOption.getOptionValue() : null);
        CommandLineOption generateAllOption = CodegenConfigLoader.loadOption("g", "generate-all", optionMap);
        if (generateAllOption != null) {
            config.setGenerateAll(true);
        }
        Iterator keyIterator = optionMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            CommandLineOption option = (CommandLineOption)optionMap.get(key);
            if (!key.toString().startsWith("E")) continue;
            config.getProperties().put(key.toString().replaceFirst("E", ""), option.getOptionValue());
        }
    }

    private static CommandLineOption loadOption(String shortOption, String longOption, Map options) {
        CommandLineOption option = null;
        if (longOption != null && (option = (CommandLineOption)options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = (CommandLineOption)options.get(shortOption);
        }
        return option;
    }
}

