/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis2.wsdl.codegen.extension.AbstractCodeGenerationExtension;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLExtensibilityAttribute;
import org.apache.wsdl.WSDLExtensibilityElement;
import org.apache.wsdl.WSDLInterface;

public class AxisBindingBuilder
extends AbstractCodeGenerationExtension {
    public static final String AXIS_NAMESPACE = "http://ws.apache.org/axis2/";
    public static final QName AXIS_BINDING_QNAME = new QName("http://ws.apache.org/axis2/", "codeGenerationBinding", "axis");

    public void engage() {
        WSDLDescription wom = this.configuration.getWom();
        Map bindingMap = wom.getBindings();
        Vector<WSDLBinding> bindingVector = new Vector<WSDLBinding>();
        if (bindingMap == null || bindingMap.isEmpty()) {
            this.log.info((Object)CodegenMessages.getMessage("extension.bindingMissing"));
        } else {
            Collection bindingCollection = bindingMap.values();
            Iterator iterator = bindingCollection.iterator();
            while (iterator.hasNext()) {
                WSDLBinding binding = (WSDLBinding)iterator.next();
                WSDLBinding newBinding = wom.createBinding();
                newBinding.setName(AXIS_BINDING_QNAME);
                WSDLInterface boundInterface = binding.getBoundInterface();
                newBinding.setBoundInterface(boundInterface);
                newBinding.setBindingFaults(binding.getBindingFaults());
                newBinding.setBindingOperations(binding.getBindingOperations());
                Iterator elementIterator = binding.getExtensibilityElements().iterator();
                while (elementIterator.hasNext()) {
                    newBinding.addExtensibilityElement((WSDLExtensibilityElement)elementIterator.next());
                }
                Iterator attributeIterator = binding.getExtensibilityAttributes().iterator();
                while (attributeIterator.hasNext()) {
                    newBinding.addExtensibleAttributes((WSDLExtensibilityAttribute)attributeIterator.next());
                }
                bindingVector.add(newBinding);
            }
            wom.getBindings().clear();
            for (int i = 0; i < bindingVector.size(); ++i) {
                wom.addBinding((WSDLBinding)bindingVector.get(i));
            }
        }
    }
}

