/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.wsdl.codegen.extension.AbstractDBProcessingExtension;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.wsdl.WSDLExtensibilityElement;
import org.apache.wsdl.WSDLTypes;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.Schema;
import org.w3c.dom.Element;

public class SimpleDBExtension
extends AbstractDBProcessingExtension {
    public void engage() {
        if (this.testFallThrough(this.configuration.getDatabindingType())) {
            return;
        }
        try {
            QName qNameKey;
            Iterator processedkeys;
            WSDLTypes typesList = this.configuration.getWom().getTypes();
            if (typesList == null) {
                this.configuration.setTypeMapper(new DefaultTypeMapper());
                return;
            }
            List typesArray = typesList.getExtensibilityElements();
            Vector<XmlSchema> xmlSchemaTypeVector = new Vector<XmlSchema>();
            XmlSchemaCollection schemaColl = new XmlSchemaCollection();
            for (int i = 0; i < typesArray.size(); ++i) {
                WSDLExtensibilityElement extensiblityElt = (WSDLExtensibilityElement)typesArray.get(i);
                Map nsMap = this.configuration.getWom().getNamespaces();
                Iterator keys = nsMap.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    schemaColl.mapNamespace(key, (String)nsMap.get(key));
                }
                if (!ExtensionConstants.SCHEMA.equals(extensiblityElt.getType())) continue;
                Schema schema = (Schema)extensiblityElt;
                Stack importedSchemaStack = schema.getImportedSchemaStack();
                while (!importedSchemaStack.isEmpty()) {
                    Element el = (Element)importedSchemaStack.pop();
                    if (el == null) continue;
                    XmlSchema thisSchema = schemaColl.read(el);
                    xmlSchemaTypeVector.add(thisSchema);
                }
            }
            CompilerOptions options = new CompilerOptions();
            this.setDefaultOptions(options);
            this.setUserparameters(options);
            SchemaCompiler schemaCompiler = new SchemaCompiler(options);
            schemaCompiler.compile(xmlSchemaTypeVector);
            JavaTypeMapper mapper = new JavaTypeMapper();
            if (options.isWriteOutput()) {
                HashMap processedMap = schemaCompiler.getProcessedElementMap();
                processedkeys = processedMap.keySet().iterator();
                while (processedkeys.hasNext()) {
                    qNameKey = (QName)processedkeys.next();
                    mapper.addTypeMappingName(qNameKey, processedMap.get(qNameKey).toString());
                }
            } else {
                Map processedModelMap = schemaCompiler.getProcessedModelMap();
                processedkeys = processedModelMap.keySet().iterator();
                while (processedkeys.hasNext()) {
                    qNameKey = (QName)processedkeys.next();
                    mapper.addTypeMappingObject(qNameKey, processedModelMap.get(qNameKey));
                }
                HashMap processedMap = schemaCompiler.getProcessedElementMap();
                processedkeys = processedMap.keySet().iterator();
                while (processedkeys.hasNext()) {
                    qNameKey = (QName)processedkeys.next();
                    mapper.addTypeMappingName(qNameKey, processedMap.get(qNameKey).toString());
                }
                this.configuration.putProperty("externalTemplate", schemaCompiler.getCompilerProperties().getProperty("schema.bean.writer.template"));
            }
            this.configuration.setTypeMapper(mapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setUserparameters(CompilerOptions options) {
        Map propertyMap = this.configuration.getProperties();
        if (propertyMap.containsKey("w")) {
            if (Boolean.valueOf(propertyMap.get("w").toString()).booleanValue()) {
                options.setWrapClasses(true);
            } else {
                options.setWrapClasses(false);
            }
        }
        if (propertyMap.containsKey("r")) {
            if (Boolean.valueOf(propertyMap.get("r").toString()).booleanValue()) {
                options.setWriteOutput(true);
            } else {
                options.setWriteOutput(false);
            }
        }
    }

    private void setDefaultOptions(CompilerOptions options) {
        File outputDir = new File(this.configuration.getOutputLocation(), "src");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        options.setOutputLocation(outputDir);
        if (this.configuration.isServerSide()) {
            options.setWrapClasses(false);
            options.setWriteOutput(true);
        } else {
            options.setWrapClasses(this.configuration.isPackClasses());
            options.setWriteOutput(false);
        }
    }
}

