/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.Iterator;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.extension.AbstractCodeGenerationExtension;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.wsdl.WSDLExtensibilityElement;
import org.apache.wsdl.WSDLTypes;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.Schema;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class WSDLValidatorExtension
extends AbstractCodeGenerationExtension {
    private static String TARGETNAMESPACE_STRING = "targetNamespace";

    public void engage() throws CodeGenerationException {
        WSDLTypes typesList = this.configuration.getWom().getTypes();
        if (typesList == null) {
            return;
        }
        Iterator iterator = typesList.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            WSDLExtensibilityElement element = (WSDLExtensibilityElement)iterator.next();
            boolean targetnamespaceFound = false;
            if (!ExtensionConstants.SCHEMA.equals(element.getType())) continue;
            Schema schema = (Schema)element;
            Element schemaElement = schema.getElement();
            NodeList importNodeList = schemaElement.getElementsByTagNameNS(schemaElement.getNamespaceURI(), "import");
            NodeList allNodes = schemaElement.getElementsByTagName("*");
            if (importNodeList.getLength() == 1 && allNodes.getLength() == 1) {
                return;
            }
            NamedNodeMap attributes = schemaElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!TARGETNAMESPACE_STRING.equalsIgnoreCase(attributes.item(i).getNodeName())) continue;
                targetnamespaceFound = true;
                break;
            }
            if (targetnamespaceFound) continue;
            throw new CodeGenerationException(CodegenMessages.getMessage("extension.invalidWSDL", schema.getName().toString()));
        }
    }
}

