/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.wsdl.codegen.extension.AbstractDBProcessingExtension;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.axis2.wsdl.util.XSLTConstants;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingMessageReference;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLExtensibilityElement;
import org.apache.wsdl.WSDLTypes;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.SOAPBody;
import org.apache.wsdl.extensions.Schema;
import org.apache.xmlbeans.BindingConfig;
import org.apache.xmlbeans.Filer;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBeansExtension
extends AbstractDBProcessingExtension {
    public static final String SCHEMA_FOLDER = "schemas";
    public static String MAPPINGS = "mappings";
    public static String MAPPING = "mapping";
    public static String MESSAGE = "message";
    public static String JAVA_NAME = "javaclass";
    public static final String MAPPING_FOLDER = "Mapping";
    public static final String MAPPER_FILE_NAME = "mapper";
    public static final String SCHEMA_PATH = "/org/apache/axis2/wsdl/codegen/schema/";
    boolean debug = false;

    public void engage() {
        if (this.testFallThrough(this.configuration.getDatabindingType())) {
            return;
        }
        this.checkCompatibility();
        Element[] additionalSchemas = this.loadAdditionalSchemas();
        try {
            int i;
            WSDLTypes typesList = this.configuration.getWom().getTypes();
            if (typesList == null) {
                this.configuration.setTypeMapper(new DefaultTypeMapper());
                return;
            }
            List typesArray = typesList.getExtensibilityElements();
            ArrayList<String> processedSchemas = new ArrayList<String>();
            Vector<XmlObject> xmlObjectsVector = new Vector<XmlObject>();
            JavaTypeMapper mapper = new JavaTypeMapper();
            for (i = 0; i < typesArray.size(); ++i) {
                WSDLExtensibilityElement extensiblityElt = (WSDLExtensibilityElement)typesArray.get(i);
                if (!ExtensionConstants.SCHEMA.equals(extensiblityElt.getType())) continue;
                Schema schema = (Schema)extensiblityElt;
                XmlOptions options = new XmlOptions();
                options.setLoadAdditionalNamespaces(this.configuration.getWom().getNamespaces());
                Stack importedSchemaStack = schema.getImportedSchemaStack();
                File schemaFolder = null;
                if (this.debug) {
                    schemaFolder = new File(this.configuration.getOutputLocation(), SCHEMA_FOLDER);
                    schemaFolder.mkdir();
                }
                while (!importedSchemaStack.isEmpty()) {
                    Element element = (Element)importedSchemaStack.pop();
                    String tagetNamespace = element.getAttribute("targetNamespace");
                    if (processedSchemas.contains(tagetNamespace)) continue;
                    if (this.debug) {
                        String s = DOM2Writer.nodeToString((Node)element);
                        File tempFile = File.createTempFile("temp", ".xsd", schemaFolder);
                        FileWriter writer = new FileWriter(tempFile);
                        writer.write(s);
                        writer.flush();
                        writer.close();
                    }
                    xmlObjectsVector.add(XmlObject.Factory.parse((Node)element, (XmlOptions)options));
                    processedSchemas.add(tagetNamespace);
                }
            }
            for (i = 0; i < additionalSchemas.length; ++i) {
                xmlObjectsVector.add(XmlObject.Factory.parse((Node)additionalSchemas[i], null));
            }
            XmlObject[] objeArray = this.convertToXMLObjectArray(xmlObjectsVector);
            Axis2BindingConfig config = new Axis2BindingConfig();
            SchemaTypeSystem sts = XmlBeans.compileXmlBeans(null, null, (XmlObject[])objeArray, (BindingConfig)config, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (Filer)new Axis2Filer(), null);
            this.FindBase64Types(sts);
            SchemaType[] schemaType = sts.documentTypes();
            for (int j = 0; j < schemaType.length; ++j) {
                SchemaType type = schemaType[j];
                mapper.addTypeMappingName(type.getDocumentElementName(), type.getFullJavaName());
            }
            this.configuration.setTypeMapper(mapper);
            if (this.debug) {
                this.writeMappingsToFile(mapper.getAllMappedNames());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeMappingsToFile(Map typeMappings) throws IOException {
        File typeMappingFolder = new File(this.configuration.getOutputLocation(), MAPPING_FOLDER);
        if (!typeMappingFolder.exists()) {
            typeMappingFolder.mkdir();
        }
        File typeMappingFile = File.createTempFile(MAPPER_FILE_NAME, ".xml", typeMappingFolder);
        BufferedWriter out = new BufferedWriter(new FileWriter(typeMappingFile));
        out.write("<" + MAPPINGS + ">");
        Iterator iterator = typeMappings.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            String fullJavaName = (String)typeMappings.get(qName);
            out.write("<" + MAPPING + ">");
            out.write("<" + MESSAGE + ">" + qName.getLocalPart() + "</" + MESSAGE + ">");
            out.write("<" + JAVA_NAME + ">" + fullJavaName + "</" + JAVA_NAME + ">");
            out.write("</" + MAPPING + ">");
        }
        out.write("</" + MAPPINGS + ">");
        out.close();
    }

    private void FindBase64Types(SchemaTypeSystem sts) {
        ArrayList<SchemaType> allSeenTypes = new ArrayList<SchemaType>();
        ArrayList<QName> base64ElementQNamesList = new ArrayList<QName>();
        allSeenTypes.addAll(Arrays.asList(sts.documentTypes()));
        allSeenTypes.addAll(Arrays.asList(sts.globalTypes()));
        for (int i = 0; i < allSeenTypes.size(); ++i) {
            SchemaType sType = (SchemaType)allSeenTypes.get(i);
            if (sType.getContentType() == 2 && sType.getPrimitiveType() != null && XSLTConstants.BASE_64_CONTENT_QNAME.equals(sType.getPrimitiveType().getName())) {
                SchemaType outerType = sType.getOuterType();
                SchemaProperty[] properties = sType.getProperties();
                for (int j = 0; j < properties.length; ++j) {
                    if (!XSLTConstants.XMIME_CONTENT_TYPE_QNAME.equals(properties[j].getName())) continue;
                    base64ElementQNamesList.add(outerType.getDocumentElementName());
                    break;
                }
            }
            allSeenTypes.addAll(Arrays.asList(sType.getAnonymousTypes()));
        }
        this.configuration.putProperty("base64map", base64ElementQNamesList);
    }

    private Element[] loadAdditionalSchemas() {
        Element[] schemaElements;
        String[] schemaNames = ConfigPropertyFileLoader.getThirdPartySchemaNames();
        try {
            int i;
            ArrayList<Element> additionalSchemaElements = new ArrayList<Element>();
            DocumentBuilder documentBuilder = this.getNamespaceAwareDocumentBuilder();
            for (i = 0; i < schemaNames.length; ++i) {
                if ("".equals(schemaNames[i].trim())) continue;
                InputStream schemaStream = this.getClass().getResourceAsStream(SCHEMA_PATH + schemaNames[i]);
                Document doc = documentBuilder.parse(schemaStream);
                additionalSchemaElements.add(doc.getDocumentElement());
            }
            schemaElements = new Element[additionalSchemaElements.size()];
            for (i = 0; i < additionalSchemaElements.size(); ++i) {
                schemaElements[i] = (Element)additionalSchemaElements.get(i);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(CodegenMessages.getMessage("extension.additionalSchemaFailure"), e);
        }
        return schemaElements;
    }

    private DocumentBuilder getNamespaceAwareDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    private void checkCompatibility() {
        Map bindingMap = this.configuration.getWom().getBindings();
        Collection col = bindingMap.values();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            WSDLBinding b = (WSDLBinding)iterator.next();
            HashMap bindingOps = b.getBindingOperations();
            Collection bindingOpsCollection = bindingOps.values();
            Iterator iterator1 = bindingOpsCollection.iterator();
            while (iterator1.hasNext()) {
                this.foo((WSDLBindingOperation)iterator1.next());
            }
        }
    }

    protected void foo(WSDLBindingOperation bindingOp) {
        WSDLBindingMessageReference input = bindingOp.getInput();
        if (input != null) {
            Iterator extIterator = input.getExtensibilityElements().iterator();
            while (extIterator.hasNext()) {
                WSDLExtensibilityElement element = (WSDLExtensibilityElement)extIterator.next();
                if (!ExtensionConstants.SOAP_11_BODY.equals(element.getType()) && !ExtensionConstants.SOAP_12_BODY.equals(element.getType()) || !"encoded".equals(((SOAPBody)element).getUse())) continue;
                throw new RuntimeException(CodegenMessages.getMessage("extension.encodedNotSupported"));
            }
        }
    }

    private XmlObject[] convertToXMLObjectArray(Vector vec) {
        return vec.toArray(new XmlObject[vec.size()]);
    }

    private class Axis2BindingConfig
    extends BindingConfig {
        private Axis2BindingConfig() {
        }

        public String lookupPackageForNamespace(String uri) {
            return URLProcessor.makePackageName(uri);
        }
    }

    private class Axis2Filer
    implements Filer {
        private Axis2Filer() {
        }

        public OutputStream createBinaryFile(String typename) throws IOException {
            File resourcesDirectory = new File(XMLBeansExtension.this.configuration.getOutputLocation(), "resources");
            if (!resourcesDirectory.exists()) {
                resourcesDirectory.mkdirs();
            }
            File file = new File(resourcesDirectory, typename);
            file.getParentFile().mkdirs();
            file.createNewFile();
            return new FileOutputStream(file);
        }

        public Writer createSourceFile(String typename) throws IOException {
            typename = typename.replace('.', File.separatorChar);
            File outputDir = new File(XMLBeansExtension.this.configuration.getOutputLocation(), "src");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File file = new File(outputDir, typename + ".java");
            file.getParentFile().mkdirs();
            file.createNewFile();
            return new FileWriter(file);
        }
    }
}

