/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.codegen.writer.PrettyPrinter;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaBeanWriter
implements BeanWriter {
    public static final String WRAPPED_DATABINDING_CLASS_NAME = "WrappedDatabinder";
    private String javaBeanTemplateName = null;
    private boolean templateLoaded = false;
    private Templates templateCache;
    private List namesList;
    private static int count = 0;
    private boolean wrapClasses = false;
    private boolean writeClasses = false;
    private String packageName = null;
    private File rootDir;
    private Document globalWrappedDocument;
    private Map modelMap = new HashMap();
    private static final String DEFAULT_PACKAGE = "adb";
    private Map baseTypeMap = new JavaTypeMap().getTypeMap();
    private Map ns2packageNameMap = new HashMap();
    private int lastPrefixIndex = 1;
    HashMap mapURItoPrefix = new HashMap();
    HashMap mapPrefixtoURI = new HashMap();

    public Map getModelMap() {
        return this.modelMap;
    }

    public void init(CompilerOptions options) throws SchemaCompilationException {
        try {
            this.initWithFile(options.getOutputLocation());
            this.packageName = options.getPackageName();
            this.writeClasses = options.isWriteOutput();
            this.wrapClasses = !this.writeClasses ? false : options.isWrapClasses();
            if (options.isWrapClasses()) {
                this.globalWrappedDocument = XSLTUtils.getDocument();
                Element rootElement = XSLTUtils.getElement(this.globalWrappedDocument, "beans");
                this.globalWrappedDocument.appendChild(rootElement);
                XSLTUtils.addAttribute(this.globalWrappedDocument, "name", WRAPPED_DATABINDING_CLASS_NAME, rootElement);
                String tempPackageName = this.packageName != null && this.packageName.endsWith(".") ? this.packageName.substring(0, this.packageName.lastIndexOf(".")) : DEFAULT_PACKAGE;
                XSLTUtils.addAttribute(this.globalWrappedDocument, "package", tempPackageName, rootElement);
            }
            this.ns2packageNameMap = options.getNs2PackageMap();
        }
        catch (IOException e) {
            throw new SchemaCompilationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(e);
        }
    }

    public String write(XmlSchemaElement element, Map typeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = element.getQName();
            return this.process(qName, metainf, typeMap, true, null);
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public String write(XmlSchemaComplexType complexType, Map typeMap, BeanWriterMetaInfoHolder metainf, String fullyQualifiedClassName) throws SchemaCompilationException {
        try {
            QName qName = complexType.getQName();
            return this.process(qName, metainf, typeMap, false, fullyQualifiedClassName);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void writeBatch() throws SchemaCompilationException {
        try {
            if (this.wrapClasses) {
                String tempPackage = this.packageName == null ? DEFAULT_PACKAGE : this.packageName;
                File out = this.createOutFile(tempPackage, WRAPPED_DATABINDING_CLASS_NAME);
                this.parse(this.globalWrappedDocument, out);
            }
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public String write(XmlSchemaSimpleType simpleType, Map typeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.notimplementedxception"));
    }

    private void initWithFile(File rootDir) throws IOException {
        if (rootDir == null) {
            this.rootDir = new File(".");
        } else {
            if (!rootDir.isDirectory()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.rootnotfolderexception"));
            }
            this.rootDir = rootDir;
        }
        this.namesList = new ArrayList();
        this.javaBeanTemplateName = SchemaPropertyLoader.getBeanTemplate();
    }

    public String makeFullyQualifiedClassName(QName qName) {
        String namespaceURI = qName.getNamespaceURI();
        String basePackageName = this.ns2packageNameMap.containsKey(namespaceURI) ? (String)this.ns2packageNameMap.get(namespaceURI) : URLProcessor.makePackageName(namespaceURI);
        String packageName = this.packageName == null ? basePackageName : this.packageName + basePackageName;
        String originalName = qName.getLocalPart();
        String className = this.makeUniqueJavaClassName(this.namesList, originalName);
        String packagePrefix = null;
        if (this.wrapClasses) {
            packagePrefix = (this.packageName == null ? "adb." : this.packageName) + WRAPPED_DATABINDING_CLASS_NAME;
        } else if (this.writeClasses) {
            packagePrefix = packageName;
        }
        String fullyqualifiedClassName = packagePrefix != null ? packagePrefix + (packagePrefix.endsWith(".") ? "" : ".") + className : className;
        return fullyqualifiedClassName;
    }

    private String process(QName qName, BeanWriterMetaInfoHolder metainf, Map typeMap, boolean isElement, String fullyQualifiedClassName) throws Exception {
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.makeFullyQualifiedClassName(qName);
        }
        String className = fullyQualifiedClassName.substring(1 + fullyQualifiedClassName.lastIndexOf(46));
        String basePackageName = fullyQualifiedClassName.lastIndexOf(46) == -1 ? "" : fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
        String originalName = qName.getLocalPart();
        ArrayList propertyNames = new ArrayList();
        if (!this.templateLoaded) {
            this.loadTemplate();
        }
        if (this.wrapClasses) {
            this.globalWrappedDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedDocument, className, originalName, basePackageName, qName, isElement, metainf, propertyNames, typeMap));
        } else {
            Document model = XSLTUtils.getDocument();
            model.appendChild(this.getBeanElement(model, className, originalName, basePackageName, qName, isElement, metainf, propertyNames, typeMap));
            if (this.writeClasses) {
                File out = this.createOutFile(basePackageName, className);
                this.parse(model, out);
            }
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), model);
        }
        return fullyQualifiedClassName;
    }

    private Element getBeanElement(Document model, String className, String originalName, String packageName, QName qName, boolean isElement, BeanWriterMetaInfoHolder metainf, ArrayList propertyNames, Map typeMap) throws SchemaCompilationException {
        Element rootElt = XSLTUtils.getElement(model, "bean");
        XSLTUtils.addAttribute(model, "name", className, rootElt);
        XSLTUtils.addAttribute(model, "originalName", originalName, rootElt);
        XSLTUtils.addAttribute(model, "package", packageName, rootElt);
        XSLTUtils.addAttribute(model, "nsuri", qName.getNamespaceURI(), rootElt);
        XSLTUtils.addAttribute(model, "nsprefix", this.getPrefixForURI(qName.getNamespaceURI(), qName.getPrefix()), rootElt);
        if (!this.wrapClasses) {
            XSLTUtils.addAttribute(model, "unwrapped", "yes", rootElt);
        }
        if (!this.writeClasses) {
            XSLTUtils.addAttribute(model, "skip-write", "yes", rootElt);
        }
        if (!isElement) {
            XSLTUtils.addAttribute(model, "type", "yes", rootElt);
        }
        if (metainf.isAnonymous()) {
            XSLTUtils.addAttribute(model, "anon", "yes", rootElt);
        }
        if (metainf.isExtension()) {
            XSLTUtils.addAttribute(model, "extension", metainf.getExtensionClassName(), rootElt);
        }
        if (metainf.isChoice()) {
            XSLTUtils.addAttribute(model, "choice", "yes", rootElt);
        }
        if (metainf.isOrdered()) {
            XSLTUtils.addAttribute(model, "ordered", "yes", rootElt);
        }
        if (isElement && metainf.isNillable(qName)) {
            XSLTUtils.addAttribute(model, "nillable", "yes", rootElt);
        }
        this.populateInfo(metainf, model, rootElt, propertyNames, typeMap, false);
        return rootElt;
    }

    private void populateInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList propertyNames, Map typeMap, boolean isInherited) throws SchemaCompilationException {
        if (metainf.getParent() != null) {
            this.populateInfo(metainf.getParent(), model, rootElt, propertyNames, typeMap, true);
        }
        this.addPropertyEntries(metainf, model, rootElt, propertyNames, typeMap, isInherited);
    }

    private void addPropertyEntries(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList propertyNames, Map typeMap, boolean isInherited) throws SchemaCompilationException {
        QName[] qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int i = 0; i < qNames.length; ++i) {
            Element property = XSLTUtils.addChildElement(model, "property", rootElt);
            QName name = qNames[i];
            String xmlName = name.getLocalPart();
            XSLTUtils.addAttribute(model, "name", xmlName, property);
            XSLTUtils.addAttribute(model, "nsuri", name.getNamespaceURI(), property);
            String javaName = this.makeUniqueJavaClassName(propertyNames, xmlName);
            XSLTUtils.addAttribute(model, "javaname", javaName, property);
            String javaClassNameForElement = metainf.getClassNameForQName(name);
            if (javaClassNameForElement == null) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.typeMissing"));
            }
            XSLTUtils.addAttribute(model, "type", javaClassNameForElement, property);
            if (PrimitiveTypeFinder.isPrimitive(javaClassNameForElement)) {
                XSLTUtils.addAttribute(model, "primitive", "yes", property);
            }
            if (this.isDefault(javaClassNameForElement)) {
                XSLTUtils.addAttribute(model, "default", "yes", property);
            }
            if (typeMap.containsKey(metainf.getSchemaQNameForQName(name))) {
                XSLTUtils.addAttribute(model, "ours", "yes", property);
            }
            if (metainf.getAttributeStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "attribute", "yes", property);
            }
            if (metainf.isNillable(name)) {
                XSLTUtils.addAttribute(model, "nillable", "yes", property);
            }
            String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(javaClassNameForElement)) : this.getShortTypeName(javaClassNameForElement);
            XSLTUtils.addAttribute(model, "shorttypename", shortTypeName, property);
            if (isInherited) {
                XSLTUtils.addAttribute(model, "inherited", "yes", property);
            }
            if (metainf.getAnyStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "any", "yes", property);
            }
            if (metainf.getBinaryStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "binary", "yes", property);
            }
            long minOccurs = metainf.getMinOccurs(name);
            XSLTUtils.addAttribute(model, "minOccurs", minOccurs + "", property);
            if (!metainf.getArrayStatusForQName(name)) continue;
            XSLTUtils.addAttribute(model, "array", "yes", property);
            XSLTUtils.addAttribute(model, "arrayBaseType", javaClassNameForElement.substring(0, javaClassNameForElement.indexOf("[")), property);
            long maxOccurs = metainf.getMaxOccurs(name);
            if (maxOccurs == Long.MAX_VALUE) {
                XSLTUtils.addAttribute(model, "unbound", "yes", property);
                continue;
            }
            XSLTUtils.addAttribute(model, "maxOccurs", maxOccurs + "", property);
        }
    }

    private boolean isDefault(String javaClassNameForElement) {
        return SchemaCompiler.DEFAULT_CLASS_NAME.equals(javaClassNameForElement) || "org.apache.axiom.om.OMElement[]".equals(javaClassNameForElement);
    }

    private String makeUniqueJavaClassName(List listOfNames, String xmlName) {
        String javaName = JavaUtils.isJavaKeyword((String)xmlName) ? JavaUtils.makeNonJavaKeyword((String)xmlName) : JavaUtils.capitalizeFirstChar((String)JavaUtils.xmlNameToJava((String)xmlName));
        while (listOfNames.contains(javaName.toLowerCase())) {
            javaName = javaName + count++;
        }
        listOfNames.add(javaName.toLowerCase());
        return javaName;
    }

    private void loadTemplate() throws SchemaCompilationException {
        Class<?> clazz = this.getClass();
        String templateName = this.javaBeanTemplateName;
        if (templateName != null) {
            try {
                InputStream xslStream = clazz.getResourceAsStream(templateName);
                this.templateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                this.templateLoaded = true;
            }
            catch (TransformerConfigurationException e) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateLoadException"), e);
            }
        } else {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateNotFoundException"));
        }
    }

    private File createOutFile(String packageName, String fileName) throws Exception {
        return FileWriter.createClassFile(this.rootDir, packageName, fileName, ".java");
    }

    private void parse(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, doc, this.templateCache.newTransformer());
        outStream.flush();
        ((OutputStream)outStream).close();
        PrettyPrinter.prettify(outputFile);
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = (String)this.mapURItoPrefix.get(uri);
        if (prefix == null) {
            if (defaultPrefix == null || defaultPrefix.length() == 0) {
                prefix = "ns" + this.lastPrefixIndex++;
                while (this.mapPrefixtoURI.get(prefix) != null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                }
            } else {
                prefix = defaultPrefix;
            }
            this.mapPrefixtoURI.put(prefix, uri);
            this.mapURItoPrefix.put(uri, prefix);
        }
        return prefix;
    }

    private String getShortTypeName(String typeClassName) {
        if (typeClassName.endsWith("[]")) {
            typeClassName = typeClassName.substring(0, typeClassName.lastIndexOf("["));
        }
        return typeClassName.substring(typeClassName.lastIndexOf(".") + 1, typeClassName.length());
    }
}

