/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.emitter;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.writer.AntBuildWriter;
import org.apache.axis2.wsdl.codegen.writer.CallbackHandlerWriter;
import org.apache.axis2.wsdl.codegen.writer.ClassWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceImplementationWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.MessageReceiverWriter;
import org.apache.axis2.wsdl.codegen.writer.SchemaWriter;
import org.apache.axis2.wsdl.codegen.writer.ServiceXMLWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonInterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonWriter;
import org.apache.axis2.wsdl.codegen.writer.TestClassWriter;
import org.apache.axis2.wsdl.codegen.writer.WSDLWriter;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.util.XSLTIncludeResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.policy.Policy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AxisServiceBasedMultiLanguageEmitter
implements Emitter {
    private static final String CALL_BACK_HANDLER_SUFFIX = "CallbackHandler";
    private static final String STUB_SUFFIX = "Stub";
    private static final String TEST_SUFFIX = "Test";
    private static final String SKELETON_CLASS_SUFFIX = "Skeleton";
    private static final String SKELETON_INTERFACE_SUFFIX = "SkeletonInterface";
    private static final String MESSAGE_RECEIVER_SUFFIX = "MessageReceiver";
    private static final String FAULT_SUFFIX = "Exception";
    private static final String DATABINDING_SUPPORTER_NAME_SUFFIX = "DatabindingSupporter";
    private static Map MEPtoClassMap;
    private static Map MEPtoSuffixMap;
    private int uniqueFaultNameCounter = 0;
    private static HashMap constructorMap;
    private static final Log log;
    protected URIResolver resolver;
    private Map infoHolder;
    CodeGenConfiguration codeGenConfiguration;
    protected TypeMapper mapper;
    private AxisService axisService;
    private Map fullyQualifiedFaultClassNameMap = new HashMap();
    private Map InstantiatableFaultClassNameMap = new HashMap();
    private Map faultClassNameMap = new HashMap();
    private Map instantiatableMessageClassNames = new HashMap();

    public AxisServiceBasedMultiLanguageEmitter() {
        this.infoHolder = new HashMap();
    }

    public void setCodeGenConfiguration(CodeGenConfiguration configuration) {
        this.codeGenConfiguration = configuration;
        this.axisService = this.codeGenConfiguration.getAxisService();
        this.resolver = new XSLTIncludeResolver(this.codeGenConfiguration.getProperties());
    }

    public void setMapper(TypeMapper mapper) {
        this.mapper = mapper;
    }

    public void emitStub() throws CodeGenerationException {
        try {
            this.emitStubFromService();
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private void updateMapperForStub() {
        this.updateMapperClassnames(this.getFullyQualifiedStubName());
    }

    private String getFullyQualifiedStubName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + STUB_SUFFIX;
    }

    private void resetFaultNames() {
        this.fullyQualifiedFaultClassNameMap.clear();
        this.faultClassNameMap.clear();
    }

    private void generateAndPopulateFaultNames() {
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation operation = (AxisOperation)operations.next();
            ArrayList faultMessages = operation.getFaultMessages();
            for (int i = 0; i < faultMessages.size(); ++i) {
                AxisMessage faultMessage = (AxisMessage)faultMessages.get(i);
                if (this.fullyQualifiedFaultClassNameMap.containsKey(faultMessage.getElementQName())) continue;
                String className = this.makeJavaClassName(faultMessage.getName() + FAULT_SUFFIX);
                while (this.fullyQualifiedFaultClassNameMap.containsValue(className)) {
                    className = this.makeJavaClassName(className + this.uniqueFaultNameCounter++);
                }
                this.fullyQualifiedFaultClassNameMap.put(faultMessage.getElementQName(), className);
                this.InstantiatableFaultClassNameMap.put(faultMessage.getElementQName(), className);
                this.faultClassNameMap.put(faultMessage.getElementQName(), className);
            }
        }
    }

    private void emitStubFromService() throws Exception {
        if (this.mapper.isObjectMappingPresent()) {
            this.updateMapperForStub();
        } else {
            this.copyToFaultMap();
        }
        this.resetFaultNames();
        this.generateAndPopulateFaultNames();
        this.updateFaultPackageForStub();
        if (!this.codeGenConfiguration.isPackClasses()) {
            this.writeInterface(false);
        }
        this.writeCallBackHandlers();
        this.writeInterfaceImplementation();
        this.writeTestClasses();
        if (!this.codeGenConfiguration.isGenerateAll()) {
            this.writeAntBuild();
        }
    }

    protected void writeAntBuild() throws Exception {
        Document skeletonModel = this.createDOMDocumentForAntBuild();
        this.debugLogDocument("Document for ant build:", skeletonModel);
        AntBuildWriter antBuildWriter = new AntBuildWriter(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getOutputLanguage());
        antBuildWriter.setDatabindingFramework(this.codeGenConfiguration.getDatabindingType());
        this.writeClass(skeletonModel, antBuildWriter);
    }

    protected Document createDOMDocumentForAntBuild() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("ant");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        String packageName = this.codeGenConfiguration.getPackageName();
        String[] dotSeparatedValues = packageName.split("\\.");
        this.addAttribute(doc, "package", dotSeparatedValues[0], rootElement);
        this.addAttribute(doc, "name", serviceName, rootElement);
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeTestClasses() throws Exception {
        if (this.codeGenConfiguration.isWriteTestCase()) {
            Document classModel = this.createDOMDocumentForTestCase();
            this.debugLogDocument("Document for test case:", classModel);
            TestClassWriter callbackWriter = new TestClassWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "test"), this.codeGenConfiguration.getOutputLanguage());
            this.writeClass(classModel, callbackWriter);
        }
    }

    protected Document createDOMDocumentForTestCase() {
        String coreClassName = this.makeJavaClassName(this.axisService.getName());
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", coreClassName + TEST_SUFFIX, rootElement);
        this.addAttribute(doc, "namespace", this.axisService.getTargetNamespace(), rootElement);
        this.addAttribute(doc, "interfaceName", coreClassName, rootElement);
        this.addAttribute(doc, "callbackname", coreClassName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "stubname", coreClassName + STUB_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeInterfaceImplementation() throws Exception {
        Document interfaceImplModel = this.createDOMDocumentForInterfaceImplementation();
        this.debugLogDocument("Document for interface implementation:", interfaceImplModel);
        InterfaceImplementationWriter writer = new InterfaceImplementationWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "src"), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(interfaceImplModel, writer);
    }

    protected Document createDOMDocumentForInterfaceImplementation() throws Exception {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String stubName = localPart + STUB_SUFFIX;
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", packageName, rootElement);
        this.addAttribute(doc, "name", stubName, rootElement);
        this.addAttribute(doc, "servicename", localPart, rootElement);
        this.addAttribute(doc, "namespace", this.axisService.getTargetNamespace(), rootElement);
        this.addAttribute(doc, "interfaceName", localPart, rootElement);
        this.addAttribute(doc, "callbackname", localPart + CALL_BACK_HANDLER_SUFFIX, rootElement);
        if (this.codeGenConfiguration.isPackClasses()) {
            this.addAttribute(doc, "wrapped", "yes", rootElement);
        }
        this.addSoapVersion(doc, rootElement);
        this.addEndpoint(doc, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc));
        Object stubMethods = this.codeGenConfiguration.getProperty("stubMethods");
        if (stubMethods != null) {
            rootElement.appendChild(doc.importNode((Element)stubMethods, true));
        }
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    private Element getUniqueListofFaults(Document doc) {
        Element rootElement = doc.createElement("fault-list");
        Iterator iterator = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            Element faultElement = doc.createElement("fault");
            QName key = (QName)iterator.next();
            this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "intantiatiableName", (String)this.InstantiatableFaultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            String typeMapping = this.mapper.getTypeMappingName(key);
            this.addAttribute(doc, "type", typeMapping == null ? "" : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? "" : attribValue, faultElement);
            if (TypeMapper.DEFAULT_CLASS_NAME.equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            rootElement.appendChild(faultElement);
        }
        return rootElement;
    }

    protected void addEndpoint(Document doc, Element rootElement) throws Exception {
        PolicyInclude policyInclude = this.axisService.getPolicyInclude();
        Policy servicePolicy = policyInclude.getPolicy();
        if (servicePolicy != null) {
            String policyString = PolicyUtil.getPolicyAsString((Policy)servicePolicy);
            this.addAttribute(doc, "policy", policyString, rootElement);
        }
        Element endpointElement = doc.createElement("endpoint");
        String endpoint = this.axisService.getEndpoint();
        Text text = doc.createTextNode(endpoint != null ? endpoint : "");
        endpointElement.appendChild(text);
        rootElement.appendChild(endpointElement);
    }

    protected void addSoapVersion(Document doc, Element rootElement) {
        String soapNsUri = this.axisService.getSoapNsUri();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(soapNsUri)) {
            this.addAttribute(doc, "soap-version", "1.1", rootElement);
        } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(soapNsUri)) {
            this.addAttribute(doc, "soap-version", "1.2", rootElement);
        }
    }

    protected void writeCallBackHandlers() throws Exception {
        if (this.codeGenConfiguration.isAsyncOn()) {
            Document interfaceModel = this.createDOMDocumentForCallbackHandler();
            this.debugLogDocument("Document for callback handler:", interfaceModel);
            CallbackHandlerWriter callbackWriter = new CallbackHandlerWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "src"), this.codeGenConfiguration.getOutputLanguage());
            this.writeClass(interfaceModel, callbackWriter);
        }
    }

    protected Document createDOMDocumentForCallbackHandler() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("callback");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.loadOperations(doc, rootElement, null);
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeInterface(boolean writeDatabinders) throws Exception {
        Document interfaceModel = this.createDOMDocumentForInterface(writeDatabinders);
        this.debugLogDocument("Document for interface:", interfaceModel);
        InterfaceWriter interfaceWriter = new InterfaceWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "src"), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(interfaceModel, interfaceWriter);
    }

    protected Document createDOMDocumentForInterface(boolean writeDatabinders) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String localPart = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", localPart, rootElement);
        this.addAttribute(doc, "callbackname", localPart + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        if (writeDatabinders && this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    public void emitSkeleton() throws CodeGenerationException {
        try {
            this.emitSkeletonService();
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private void updateMapperForMessageReceiver() {
        this.updateMapperClassnames(this.getFullyQualifiedMessageReceiverName());
    }

    private String getFullyQualifiedMessageReceiverName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + MESSAGE_RECEIVER_SUFFIX;
    }

    private String getFullyQualifiedSkeletonName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + SKELETON_CLASS_SUFFIX;
    }

    private void emitSkeletonService() throws Exception {
        if (this.mapper.isObjectMappingPresent()) {
            this.updateMapperForMessageReceiver();
        } else {
            this.copyToFaultMap();
        }
        this.generateAndPopulateFaultNames();
        this.updateFaultPackageForSkeleton();
        if (this.codeGenConfiguration.isServerSideInterface()) {
            this.writeSkeletonInterface();
        }
        this.writeSkeleton();
        this.writeMessageReceiver();
        this.writeServiceXml();
        this.writeAntBuild();
        this.writeWSDLFiles();
    }

    private void writeWSDLFiles() {
        this.axisService.setCustomSchemaNamePrefix("");
        this.axisService.setCustomSchemaNameSuffix(".xsd");
        this.axisService.setSchemaLocationsAdjusted(false);
        this.axisService.populateSchemaMappings();
        SchemaWriter schemaWriter = new SchemaWriter(this.codeGenConfiguration.getOutputLocation());
        Hashtable schemaMappings = this.axisService.getSchemaMappingTable();
        Iterator keys = schemaMappings.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            schemaWriter.writeSchema((XmlSchema)schemaMappings.get(key), (String)key);
        }
        WSDLWriter wsdlWriter = new WSDLWriter(this.codeGenConfiguration.getOutputLocation());
        wsdlWriter.writeWSDL(this.axisService);
    }

    private void copyToFaultMap() {
        Map classNameMap = this.mapper.getAllMappedNames();
        Iterator keys = classNameMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.instantiatableMessageClassNames.put(key, classNameMap.get(key));
        }
    }

    private void updateFaultPackageForStub() {
        Iterator faultClassNameKeys = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (faultClassNameKeys.hasNext()) {
            Object key = faultClassNameKeys.next();
            String className = (String)this.fullyQualifiedFaultClassNameMap.get(key);
            String fullyQualifiedStubName = this.getFullyQualifiedStubName();
            this.fullyQualifiedFaultClassNameMap.put(key, fullyQualifiedStubName + "." + className);
            this.InstantiatableFaultClassNameMap.put(key, fullyQualifiedStubName + "$" + className);
        }
    }

    private void updateFaultPackageForSkeleton() {
        Iterator faultClassNameKeys = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (faultClassNameKeys.hasNext()) {
            Object key = faultClassNameKeys.next();
            String className = (String)this.fullyQualifiedFaultClassNameMap.get(key);
            String fullyQualifiedSkeletonName = this.getFullyQualifiedSkeletonName();
            this.fullyQualifiedFaultClassNameMap.put(key, fullyQualifiedSkeletonName + "." + className);
            this.InstantiatableFaultClassNameMap.put(key, fullyQualifiedSkeletonName + "$" + className);
        }
    }

    protected void writeMessageReceiver() throws Exception {
        if (this.codeGenConfiguration.isWriteMessageReceiver()) {
            Iterator it = MEPtoClassMap.keySet().iterator();
            while (it.hasNext()) {
                String mep = (String)it.next();
                Document classModel = this.createDocumentForMessageReceiver(mep, this.codeGenConfiguration.isServerSideInterface());
                this.debugLogDocument("Document for message receiver:", classModel);
                if (!Boolean.TRUE.equals(this.infoHolder.get(mep))) continue;
                MessageReceiverWriter writer = new MessageReceiverWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "src"), this.codeGenConfiguration.getOutputLanguage());
                this.writeClass(classModel, writer);
            }
        }
    }

    protected Document createDocumentForMessageReceiver(String mep, boolean isServerSideInterface) {
        boolean isOpsFound;
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        String localPart = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "name", localPart + MEPtoSuffixMap.get(mep), rootElement);
        this.addAttribute(doc, "skeletonname", localPart + SKELETON_CLASS_SUFFIX, rootElement);
        if (isServerSideInterface) {
            this.addAttribute(doc, "skeletonInterfaceName", localPart + SKELETON_INTERFACE_SUFFIX, rootElement);
        } else {
            this.addAttribute(doc, "skeletonInterfaceName", localPart + SKELETON_CLASS_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "basereceiver", (String)MEPtoClassMap.get(mep), rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.infoHolder.put(mep, (isOpsFound = this.loadOperations(doc, rootElement, mep)) ? Boolean.TRUE : Boolean.FALSE);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc));
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Element createDOMElementforDatabinders(Document doc) {
        HashMap<String, Element> parameterMap = new HashMap<String, Element>();
        Iterator operationsIterator = this.axisService.getOperations();
        while (operationsIterator.hasNext()) {
            int i;
            Element outputParamElement;
            Element inputParamElement;
            AxisOperation axisOperation = (AxisOperation)operationsIterator.next();
            String MEP = axisOperation.getMessageExchangePattern();
            if (this.isInputPresentForMEP(MEP) && (inputParamElement = this.getInputParamElement(doc, axisOperation)) != null) {
                parameterMap.put(inputParamElement.getAttribute("type"), inputParamElement);
            }
            if (this.isOutputPresentForMEP(MEP) && (outputParamElement = this.getOutputParamElement(doc, axisOperation)) != null) {
                parameterMap.put(outputParamElement.getAttribute("type"), outputParamElement);
            }
            Element[] faultParamElements = this.getFaultParamElements(doc, axisOperation);
            for (int i2 = 0; i2 < faultParamElements.length; ++i2) {
                parameterMap.put(faultParamElements[i2].getAttribute("type"), faultParamElements[i2]);
            }
            ArrayList headerParameterQNameList = new ArrayList();
            this.addHeaderOperations(headerParameterQNameList, axisOperation, true);
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                Element newChild = (Element)parameterElementList.get(i);
                parameterMap.put(newChild.getAttribute("type"), newChild);
            }
            headerParameterQNameList.clear();
            parameterElementList.clear();
            this.addHeaderOperations(headerParameterQNameList, axisOperation, false);
            parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                Element newChild = (Element)parameterElementList.get(i);
                parameterMap.put(newChild.getAttribute("type"), newChild);
            }
        }
        Element rootElement = doc.createElement("databinders");
        this.addAttribute(doc, "dbtype", this.codeGenConfiguration.getDatabindingType(), rootElement);
        rootElement.appendChild(this.getBase64Elements(doc));
        Collection parameters = parameterMap.values();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            rootElement.appendChild((Element)iterator.next());
        }
        return rootElement;
    }

    private boolean isInputPresentForMEP(String MEP) {
        return "http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP);
    }

    private Element getBase64Elements(Document doc) {
        Element root = doc.createElement("base64Elements");
        List list = (List)this.codeGenConfiguration.getProperties().get("base64map");
        if (list != null && !list.isEmpty()) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                QName qname = (QName)list.get(i);
                Element elt = doc.createElement("name");
                this.addAttribute(doc, "ns-url", qname.getNamespaceURI(), elt);
                this.addAttribute(doc, "localName", qname.getLocalPart(), elt);
                root.appendChild(elt);
            }
        }
        return root;
    }

    private void processModelObjects(Map objectMappings, Element root, Document doc) {
        Iterator objectIterator = objectMappings.values().iterator();
        while (objectIterator.hasNext()) {
            Object o = objectIterator.next();
            if (!(o instanceof Document)) continue;
            root.appendChild(doc.importNode(((Document)o).getDocumentElement(), true));
        }
    }

    private void updateMapperClassnames(String fullyQulifiedIncludingClassNamePrefix) {
        Map classNameMap = this.mapper.getAllMappedNames();
        Iterator keys = classNameMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            String className = (String)classNameMap.get(key);
            classNameMap.put(key, fullyQulifiedIncludingClassNamePrefix + "." + className);
            this.instantiatableMessageClassNames.put(key, fullyQulifiedIncludingClassNamePrefix + "$" + className);
        }
    }

    private void writeServiceXml() throws Exception {
        if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
            Document serviceXMLModel = this.createDOMDocumentForServiceXML();
            this.debugLogDocument("Document for service XML:", serviceXMLModel);
            ServiceXMLWriter serviceXmlWriter = new ServiceXMLWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "resources"), this.codeGenConfiguration.getOutputLanguage());
            this.writeClass(serviceXMLModel, serviceXmlWriter);
        }
    }

    private Document createDOMDocumentForServiceXML() {
        Document doc = this.getEmptyDocument();
        String serviceName = this.axisService.getName();
        String className = this.makeJavaClassName(serviceName);
        doc.appendChild(this.getServiceElement(serviceName, className, doc));
        return doc;
    }

    private Node getServiceElement(String serviceName, String className, Document doc) {
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", "", rootElement);
        this.addAttribute(doc, "classpackage", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", className + SKELETON_CLASS_SUFFIX, rootElement);
        if (!this.codeGenConfiguration.isWriteTestCase()) {
            this.addAttribute(doc, "testOmit", "true", rootElement);
        }
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        Iterator it = MEPtoClassMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!Boolean.TRUE.equals(this.infoHolder.get(key))) continue;
            Element elt = this.addElement(doc, "messagereceiver", className + MEPtoSuffixMap.get(key), rootElement);
            this.addAttribute(doc, "mep", key.toString(), elt);
        }
        this.loadOperations(doc, rootElement, null);
        return rootElement;
    }

    private void writeSkeleton() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeleton(this.codeGenConfiguration.isServerSideInterface());
        this.debugLogDocument("Document for skeleton:", skeletonModel);
        SkeletonWriter skeletonWriter = new SkeletonWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "src"), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(skeletonModel, skeletonWriter);
    }

    private void writeSkeletonInterface() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeletonInterface();
        this.debugLogDocument("Document for skeleton Interface:", skeletonModel);
        SkeletonInterfaceWriter skeletonInterfaceWriter = new SkeletonInterfaceWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), "src"), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(skeletonModel, skeletonInterfaceWriter);
    }

    private Document createDOMDocumentForSkeleton(boolean isSkeletonInterface) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", serviceName + SKELETON_CLASS_SUFFIX, rootElement);
        this.addAttribute(doc, "callbackname", serviceName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        if (isSkeletonInterface) {
            this.addAttribute(doc, "skeletonInterfaceName", serviceName + SKELETON_INTERFACE_SUFFIX, rootElement);
        }
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    private Document createDOMDocumentForSkeletonInterface() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", serviceName + SKELETON_INTERFACE_SUFFIX, rootElement);
        this.addAttribute(doc, "callbackname", serviceName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    private boolean loadOperations(Document doc, Element rootElement, String mep) {
        String portTypeName = this.makeJavaClassName(this.axisService.getName());
        Iterator operations = this.axisService.getOperations();
        boolean opsFound = false;
        while (operations.hasNext()) {
            String localPart;
            Element methodElement;
            ArrayList soapHeaderOutputParameterList;
            ArrayList soapHeaderInputParameterList;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            String messageExchangePattern = axisOperation.getMessageExchangePattern();
            if (this.infoHolder.get(messageExchangePattern) == null) {
                this.infoHolder.put(messageExchangePattern, Boolean.TRUE);
            }
            if (mep == null) {
                opsFound = true;
                soapHeaderInputParameterList = new ArrayList();
                soapHeaderOutputParameterList = new ArrayList();
                methodElement = doc.createElement("method");
                localPart = axisOperation.getName().getLocalPart();
                this.addAttribute(doc, "name", localPart, methodElement);
                this.addAttribute(doc, "namespace", axisOperation.getName().getNamespaceURI(), methodElement);
                String style = axisOperation.getStyle();
                this.addAttribute(doc, "style", style, methodElement);
                this.addAttribute(doc, "dbsupportname", portTypeName + localPart + DATABINDING_SUPPORTER_NAME_SUFFIX, methodElement);
                this.addAttribute(doc, "mep", axisOperation.getMessageExchangePattern(), methodElement);
                this.addSOAPAction(doc, methodElement, axisOperation);
                this.addHeaderOperations(soapHeaderInputParameterList, axisOperation, true);
                this.addHeaderOperations(soapHeaderOutputParameterList, axisOperation, false);
                PolicyInclude policyInclude = axisOperation.getPolicyInclude();
                Policy policy = policyInclude.getPolicy();
                if (policy != null) {
                    this.addAttribute(doc, "policy", PolicyUtil.getPolicyAsString((Policy)policy), methodElement);
                }
                methodElement.appendChild(this.getInputElement(doc, axisOperation, soapHeaderInputParameterList));
                methodElement.appendChild(this.getOutputElement(doc, axisOperation, soapHeaderOutputParameterList));
                methodElement.appendChild(this.getFaultElement(doc, axisOperation));
                rootElement.appendChild(methodElement);
                continue;
            }
            if (!mep.equals(axisOperation.getMessageExchangePattern())) continue;
            opsFound = true;
            soapHeaderInputParameterList = new ArrayList();
            soapHeaderOutputParameterList = new ArrayList();
            methodElement = doc.createElement("method");
            localPart = axisOperation.getName().getLocalPart();
            this.addAttribute(doc, "name", localPart, methodElement);
            this.addAttribute(doc, "namespace", axisOperation.getName().getNamespaceURI(), methodElement);
            this.addAttribute(doc, "style", axisOperation.getStyle(), methodElement);
            this.addAttribute(doc, "dbsupportname", portTypeName + localPart + DATABINDING_SUPPORTER_NAME_SUFFIX, methodElement);
            this.addAttribute(doc, "mep", axisOperation.getMessageExchangePattern(), methodElement);
            this.addSOAPAction(doc, methodElement, axisOperation);
            this.addHeaderOperations(soapHeaderInputParameterList, axisOperation, true);
            this.addHeaderOperations(soapHeaderOutputParameterList, axisOperation, false);
            Policy policy = axisOperation.getPolicyInclude().getPolicy();
            if (policy != null) {
                this.addAttribute(doc, "policy", PolicyUtil.getPolicyAsString((Policy)policy), methodElement);
            }
            methodElement.appendChild(this.getInputElement(doc, axisOperation, soapHeaderInputParameterList));
            methodElement.appendChild(this.getOutputElement(doc, axisOperation, soapHeaderOutputParameterList));
            methodElement.appendChild(this.getFaultElement(doc, axisOperation));
            rootElement.appendChild(methodElement);
        }
        return opsFound;
    }

    private Document getEmptyDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String makeJavaClassName(String word) {
        if (JavaUtils.isJavaKeyword((String)word)) {
            return JavaUtils.makeNonJavaKeyword((String)word);
        }
        return JavaUtils.capitalizeFirstChar((String)JavaUtils.xmlNameToJava((String)word));
    }

    protected void addAttribute(Document document, String AttribName, String attribValue, Element element) {
        XSLTUtils.addAttribute(document, AttribName, attribValue, element);
    }

    private void fillSyncAttributes(Document doc, Element rootElement) {
        this.addAttribute(doc, "isAsync", this.codeGenConfiguration.isAsyncOn() ? "1" : "0", rootElement);
        this.addAttribute(doc, "isSync", this.codeGenConfiguration.isSyncOn() ? "1" : "0", rootElement);
    }

    private void debugLogDocument(String description, Document doc) {
        if (log.isDebugEnabled()) {
            try {
                DOMSource source = new DOMSource(doc);
                StringWriter swrite = new StringWriter();
                swrite.write(description);
                swrite.write("\n");
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, new StreamResult(swrite));
                log.debug((Object)swrite.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected File getOutputDirectory(File outputDir, String dir2) {
        if (!(outputDir = new File(outputDir, dir2)).exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    protected void writeClass(Document model, ClassWriter writer) throws IOException, Exception {
        writer.loadTemplate();
        String packageName = model.getDocumentElement().getAttribute("package");
        String className = model.getDocumentElement().getAttribute("name");
        writer.createOutFile(packageName, className);
        writer.parse(model, this.resolver);
    }

    private void addSOAPAction(Document doc, Element rootElement, AxisOperation axisOperation) {
        this.addAttribute(doc, "soapaction", axisOperation.getSoapAction(), rootElement);
    }

    private void addHeaderOperations(List soapHeaderParameterQNameList, AxisOperation axisOperation, boolean input) {
        AxisMessage outAxisMessage;
        ArrayList headerparamList = new ArrayList();
        String MEP = axisOperation.getMessageExchangePattern();
        if (input) {
            AxisMessage inaxisMessage;
            if (this.isInputPresentForMEP(MEP) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                headerparamList = inaxisMessage.getSoapHeaders();
            }
        } else if (this.isOutputPresentForMEP(MEP) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
            headerparamList = outAxisMessage.getSoapHeaders();
        }
        Iterator iterator = headerparamList.iterator();
        while (iterator.hasNext()) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)iterator.next();
            soapHeaderParameterQNameList.add(header.getElement());
        }
    }

    private boolean isOutputPresentForMEP(String MEP) {
        return "http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP);
    }

    protected Element getInputElement(Document doc, AxisOperation operation, List headerParameterQNameList) {
        Element inputElt = doc.createElement("input");
        String MEP = operation.getMessageExchangePattern();
        if (this.isInputPresentForMEP(MEP)) {
            Element param = this.getInputParamElement(doc, operation);
            if (param != null) {
                inputElt.appendChild(param);
            }
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (int i = 0; i < parameterElementList.size(); ++i) {
                inputElt.appendChild((Element)parameterElementList.get(i));
            }
        }
        return inputElt;
    }

    protected Element getFaultElement(Document doc, AxisOperation operation) {
        Element faultElt = doc.createElement("fault");
        Element[] param = this.getFaultParamElements(doc, operation);
        for (int i = 0; i < param.length; ++i) {
            faultElt.appendChild(param[i]);
        }
        return faultElt;
    }

    protected Element getOutputElement(Document doc, AxisOperation operation, List headerParameterQNameList) {
        Element outputElt = doc.createElement("output");
        String MEP = operation.getMessageExchangePattern();
        if (this.isOutputPresentForMEP(MEP)) {
            Element param = this.getOutputParamElement(doc, operation);
            if (param != null) {
                outputElt.appendChild(param);
            }
            List outputElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (int i = 0; i < outputElementList.size(); ++i) {
                outputElt.appendChild((Element)outputElementList.get(i));
            }
        }
        return outputElt;
    }

    private Element[] getFaultParamElements(Document doc, AxisOperation operation) {
        ArrayList<Element> params = new ArrayList<Element>();
        ArrayList faultMessages = operation.getFaultMessages();
        if (faultMessages != null && !faultMessages.isEmpty()) {
            for (int i = 0; i < faultMessages.size(); ++i) {
                Element paramElement = doc.createElement("param");
                AxisMessage msg = (AxisMessage)faultMessages.get(i);
                this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(msg.getElementQName()), paramElement);
                this.addAttribute(doc, "intantiatiableName", (String)this.InstantiatableFaultClassNameMap.get(msg.getElementQName()), paramElement);
                this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(msg.getElementQName()), paramElement);
                this.addAttribute(doc, "namespace", msg.getElementQName().getNamespaceURI(), paramElement);
                this.addAttribute(doc, "localname", msg.getElementQName().getLocalPart(), paramElement);
                String typeMapping = this.mapper.getTypeMappingName(msg.getElementQName());
                this.addAttribute(doc, "type", typeMapping == null ? "" : typeMapping, paramElement);
                String attribValue = (String)this.instantiatableMessageClassNames.get(msg.getElementQName());
                this.addAttribute(doc, "instantiatableType", attribValue == null ? "" : attribValue, paramElement);
                if (TypeMapper.DEFAULT_CLASS_NAME.equals(typeMapping)) {
                    this.addAttribute(doc, "default", "yes", paramElement);
                }
                this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), paramElement);
                Iterator iter = msg.getExtensibilityAttributes().iterator();
                while (iter.hasNext()) {
                }
                params.add(paramElement);
            }
            return params.toArray(new Element[params.size()]);
        }
        return new Element[0];
    }

    private Element getInputParamElement(Document doc, AxisOperation operation) {
        Element param = doc.createElement("param");
        AxisMessage inputMessage = operation.getMessage("In");
        if (inputMessage != null) {
            this.addAttribute(doc, "name", this.mapper.getParameterName(inputMessage.getElementQName()), param);
            String typeMapping = this.mapper.getTypeMappingName(inputMessage.getElementQName());
            this.addAttribute(doc, "type", typeMapping == null ? "" : typeMapping, param);
            if (TypeMapper.DEFAULT_CLASS_NAME.equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", param);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), param);
            this.addAttribute(doc, "location", "body", param);
            Iterator iter = inputMessage.getExtensibilityAttributes().iterator();
            while (iter.hasNext()) {
            }
        } else {
            param = null;
        }
        return param;
    }

    private Element getOutputParamElement(Document doc, AxisOperation operation) {
        String typeMappingStr;
        String parameterName;
        Element param = doc.createElement("param");
        AxisMessage outputMessage = operation.getMessage("Out");
        if (outputMessage != null) {
            parameterName = this.mapper.getParameterName(outputMessage.getElementQName());
            String typeMapping = this.mapper.getTypeMappingName(outputMessage.getElementQName());
            typeMappingStr = typeMapping == null ? "" : typeMapping;
        } else {
            parameterName = "";
            typeMappingStr = "";
        }
        this.addAttribute(doc, "name", parameterName, param);
        this.addAttribute(doc, "type", typeMappingStr, param);
        if (TypeMapper.DEFAULT_CLASS_NAME.equals(typeMappingStr)) {
            this.addAttribute(doc, "default", "yes", param);
        }
        this.addAttribute(doc, "location", "body", param);
        return param;
    }

    private String getParamInitializer(String paramType) {
        String out = (String)constructorMap.get(paramType);
        if (out == null) {
            out = "null";
        }
        return out;
    }

    private List getParameterElementList(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                QName name = (QName)parameters.get(i);
                this.addAttribute(doc, "name", this.mapper.getParameterName(name), param);
                String typeMapping = this.mapper.getTypeMappingName(name);
                String typeMappingStr = typeMapping == null ? "" : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    protected Element addElement(Document document, String eltName, String eltValue, Element element) {
        Element elt = XSLTUtils.addChildElement(document, eltName, element);
        elt.appendChild(document.createTextNode(eltValue));
        return elt;
    }

    static {
        constructorMap = new HashMap(50);
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://double-double\", \"toil-and-trouble\")");
        MEPtoClassMap = new HashMap();
        MEPtoClassMap.put("http://www.w3.org/2004/08/wsdl/in-only", "org.apache.axis2.receivers.AbstractInMessageReceiver");
        MEPtoClassMap.put("http://www.w3.org/2004/08/wsdl/in-out", "org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver");
        MEPtoSuffixMap = new HashMap();
        MEPtoSuffixMap.put("http://www.w3.org/2004/08/wsdl/in-only", "MessageReceiverInOnly");
        MEPtoSuffixMap.put("http://www.w3.org/2004/08/wsdl/in-out", "MessageReceiverInOut");
        log = LogFactory.getLog((Class)AxisServiceBasedMultiLanguageEmitter.class);
    }
}

