/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.Randomizer;
import barsuift.simLife.UtilDataCreatorForTests;
import barsuift.simLife.environment.EnvironmentState;
import barsuift.simLife.environment.SunState;
import barsuift.simLife.j3d.DisplayDataCreatorForTests;
import barsuift.simLife.j3d.SimLifeCanvas3DState;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;
import barsuift.simLife.time.TimeCounterState;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.tree.TreeTrunkState;
import barsuift.simLife.universe.UniverseContextState;
import barsuift.simLife.universe.UniverseState;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;

public final class CoreDataCreatorForTests {
    private CoreDataCreatorForTests() {
    }

    public static UniverseContextState createRandomUniverseContextState() {
        UniverseState universeState = CoreDataCreatorForTests.createRandomUniverseState();
        SimLifeCanvas3DState canvasState = DisplayDataCreatorForTests.createSpecificCanvasState();
        boolean axisShowing = UtilDataCreatorForTests.createRandomBoolean();
        double[] viewerTransform = DisplayDataCreatorForTests.createSpecificTransform3D();
        return new UniverseContextState(universeState, canvasState, axisShowing, viewerTransform);
    }

    public static UniverseContextState createSpecificUniverseContextState() {
        UniverseState universeState = CoreDataCreatorForTests.createSpecificUniverseState();
        SimLifeCanvas3DState canvasState = DisplayDataCreatorForTests.createSpecificCanvasState();
        boolean axisShowing = true;
        double[] viewerTransform = DisplayDataCreatorForTests.createSpecificTransform3D();
        return new UniverseContextState(universeState, canvasState, axisShowing, viewerTransform);
    }

    public static UniverseState createRandomUniverseState() {
        int age = Randomizer.randomBetween((int)0, (int)100);
        boolean fpsShowing = UtilDataCreatorForTests.createRandomBoolean();
        HashSet<TreeState> trees = new HashSet<TreeState>();
        trees.add(CoreDataCreatorForTests.createRandomTreeState());
        trees.add(CoreDataCreatorForTests.createRandomTreeState());
        trees.add(CoreDataCreatorForTests.createRandomTreeState());
        int nbFallenLeaves = Randomizer.randomBetween((int)0, (int)40);
        HashSet<TreeLeafState> fallenLeaves = new HashSet<TreeLeafState>(nbFallenLeaves);
        for (int i = 0; i < nbFallenLeaves; ++i) {
            fallenLeaves.add(CoreDataCreatorForTests.createRandomTreeLeafState());
        }
        return new UniverseState(age, fpsShowing, trees, fallenLeaves, CoreDataCreatorForTests.createRandomEnvironmentState(), CoreDataCreatorForTests.createRandomTimeCounterState());
    }

    public static UniverseState createSpecificUniverseState() {
        int age = 15;
        boolean fpsShowing = false;
        HashSet<TreeState> trees = new HashSet<TreeState>();
        trees.add(CoreDataCreatorForTests.createSpecificTreeState());
        trees.add(CoreDataCreatorForTests.createSpecificTreeState());
        trees.add(CoreDataCreatorForTests.createSpecificTreeState());
        int nbFallenLeaves = 20;
        HashSet<TreeLeafState> fallenLeaves = new HashSet<TreeLeafState>(nbFallenLeaves);
        for (int i = 0; i < nbFallenLeaves; ++i) {
            fallenLeaves.add(CoreDataCreatorForTests.createSpecificTreeLeafState());
        }
        return new UniverseState(age, fpsShowing, trees, fallenLeaves, CoreDataCreatorForTests.createSpecificEnvironmentState(), CoreDataCreatorForTests.createSpecificTimeCounterState());
    }

    public static EnvironmentState createRandomEnvironmentState() {
        return new EnvironmentState(CoreDataCreatorForTests.createRandomSunState());
    }

    public static EnvironmentState createSpecificEnvironmentState() {
        return new EnvironmentState(CoreDataCreatorForTests.createSpecificSunState());
    }

    public static SunState createRandomSunState() {
        BigDecimal luminosity = UtilDataCreatorForTests.createRandomBigDecimal();
        BigDecimal riseAngle = UtilDataCreatorForTests.createRandomBigDecimal();
        BigDecimal zenithAngle = UtilDataCreatorForTests.createRandomBigDecimal();
        return new SunState(luminosity, riseAngle, zenithAngle);
    }

    public static SunState createSpecificSunState() {
        BigDecimal luminosity = PercentHelper.getDecimalValue((int)70);
        BigDecimal riseAngle = PercentHelper.getDecimalValue((int)25);
        BigDecimal zenithAngle = PercentHelper.getDecimalValue((int)50);
        return new SunState(luminosity, riseAngle, zenithAngle);
    }

    public static TimeCounterState createRandomTimeCounterState() {
        return new TimeCounterState(Randomizer.randomBetween((int)0, (int)60));
    }

    public static TimeCounterState createSpecificTimeCounterState() {
        return new TimeCounterState(22);
    }

    public static TreeState createRandomTreeState() {
        int age = Randomizer.randomBetween((int)0, (int)100);
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        int nbBranches = Randomizer.randomBetween((int)30, (int)50);
        ArrayList<TreeBranchState> branches = new ArrayList<TreeBranchState>(nbBranches);
        for (int i = 0; i < nbBranches; ++i) {
            branches.add(CoreDataCreatorForTests.createRandomTreeBranchState());
        }
        TreeTrunkState trunkState = CoreDataCreatorForTests.createRandomTreeTrunkState();
        float height = (float)Math.random();
        Tree3DState tree3dState = DisplayDataCreatorForTests.createRandomTree3DState();
        return new TreeState(age, energy, branches, trunkState, height, tree3dState);
    }

    public static TreeState createSpecificTreeState() {
        BigDecimal energy = new BigDecimal(10);
        int age = 15;
        int nbBranches = 40;
        ArrayList<TreeBranchState> branches = new ArrayList<TreeBranchState>(nbBranches);
        for (int i = 0; i < nbBranches; ++i) {
            branches.add(CoreDataCreatorForTests.createSpecificTreeBranchState());
        }
        TreeTrunkState trunkState = CoreDataCreatorForTests.createSpecificTreeTrunkState();
        float height = 4.0f;
        Tree3DState tree3dState = DisplayDataCreatorForTests.createRandomTree3DState();
        return new TreeState(age, energy, branches, trunkState, height, tree3dState);
    }

    public static TreeBranchState createRandomTreeBranchState() {
        int age = Randomizer.randomBetween((int)0, (int)100);
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        BigDecimal freeEnergy = new BigDecimal(Randomizer.randomBetween((int)0, (int)50));
        int nbParts = Randomizer.randomBetween((int)2, (int)4);
        ArrayList<TreeBranchPartState> branchPartStates = new ArrayList<TreeBranchPartState>(nbParts);
        for (int i = 0; i < nbParts; ++i) {
            branchPartStates.add(CoreDataCreatorForTests.createRandomTreeBranchPartState());
        }
        TreeBranch3DState branch3DState = DisplayDataCreatorForTests.createRandomTreeBranch3DState();
        return new TreeBranchState(age, energy, freeEnergy, branchPartStates, branch3DState);
    }

    public static TreeBranchState createSpecificTreeBranchState() {
        int age = 15;
        BigDecimal energy = new BigDecimal(10);
        BigDecimal freeEnergy = new BigDecimal(3);
        int nbParts = 3;
        ArrayList<TreeBranchPartState> branchPartStates = new ArrayList<TreeBranchPartState>(nbParts);
        for (int i = 0; i < nbParts; ++i) {
            branchPartStates.add(CoreDataCreatorForTests.createSpecificTreeBranchPartState());
        }
        TreeBranch3DState branch3DState = DisplayDataCreatorForTests.createRandomTreeBranch3DState();
        return new TreeBranchState(age, energy, freeEnergy, branchPartStates, branch3DState);
    }

    public static TreeBranchPartState createRandomTreeBranchPartState() {
        int age = Randomizer.randomBetween((int)0, (int)100);
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        BigDecimal freeEnergy = new BigDecimal(Randomizer.randomBetween((int)0, (int)50));
        int nbLeaves = Randomizer.randomBetween((int)1, (int)6);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(nbLeaves);
        for (int i = 0; i < nbLeaves; ++i) {
            leaveStates.add(CoreDataCreatorForTests.createRandomTreeLeafState());
        }
        TreeBranchPart3DState branchPart3DState = DisplayDataCreatorForTests.createRandomTreeBranchPart3DState();
        return new TreeBranchPartState(age, energy, freeEnergy, leaveStates, branchPart3DState);
    }

    public static TreeBranchPartState createSpecificTreeBranchPartState() {
        int age = 15;
        BigDecimal energy = new BigDecimal(10);
        BigDecimal freeEnergy = new BigDecimal(3);
        int nbLeaves = 5;
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(nbLeaves);
        for (int i = 0; i < nbLeaves; ++i) {
            leaveStates.add(CoreDataCreatorForTests.createSpecificTreeLeafState());
        }
        TreeBranchPart3DState branchPart3DState = DisplayDataCreatorForTests.createRandomTreeBranchPart3DState();
        return new TreeBranchPartState(age, energy, freeEnergy, leaveStates, branchPart3DState);
    }

    public static TreeTrunkState createRandomTreeTrunkState() {
        int age = Randomizer.randomBetween((int)0, (int)100);
        float radius = (float)Math.random();
        float height = (float)Math.random();
        TreeTrunk3DState trunk3DState = DisplayDataCreatorForTests.createRandomTreeTrunk3DState();
        return new TreeTrunkState(age, radius, height, trunk3DState);
    }

    public static TreeTrunkState createSpecificTreeTrunkState() {
        int age = 15;
        float radius = 0.5f;
        float height = 4.0f;
        TreeTrunk3DState trunk3DState = DisplayDataCreatorForTests.createRandomTreeTrunk3DState();
        return new TreeTrunkState(age, radius, height, trunk3DState);
    }

    public static TreeLeafState createRandomTreeLeafState() {
        BigDecimal efficiency = UtilDataCreatorForTests.createRandomBigDecimal();
        TreeLeaf3DState leafd3DState = DisplayDataCreatorForTests.createRandomTreeLeaf3DState();
        int age = Randomizer.randomBetween((int)0, (int)100);
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        BigDecimal freeEnergy = new BigDecimal(Randomizer.randomBetween((int)0, (int)50));
        return new TreeLeafState(age, energy, freeEnergy, efficiency, leafd3DState);
    }

    public static TreeLeafState createSpecificTreeLeafState() {
        BigDecimal efficiency = PercentHelper.getDecimalValue((int)80);
        int age = 15;
        BigDecimal energy = new BigDecimal(10);
        BigDecimal freeEnergy = new BigDecimal(3);
        TreeLeaf3DState leafd3DState = DisplayDataCreatorForTests.createSpecificTreeLeaf3DState();
        return new TreeLeafState(age, energy, freeEnergy, efficiency, leafd3DState);
    }
}

