/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

public class FpsCounter {
    private static final int COMPUTINGS_BEFORE_AVERAGE = 10;
    private static final int TICKS_BEFORE_COMPUTING = 10;
    private static final long NANO_TO_MILLI = 1000000L;
    private short ticksCounter = 0;
    private short computingsCounter = 0;
    private long previousTick;
    private long currentTick = this.previousTick = System.nanoTime();
    private float execTime = 1.0f;
    private int fps = 1;
    private float avgExecTime = 1.0f;
    private int avgFps = 1;
    private float[] lastExecTimes = new float[10];

    public void tick() {
        this.ticksCounter = (short)(this.ticksCounter + 1);
        if (this.ticksCounter == 10) {
            this.ticksCounter = 0;
            this.previousTick = this.currentTick;
            this.currentTick = System.nanoTime();
            this.execTime = (float)(this.currentTick - this.previousTick) / 1000000.0f;
            this.execTime /= 10.0f;
            this.lastExecTimes[this.computingsCounter] = this.execTime;
            this.fps = Math.round(1000.0f / this.execTime);
            this.computingsCounter = (short)(this.computingsCounter + 1);
            if (this.computingsCounter == 10) {
                this.computingsCounter = 0;
                this.computeAvgExecTime();
            }
        }
    }

    private void computeAvgExecTime() {
        float result = 0.0f;
        for (float historicExecTime : this.lastExecTimes) {
            result += historicExecTime;
        }
        this.avgExecTime = result / 10.0f;
        this.avgFps = Math.round(1000.0f / this.avgExecTime);
    }

    public float getExecTime() {
        return this.execTime;
    }

    public int getFps() {
        return this.fps;
    }

    public float getAvgExecTime() {
        return this.avgExecTime;
    }

    public int getAvgFps() {
        return this.avgFps;
    }
}

