/*
 * Decompiled with CFR 0.152.
 */
package inter.banking;

import inter.banking.extrato.ConsultarExtrato;
import inter.banking.extrato.ConsultarExtratoEnriquecido;
import inter.banking.extrato.RecuperarExtratoPdf;
import inter.banking.model.Extrato;
import inter.banking.model.FiltroBuscarCallbacks;
import inter.banking.model.FiltroBuscarPagamentos;
import inter.banking.model.FiltroBuscarPagamentosDarf;
import inter.banking.model.FiltroConsultarExtratoEnriquecido;
import inter.banking.model.ItemLote;
import inter.banking.model.Ordenacao;
import inter.banking.model.Pagamento;
import inter.banking.model.PagamentoBoleto;
import inter.banking.model.PagamentoDarf;
import inter.banking.model.PaginaCallbacks;
import inter.banking.model.PaginaExtratoEnriquecido;
import inter.banking.model.Pix;
import inter.banking.model.ProcessamentoLote;
import inter.banking.model.RespostaBuscarCallbacks;
import inter.banking.model.RespostaIncluirPagamento;
import inter.banking.model.RespostaIncluirPagamentoDarf;
import inter.banking.model.RespostaIncluirPagamentosLote;
import inter.banking.model.RespostaIncluirPix;
import inter.banking.model.RespostaRecuperarPix;
import inter.banking.model.RetornoPagamentoDarf;
import inter.banking.model.Saldo;
import inter.banking.model.TransacaoEnriquecida;
import inter.banking.pagamento.BuscarLotePagamentos;
import inter.banking.pagamento.BuscarPagamentos;
import inter.banking.pagamento.BuscarPagamentosDarf;
import inter.banking.pagamento.CancelaAgendamentoPagamento;
import inter.banking.pagamento.IncluirPagamento;
import inter.banking.pagamento.IncluirPagamentoDarf;
import inter.banking.pagamento.IncluirPagamentosLote;
import inter.banking.pix.IncluirPix;
import inter.banking.saldo.ConsultarSaldo;
import inter.banking.webhook.ConsultarCallbacks;
import inter.banking.webhook.CriarWebhook;
import inter.banking.webhook.ExcluirWebhook;
import inter.banking.webhook.ObterWebhook;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Webhook;
import java.util.List;

public class BankingSdk {
    private final Config config;
    private ConsultarExtrato consultarExtrato;
    private RecuperarExtratoPdf recuperarExtratoPdf;
    private ConsultarExtratoEnriquecido consultarExtratoEnriquecido;
    private ConsultarSaldo consultarSaldo;
    private IncluirPagamento incluirPagamento;
    private BuscarPagamentos buscarPagamentos;
    private CancelaAgendamentoPagamento cancelaAgendamentoPagamento;
    private IncluirPagamentoDarf incluirPagamentoDarf;
    private BuscarPagamentosDarf buscarPagamentosDarf;
    private IncluirPagamentosLote incluirPagamentosLote;
    private BuscarLotePagamentos buscarLotePagamentos;
    private IncluirPix incluirPix;
    private CriarWebhook criarWebhook;
    private ObterWebhook obterWebhook;
    private ExcluirWebhook excluirWebhook;
    private ConsultarCallbacks consultarCallbacks;

    public BankingSdk(Config config) {
        this.config = config;
    }

    public Extrato consultarExtrato(String dataInicial, String dataFinal) throws SdkException {
        if (this.consultarExtrato == null) {
            this.consultarExtrato = new ConsultarExtrato();
        }
        return this.consultarExtrato.consultar(this.config, dataInicial, dataFinal);
    }

    public void recuperarExtratoPdf(String dataInicial, String dataFinal, String arquivo) throws SdkException {
        if (this.recuperarExtratoPdf == null) {
            this.recuperarExtratoPdf = new RecuperarExtratoPdf();
        }
        this.recuperarExtratoPdf.recuperar(this.config, dataInicial, dataFinal, arquivo);
    }

    public List<TransacaoEnriquecida> consultarExtratoEnriquecido(String dataInicial, String dataFinal, FiltroConsultarExtratoEnriquecido filtro) throws SdkException {
        if (this.consultarExtratoEnriquecido == null) {
            this.consultarExtratoEnriquecido = new ConsultarExtratoEnriquecido();
        }
        return this.consultarExtratoEnriquecido.consultar(this.config, dataInicial, dataFinal, filtro);
    }

    public PaginaExtratoEnriquecido consultarExtratoEnriquecido(String dataInicial, String dataFinal, FiltroConsultarExtratoEnriquecido filtro, int pagina) throws SdkException {
        if (this.consultarExtratoEnriquecido == null) {
            this.consultarExtratoEnriquecido = new ConsultarExtratoEnriquecido();
        }
        return this.consultarExtratoEnriquecido.consultar(this.config, dataInicial, dataFinal, pagina, null, filtro);
    }

    public PaginaExtratoEnriquecido consultarExtratoEnriquecido(String dataInicial, String dataFinal, FiltroConsultarExtratoEnriquecido filtro, int pagina, int tamanhoPagina) throws SdkException {
        if (this.consultarExtratoEnriquecido == null) {
            this.consultarExtratoEnriquecido = new ConsultarExtratoEnriquecido();
        }
        return this.consultarExtratoEnriquecido.consultar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public Saldo consultarSaldo() throws SdkException {
        if (this.consultarSaldo == null) {
            this.consultarSaldo = new ConsultarSaldo();
        }
        return this.consultarSaldo(null);
    }

    public Saldo consultarSaldo(String dataSaldo) throws SdkException {
        if (this.consultarSaldo == null) {
            this.consultarSaldo = new ConsultarSaldo();
        }
        return this.consultarSaldo.consultar(this.config, dataSaldo);
    }

    public RespostaIncluirPagamento incluirPagamento(PagamentoBoleto pagamento) throws SdkException {
        if (this.incluirPagamento == null) {
            this.incluirPagamento = new IncluirPagamento();
        }
        return this.incluirPagamento.incluir(this.config, pagamento);
    }

    public List<Pagamento> buscarPagamentos(String dataInicial, String dataFinal, FiltroBuscarPagamentos filtro) throws SdkException {
        if (this.buscarPagamentos == null) {
            this.buscarPagamentos = new BuscarPagamentos();
        }
        return this.buscarPagamentos.buscar(this.config, dataInicial, dataFinal, filtro);
    }

    public RespostaIncluirPagamentoDarf incluirPagamentoDarf(PagamentoDarf pagamento) throws SdkException {
        if (this.incluirPagamentoDarf == null) {
            this.incluirPagamentoDarf = new IncluirPagamentoDarf();
        }
        return this.incluirPagamentoDarf.incluir(this.config, pagamento);
    }

    public List<RetornoPagamentoDarf> buscarPagamentosDarf(String dataInicial, String dataFinal, FiltroBuscarPagamentosDarf filtro) throws SdkException {
        if (this.buscarPagamentosDarf == null) {
            this.buscarPagamentosDarf = new BuscarPagamentosDarf();
        }
        return this.buscarPagamentosDarf.buscar(this.config, dataInicial, dataFinal, filtro);
    }

    public RespostaIncluirPagamentosLote incluirPagamentosLote(String meuIdentificador, List<ItemLote> pagamentos) throws SdkException {
        if (this.incluirPagamentosLote == null) {
            this.incluirPagamentosLote = new IncluirPagamentosLote();
        }
        return this.incluirPagamentosLote.incluir(this.config, meuIdentificador, pagamentos);
    }

    public ProcessamentoLote buscarLotePagamentos(String idLote) throws SdkException {
        if (this.buscarLotePagamentos == null) {
            this.buscarLotePagamentos = new BuscarLotePagamentos();
        }
        return this.buscarLotePagamentos.buscar(this.config, idLote);
    }

    public RespostaIncluirPix incluirPix(Pix pix) throws SdkException {
        if (this.incluirPix == null) {
            this.incluirPix = new IncluirPix();
        }
        return this.incluirPix.incluir(this.config, pix);
    }

    public RespostaRecuperarPix recuperarPix(String codigoRequisicao) throws SdkException {
        if (this.incluirPix == null) {
            this.incluirPix = new IncluirPix();
        }
        return this.incluirPix.recuperarTransacaoPix(this.config, codigoRequisicao);
    }

    public void criarWebhook(String tipoWebhook, String webhookUrl) throws SdkException {
        if (this.criarWebhook == null) {
            this.criarWebhook = new CriarWebhook();
        }
        this.criarWebhook.criar(this.config, tipoWebhook, webhookUrl);
    }

    public Webhook obterWebhook(String tipoWebhook) throws SdkException {
        if (this.obterWebhook == null) {
            this.obterWebhook = new ObterWebhook();
        }
        return this.obterWebhook.obter(this.config, tipoWebhook);
    }

    public void excluirWebhook(String tipoWebhook) throws SdkException {
        if (this.excluirWebhook == null) {
            this.excluirWebhook = new ExcluirWebhook();
        }
        this.excluirWebhook.excluir(this.config, tipoWebhook);
    }

    public List<RespostaBuscarCallbacks> consultarCallbacks(String tipoWebhook, String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, Ordenacao ordenacao) throws SdkException {
        if (this.consultarCallbacks == null) {
            this.consultarCallbacks = new ConsultarCallbacks();
        }
        return this.consultarCallbacks.recuperar(this.config, tipoWebhook, dataHoraInicio, dataHoraFim, filtro);
    }

    public PaginaCallbacks consultarCallbacks(String tipoWebhook, String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, int pagina, Ordenacao ordenacao) throws SdkException {
        if (this.consultarCallbacks == null) {
            this.consultarCallbacks = new ConsultarCallbacks();
        }
        return this.consultarCallbacks.recuperar(this.config, tipoWebhook, dataHoraInicio, dataHoraFim, pagina, null, filtro);
    }

    public void cancelaAgendamentoPagamento(String codigoTransacao) throws SdkException {
        if (this.cancelaAgendamentoPagamento == null) {
            this.cancelaAgendamentoPagamento = new CancelaAgendamentoPagamento();
        }
        this.cancelaAgendamentoPagamento.cancelar(this.config, codigoTransacao);
    }
}

