/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.extrato;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.Extrato;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarExtrato {
    private static final Logger log = LoggerFactory.getLogger(ConsultarExtrato.class);

    public Extrato consultar(Config config, String dataInicial, String dataFinal) throws SdkException {
        log.info("ConsultarExtrato {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/extrato".replace("AMBIENTE", config.getAmbiente()) + "?dataInicio=" + dataInicial + "&dataFim=" + dataFinal;
        String json = HttpUtils.callGet(config, url, "extrato.read", "Erro ao consultar extrato");
        try {
            return (Extrato)new ObjectMapper().readValue(json, Extrato.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

