/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.pagamento;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.BoletoLote;
import inter.banking.model.DarfLote;
import inter.banking.model.ItemLote;
import inter.banking.model.ProcessamentoLote;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuscarLotePagamentos {
    private static final Logger log = LoggerFactory.getLogger(BuscarLotePagamentos.class);

    public ProcessamentoLote buscar(Config config, String idLote) throws SdkException {
        log.info("BuscarLotePagamentos {} {}", (Object)config.getClientId(), (Object)idLote);
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pagamento/lote".replace("AMBIENTE", config.getAmbiente()) + "/" + idLote;
        String json = HttpUtils.callGet(config, url, "pagamento-lote.read", "Erro ao buscar lote");
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonLote = (JSONObject)parser.parse(json);
            JSONArray jsonArray = (JSONArray)jsonLote.get((Object)"pagamentos");
            ArrayList<ItemLote> pagamentos = new ArrayList<ItemLote>();
            ObjectMapper objectMapper = new ObjectMapper();
            if (jsonArray != null) {
                for (JSONObject item : jsonArray) {
                    String tipoPagamento = (String)item.get((Object)"tipoPagamento");
                    if (tipoPagamento.equals("BOLETO")) {
                        BoletoLote boletoLote = (BoletoLote)objectMapper.readValue(item.toJSONString(), BoletoLote.class);
                        pagamentos.add(boletoLote);
                        continue;
                    }
                    DarfLote darfLote = (DarfLote)objectMapper.readValue(item.toJSONString(), DarfLote.class);
                    pagamentos.add(darfLote);
                }
                jsonLote.put((Object)"pagamentos", null);
            }
            ProcessamentoLote processamentoLote = (ProcessamentoLote)objectMapper.readValue(jsonLote.toJSONString(), ProcessamentoLote.class);
            processamentoLote.setPagamentos(pagamentos);
            return processamentoLote;
        }
        catch (IOException | ParseException e) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", e);
            throw new SdkException(e.getMessage(), Erro.builder().title("Erro no Certificado!").detail(e.getMessage()).build());
        }
    }
}

