/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.pagamento;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.ItemLote;
import inter.banking.model.Lote;
import inter.banking.model.RespostaIncluirPagamentosLote;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncluirPagamentosLote {
    private static final Logger log = LoggerFactory.getLogger(IncluirPagamentosLote.class);

    public RespostaIncluirPagamentosLote incluir(Config config, String meuIdentificador, List<ItemLote> pagamentos) throws SdkException {
        log.info("IncluirPagamentosLote {} {} {}", new Object[]{config.getClientId(), meuIdentificador, pagamentos.size()});
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pagamento/lote".replace("AMBIENTE", config.getAmbiente());
        Lote request = Lote.builder().meuIdentificador(meuIdentificador).pagamentos(pagamentos).build();
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
            json = HttpUtils.callPost(config, url, "pagamento-lote.write", "Erro ao incluir pagamentos em lote", json);
            return (RespostaIncluirPagamentosLote)new ObjectMapper().readValue(json, RespostaIncluirPagamentosLote.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

