/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca.boletos;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobranca.model.Boleto;
import inter.cobranca.model.RespostaEmitirBoleto;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmitirBoleto {
    private static final Logger log = LoggerFactory.getLogger(EmitirBoleto.class);

    public RespostaEmitirBoleto emitir(Config config, Boleto boleto) throws SdkException {
        log.info("EmitirBoleto {} {}", (Object)config.getClientId(), (Object)boleto.getSeuNumero());
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v2/boletos".replace("AMBIENTE", config.getAmbiente());
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)boleto);
            json = HttpUtils.callPost(config, url, "boleto-cobranca.write", "Erro ao emitir boleto", json);
            return (RespostaEmitirBoleto)new ObjectMapper().readValue(json, RespostaEmitirBoleto.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

