/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca.boletos;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.model.RetornoPdf;
import inter.utils.HttpUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperarBoletoPdf {
    private static final Logger log = LoggerFactory.getLogger(RecuperarBoletoPdf.class);

    public void recuperar(Config config, String nossoNumero, String arquivo) throws SdkException {
        log.info("RecuperarBoletoPdf {} nossoNumero={}", (Object)config.getClientId(), (Object)nossoNumero);
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v2/boletos".replace("AMBIENTE", config.getAmbiente()) + "/" + nossoNumero + "/pdf";
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar boleto pdf");
        try {
            RetornoPdf retornoPdf = (RetornoPdf)new ObjectMapper().readValue(json, RetornoPdf.class);
            byte[] decodedBytes = Base64.getDecoder().decode(retornoPdf.getPdf());
            try (FileOutputStream stream = new FileOutputStream(arquivo);){
                stream.write(decodedBytes);
            }
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

