/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3;

import inter.cobrancav3.cobranca.CancelaCobranca;
import inter.cobrancav3.cobranca.EmiteCobranca;
import inter.cobrancav3.cobranca.RecuperaCobranca;
import inter.cobrancav3.cobranca.RecuperaCobrancaPdf;
import inter.cobrancav3.cobranca.RecuperaColecaoCobrancas;
import inter.cobrancav3.cobranca.RecuperaSumarioCobrancas;
import inter.cobrancav3.model.CobrancaRecuperada;
import inter.cobrancav3.model.FiltroBuscarCallbacks;
import inter.cobrancav3.model.FiltroRecuperarCobrancas;
import inter.cobrancav3.model.FiltroRecuperarSumarioCobrancas;
import inter.cobrancav3.model.Ordenacao;
import inter.cobrancav3.model.PaginaCallbacks;
import inter.cobrancav3.model.PaginaCobrancas;
import inter.cobrancav3.model.RequisicaoEmitirCobranca;
import inter.cobrancav3.model.RespostaBuscarCallbacks;
import inter.cobrancav3.model.RespostaEmitirCobranca;
import inter.cobrancav3.model.Sumario;
import inter.cobrancav3.webhook.ConsultaCallbacks;
import inter.cobrancav3.webhook.CriaWebhook;
import inter.cobrancav3.webhook.ExcluiWebhook;
import inter.cobrancav3.webhook.ObtemWebhook;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Webhook;
import java.util.List;

public class CobrancaV3Sdk {
    private final Config config;
    private CancelaCobranca cancelaCobranca;
    private EmiteCobranca emiteCobranca;
    private RecuperaCobranca recuperaCobranca;
    private RecuperaColecaoCobrancas recuperaColecaoCobrancas;
    private RecuperaCobrancaPdf recuperaCobrancaPdf;
    private RecuperaSumarioCobrancas recuperaSumarioCobrancas;
    private CriaWebhook criarWebhook;
    private ObtemWebhook obterWebhook;
    private ExcluiWebhook excluirWebhook;
    private ConsultaCallbacks consultaCallbacks;

    public CobrancaV3Sdk(Config config) {
        this.config = config;
    }

    public void cancelarCobranca(String codigoSolicitacao, String motivoCancelamento) throws SdkException {
        if (this.cancelaCobranca == null) {
            this.cancelaCobranca = new CancelaCobranca();
        }
        this.cancelaCobranca.cancelar(this.config, codigoSolicitacao, motivoCancelamento);
    }

    public RespostaEmitirCobranca emitirCobranca(RequisicaoEmitirCobranca cobranca) throws SdkException {
        if (this.emiteCobranca == null) {
            this.emiteCobranca = new EmiteCobranca();
        }
        return this.emiteCobranca.emitir(this.config, cobranca);
    }

    public CobrancaRecuperada recuperarCobranca(String codigoSolicitacao) throws SdkException {
        if (this.recuperaCobranca == null) {
            this.recuperaCobranca = new RecuperaCobranca();
        }
        return this.recuperaCobranca.recuperar(this.config, codigoSolicitacao);
    }

    public List<CobrancaRecuperada> recuperarCobrancas(String dataInicial, String dataFinal, FiltroRecuperarCobrancas filtro, Ordenacao ordenacao) throws SdkException {
        if (this.recuperaColecaoCobrancas == null) {
            this.recuperaColecaoCobrancas = new RecuperaColecaoCobrancas();
        }
        return this.recuperaColecaoCobrancas.recuperar(this.config, dataInicial, dataFinal, filtro, ordenacao);
    }

    public PaginaCobrancas recuperarCobrancas(String dataInicial, String dataFinal, FiltroRecuperarCobrancas filtro, int pagina, Ordenacao ordenacao) throws SdkException {
        if (this.recuperaColecaoCobrancas == null) {
            this.recuperaColecaoCobrancas = new RecuperaColecaoCobrancas();
        }
        return this.recuperaColecaoCobrancas.recuperar(this.config, dataInicial, dataFinal, pagina, null, filtro, ordenacao);
    }

    public PaginaCobrancas recuperarCobrancas(String dataInicial, String dataFinal, FiltroRecuperarCobrancas filtro, Ordenacao ordenacao, int pagina, int tamanhoPagina) throws SdkException {
        if (this.recuperaColecaoCobrancas == null) {
            this.recuperaColecaoCobrancas = new RecuperaColecaoCobrancas();
        }
        return this.recuperaColecaoCobrancas.recuperar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro, ordenacao);
    }

    public void recuperarCobrancaPdf(String codigoSolicitacao, String arquivo) throws SdkException {
        if (this.recuperaCobrancaPdf == null) {
            this.recuperaCobrancaPdf = new RecuperaCobrancaPdf();
        }
        this.recuperaCobrancaPdf.recuperar(this.config, codigoSolicitacao, arquivo);
    }

    public Sumario recuperarSumarioCobrancas(String dataInicial, String dataFinal, FiltroRecuperarSumarioCobrancas filtro) throws SdkException {
        if (this.recuperaSumarioCobrancas == null) {
            this.recuperaSumarioCobrancas = new RecuperaSumarioCobrancas();
        }
        return this.recuperaSumarioCobrancas.recuperar(this.config, dataInicial, dataFinal, filtro);
    }

    public void criarWebhook(String webhookUrl) throws SdkException {
        if (this.criarWebhook == null) {
            this.criarWebhook = new CriaWebhook();
        }
        this.criarWebhook.criar(this.config, webhookUrl);
    }

    public Webhook obterWebhook() throws SdkException {
        if (this.obterWebhook == null) {
            this.obterWebhook = new ObtemWebhook();
        }
        return this.obterWebhook.obter(this.config);
    }

    public void excluirWebhook() throws SdkException {
        if (this.excluirWebhook == null) {
            this.excluirWebhook = new ExcluiWebhook();
        }
        this.excluirWebhook.excluir(this.config);
    }

    public PaginaCallbacks consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, int pagina, int tamanhoPagina) throws SdkException {
        if (this.consultaCallbacks == null) {
            this.consultaCallbacks = new ConsultaCallbacks();
        }
        return this.consultaCallbacks.recuperar(this.config, dataHoraInicio, dataHoraFim, pagina, tamanhoPagina, filtro);
    }

    public List<RespostaBuscarCallbacks> consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, Ordenacao ordenacao) throws SdkException {
        if (this.consultaCallbacks == null) {
            this.consultaCallbacks = new ConsultaCallbacks();
        }
        return this.consultaCallbacks.recuperar(this.config, dataHoraInicio, dataHoraFim, filtro);
    }

    public PaginaCallbacks consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, int pagina, Ordenacao ordenacao) throws SdkException {
        if (this.consultaCallbacks == null) {
            this.consultaCallbacks = new ConsultaCallbacks();
        }
        return this.consultaCallbacks.recuperar(this.config, dataHoraInicio, dataHoraFim, pagina, null, filtro);
    }
}

