/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.cobranca;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobrancav3.model.CobrancaRecuperada;
import inter.cobrancav3.model.FiltroRecuperarCobrancas;
import inter.cobrancav3.model.Ordenacao;
import inter.cobrancav3.model.PaginaCobrancas;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperaColecaoCobrancas {
    private static final Logger log = LoggerFactory.getLogger(RecuperaColecaoCobrancas.class);

    public PaginaCobrancas recuperar(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroRecuperarCobrancas filtro, Ordenacao ordenacao) throws SdkException {
        log.info("RecuperarColecaoCobrancas {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        return this.getPage(config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro, ordenacao);
    }

    public List<CobrancaRecuperada> recuperar(Config config, String dataInicial, String dataFinal, FiltroRecuperarCobrancas filtro, Ordenacao ordenacao) throws SdkException {
        PaginaCobrancas paginaCobrancas;
        log.info("RecuperarColecaoCobrancas {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<CobrancaRecuperada> cobrancas = new ArrayList<CobrancaRecuperada>();
        do {
            paginaCobrancas = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro, ordenacao);
            cobrancas.addAll(paginaCobrancas.getCobrancas());
        } while (++pagina < paginaCobrancas.getTotalPaginas());
        return cobrancas;
    }

    private PaginaCobrancas getPage(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroRecuperarCobrancas filtro, Ordenacao ordenacao) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas".replace("AMBIENTE", config.getAmbiente()) + "?dataInicial=" + dataInicial + "&dataFinal=" + dataFinal + "&paginacao.paginaAtual=" + pagina + (String)(tamanhoPagina != null ? "&paginacao.itensPorPagina=" + tamanhoPagina : "") + this.addfilters(filtro) + this.addSort(ordenacao);
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar cobran\u00e7as");
        try {
            return (PaginaCobrancas)new ObjectMapper().readValue(json, PaginaCobrancas.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroRecuperarCobrancas filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getFiltrarDataPor() != null) {
            filter.append("&filtrarDataPor").append("=").append(filtro.getFiltrarDataPor().toString());
        }
        if (filtro.getSituacao() != null) {
            filter.append("&situacao").append("=").append(filtro.getSituacao().toString());
        }
        if (filtro.getPessoaPagadora() != null) {
            filter.append("&pessoaPagadora").append("=").append(filtro.getPessoaPagadora());
        }
        if (filtro.getCpfCnpjPessoaPagadora() != null) {
            filter.append("&cpfCnpjPessoaPagadora").append("=").append(filtro.getCpfCnpjPessoaPagadora());
        }
        if (filtro.getSeuNumero() != null) {
            filter.append("&seuNumero").append("=").append(filtro.getSeuNumero());
        }
        if (filtro.getTipoCobranca() != null) {
            filter.append("&tipoCobranca").append("=").append((Object)filtro.getTipoCobranca());
        }
        return filter.toString();
    }

    private String addSort(Ordenacao ordenacao) {
        if (ordenacao == null) {
            return "";
        }
        StringBuilder order = new StringBuilder();
        if (ordenacao.getOrdenarPor() != null) {
            order.append("&ordenarPor").append("=").append(ordenacao.getOrdenarPor().toString());
        }
        if (ordenacao.getTipoOrdenacao() != null) {
            order.append("&tipoOrdenacao").append("=").append(ordenacao.getTipoOrdenacao().toString());
        }
        return order.toString();
    }
}

