/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobrancav3.model.FiltroBuscarCallbacks;
import inter.cobrancav3.model.PaginaCallbacks;
import inter.cobrancav3.model.RespostaBuscarCallbacks;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultaCallbacks {
    private static final Logger log = LoggerFactory.getLogger(ConsultaCallbacks.class);

    public PaginaCallbacks recuperar(Config config, String dataHoraInicio, String dataHoraFim, int pagina, Integer tamanhoPagina, FiltroBuscarCallbacks filtro) throws SdkException {
        log.info("ConsultaCallbacks {} {}-{}", new Object[]{config.getClientId(), dataHoraInicio, dataHoraFim});
        return this.getPage(config, dataHoraInicio, dataHoraFim, pagina, tamanhoPagina, filtro);
    }

    public List<RespostaBuscarCallbacks> recuperar(Config config, String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro) throws SdkException {
        PaginaCallbacks paginaCallbacks;
        log.info("ConsultaCallbacks {} {}-{}", new Object[]{config.getClientId(), dataHoraInicio, dataHoraFim});
        int pagina = 0;
        ArrayList<RespostaBuscarCallbacks> callbacks = new ArrayList<RespostaBuscarCallbacks>();
        do {
            paginaCallbacks = this.getPage(config, dataHoraInicio, dataHoraFim, pagina, null, filtro);
            callbacks.addAll(paginaCallbacks.getCallbacks());
        } while (++pagina < paginaCallbacks.getTotalPaginas());
        return callbacks;
    }

    private PaginaCallbacks getPage(Config config, String dataHoraInicio, String dataHoraFim, int pagina, Integer tamanhoPagina, FiltroBuscarCallbacks filtro) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas/webhook/callbacks".replace("AMBIENTE", config.getAmbiente()) + "?dataHoraInicio=" + dataHoraInicio + "&dataHoraFim=" + dataHoraFim + "&pagina=" + pagina + (String)(tamanhoPagina != null ? "&itensPorPagina=" + tamanhoPagina : "") + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar callbacks");
        try {
            return (PaginaCallbacks)new ObjectMapper().readValue(json, PaginaCallbacks.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroBuscarCallbacks filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getCodigoSolicitacao() != null) {
            filter.append("&codigoSolicitacao").append("=").append(filtro.getCodigoSolicitacao());
        }
        return filter.toString();
    }
}

