/*
 * Decompiled with CFR 0.152.
 */
package inter.model;

public class Config {
    private String ambiente;
    private final String clientId;
    private final String clientSecret;
    private final String certificado;
    private final String senha;
    private boolean debug;
    private String contaCorrente;
    private boolean controleRateLimit;

    Config(String ambiente, String clientId, String clientSecret, String certificado, String senha, boolean debug, String contaCorrente, boolean controleRateLimit) {
        this.ambiente = ambiente;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.certificado = certificado;
        this.senha = senha;
        this.debug = debug;
        this.contaCorrente = contaCorrente;
        this.controleRateLimit = controleRateLimit;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getCertificado() {
        return this.certificado;
    }

    public String getSenha() {
        return this.senha;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public boolean isControleRateLimit() {
        return this.controleRateLimit;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setContaCorrente(String contaCorrente) {
        this.contaCorrente = contaCorrente;
    }

    public void setControleRateLimit(boolean controleRateLimit) {
        this.controleRateLimit = controleRateLimit;
    }

    public static class ConfigBuilder {
        private String ambiente;
        private String clientId;
        private String clientSecret;
        private String certificado;
        private String senha;
        private boolean debug;
        private String contaCorrente;
        private boolean controleRateLimit;

        ConfigBuilder() {
        }

        public ConfigBuilder ambiente(String ambiente) {
            this.ambiente = ambiente;
            return this;
        }

        public ConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public ConfigBuilder certificado(String certificado) {
            this.certificado = certificado;
            return this;
        }

        public ConfigBuilder senha(String senha) {
            this.senha = senha;
            return this;
        }

        public ConfigBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public ConfigBuilder contaCorrente(String contaCorrente) {
            this.contaCorrente = contaCorrente;
            return this;
        }

        public ConfigBuilder controleRateLimit(boolean controleRateLimit) {
            this.controleRateLimit = controleRateLimit;
            return this;
        }

        public Config build() {
            return new Config(this.ambiente, this.clientId, this.clientSecret, this.certificado, this.senha, this.debug, this.contaCorrente, this.controleRateLimit);
        }

        public String toString() {
            return "Config.ConfigBuilder(ambiente=" + this.ambiente + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", certificado=" + this.certificado + ", senha=" + this.senha + ", debug=" + this.debug + ", contaCorrente=" + this.contaCorrente + ", controleRateLimit=" + this.controleRateLimit + ")";
        }
    }
}

