/*
 * Decompiled with CFR 0.152.
 */
package inter.pix;

import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Webhook;
import inter.pix.cob.ConsultarCobrancaImediata;
import inter.pix.cob.ConsultarCobrancasImediatas;
import inter.pix.cob.CriarCobrancaImediata;
import inter.pix.cob.RevisarCobrancaImediata;
import inter.pix.cobv.ConsultarCobrancaComVencimento;
import inter.pix.cobv.ConsultarCobrancasComVencimento;
import inter.pix.cobv.CriarCobrancaComVencimento;
import inter.pix.cobv.RevisarCobrancaComVencimento;
import inter.pix.location.ConsultarLocationsCadastradas;
import inter.pix.location.CriarLocation;
import inter.pix.location.DesvincularLocation;
import inter.pix.location.RecuperarLocation;
import inter.pix.model.Cobranca;
import inter.pix.model.CobrancaDetalhada;
import inter.pix.model.CobrancaVencimento;
import inter.pix.model.CobrancaVencimentoDetalhada;
import inter.pix.model.DevolucaoDetalhada;
import inter.pix.model.FiltroBuscarCallbacks;
import inter.pix.model.FiltroConsultarCobrancasComVencimento;
import inter.pix.model.FiltroConsultarCobrancasImediatas;
import inter.pix.model.FiltroConsultarLocations;
import inter.pix.model.FiltroConsultarPixRecebidos;
import inter.pix.model.Location;
import inter.pix.model.Ordenacao;
import inter.pix.model.PaginaCallbacks;
import inter.pix.model.PaginaCobrancas;
import inter.pix.model.PaginaCobrancasVencimento;
import inter.pix.model.PaginaLocations;
import inter.pix.model.PaginaPix;
import inter.pix.model.Pix;
import inter.pix.model.RequisicaoBodyDevolucao;
import inter.pix.model.RespostaBuscarCallbacks;
import inter.pix.model.enums.TipoCob;
import inter.pix.pix.ConsultarDevolucao;
import inter.pix.pix.ConsultarPix;
import inter.pix.pix.ConsultarPixRecebidos;
import inter.pix.pix.SolicitarDevolucao;
import inter.pix.webhook.ConsultarCallbacks;
import inter.pix.webhook.CriarWebhook;
import inter.pix.webhook.ExcluirWebhook;
import inter.pix.webhook.ObterWebhook;
import java.util.List;

public class PixSdk {
    private final Config config;
    private CriarCobrancaImediata criarCobrancaImediata;
    private RevisarCobrancaImediata revisarCobrancaImediata;
    private ConsultarCobrancaImediata consultarCobrancaImediata;
    private ConsultarCobrancasImediatas consultarCobrancasImediatas;
    private CriarCobrancaComVencimento criarCobrancaComVencimento;
    private RevisarCobrancaComVencimento revisarCobrancaComVencimento;
    private ConsultarCobrancaComVencimento consultarCobrancaComVencimento;
    private ConsultarCobrancasComVencimento consultarCobrancasComVencimento;
    private CriarLocation criarLocation;
    private ConsultarLocationsCadastradas consultarLocationsCadastradas;
    private RecuperarLocation recuperarLocation;
    private DesvincularLocation desvincularLocation;
    private ConsultarPix consultarPix;
    private ConsultarPixRecebidos consultarPixRecebidos;
    private SolicitarDevolucao solicitarDevolucao;
    private ConsultarDevolucao consultarDevolucao;
    private CriarWebhook criarWebhook;
    private ObterWebhook obterWebhook;
    private ExcluirWebhook excluirWebhook;
    private ConsultarCallbacks consultarCallbacks;

    public PixSdk(Config config) {
        this.config = config;
    }

    public CobrancaDetalhada criarCobrancaImediataTxId(Cobranca cobranca) throws SdkException {
        if (this.criarCobrancaImediata == null) {
            this.criarCobrancaImediata = new CriarCobrancaImediata();
        }
        return this.criarCobrancaImediata.criar(this.config, cobranca);
    }

    public CobrancaDetalhada revisarCobrancaImediata(Cobranca cobranca) throws SdkException {
        if (this.revisarCobrancaImediata == null) {
            this.revisarCobrancaImediata = new RevisarCobrancaImediata();
        }
        return this.revisarCobrancaImediata.revisar(this.config, cobranca);
    }

    public CobrancaDetalhada consultarCobrancaImediata(String txId) throws SdkException {
        if (this.consultarCobrancaImediata == null) {
            this.consultarCobrancaImediata = new ConsultarCobrancaImediata();
        }
        return this.consultarCobrancaImediata.consultar(this.config, txId);
    }

    public CobrancaDetalhada criarCobrancaImediata(Cobranca cobranca) throws SdkException {
        if (this.criarCobrancaImediata == null) {
            this.criarCobrancaImediata = new CriarCobrancaImediata();
        }
        return this.criarCobrancaImediata.criar(this.config, cobranca);
    }

    public List<CobrancaDetalhada> consultarCobrancasImediatas(String dataInicial, String dataFinal, FiltroConsultarCobrancasImediatas filtro) throws SdkException {
        if (this.consultarCobrancasImediatas == null) {
            this.consultarCobrancasImediatas = new ConsultarCobrancasImediatas();
        }
        return this.consultarCobrancasImediatas.consultar(this.config, dataInicial, dataFinal, filtro);
    }

    public PaginaCobrancas consultarCobrancasImediatas(String dataInicial, String dataFinal, FiltroConsultarCobrancasImediatas filtro, int pagina) throws SdkException {
        if (this.consultarCobrancasImediatas == null) {
            this.consultarCobrancasImediatas = new ConsultarCobrancasImediatas();
        }
        return this.consultarCobrancasImediatas.consultar(this.config, dataInicial, dataFinal, pagina, null, filtro);
    }

    public PaginaCobrancas consultarCobrancasImediatas(String dataInicial, String dataFinal, FiltroConsultarCobrancasImediatas filtro, int pagina, int tamanhoPagina) throws SdkException {
        if (this.consultarCobrancasImediatas == null) {
            this.consultarCobrancasImediatas = new ConsultarCobrancasImediatas();
        }
        return this.consultarCobrancasImediatas.consultar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public CobrancaVencimentoDetalhada criarCobrancaComVencimentoTxId(String txid, CobrancaVencimento cobranca) throws SdkException {
        if (this.criarCobrancaComVencimento == null) {
            this.criarCobrancaComVencimento = new CriarCobrancaComVencimento();
        }
        return this.criarCobrancaComVencimento.criar(this.config, txid, cobranca);
    }

    public CobrancaVencimentoDetalhada revisarCobrancaComVencimento(String txid, CobrancaVencimento cobranca) throws SdkException {
        if (this.revisarCobrancaComVencimento == null) {
            this.revisarCobrancaComVencimento = new RevisarCobrancaComVencimento();
        }
        return this.revisarCobrancaComVencimento.revisar(this.config, txid, cobranca);
    }

    public CobrancaVencimentoDetalhada consultarCobrancaComVencimento(String txId) throws SdkException {
        if (this.consultarCobrancaComVencimento == null) {
            this.consultarCobrancaComVencimento = new ConsultarCobrancaComVencimento();
        }
        return this.consultarCobrancaComVencimento.consultar(this.config, txId);
    }

    public List<CobrancaVencimentoDetalhada> consultarCobrancasComVencimento(String dataInicial, String dataFinal, FiltroConsultarCobrancasComVencimento filtro) throws SdkException {
        if (this.consultarCobrancasComVencimento == null) {
            this.consultarCobrancasComVencimento = new ConsultarCobrancasComVencimento();
        }
        return this.consultarCobrancasComVencimento.consultar(this.config, dataInicial, dataFinal, filtro);
    }

    public PaginaCobrancasVencimento consultarCobrancasComVencimento(String dataInicial, String dataFinal, FiltroConsultarCobrancasComVencimento filtro, int pagina) throws SdkException {
        if (this.consultarCobrancasComVencimento == null) {
            this.consultarCobrancasComVencimento = new ConsultarCobrancasComVencimento();
        }
        return this.consultarCobrancasComVencimento.consultar(this.config, dataInicial, dataFinal, pagina, null, filtro);
    }

    public PaginaCobrancasVencimento consultarCobrancasComVencimento(String dataInicial, String dataFinal, FiltroConsultarCobrancasComVencimento filtro, int pagina, int tamanhoPagina) throws SdkException {
        if (this.consultarCobrancasComVencimento == null) {
            this.consultarCobrancasComVencimento = new ConsultarCobrancasComVencimento();
        }
        return this.consultarCobrancasComVencimento.consultar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public Location criarLocation(TipoCob tipoCob) throws SdkException {
        if (this.criarLocation == null) {
            this.criarLocation = new CriarLocation();
        }
        return this.criarLocation.criar(this.config, tipoCob);
    }

    public List<Location> consultarLocationsCadastradas(String dataInicial, String dataFinal, FiltroConsultarLocations filtro) throws SdkException {
        if (this.consultarLocationsCadastradas == null) {
            this.consultarLocationsCadastradas = new ConsultarLocationsCadastradas();
        }
        return this.consultarLocationsCadastradas.consultar(this.config, dataInicial, dataFinal, filtro);
    }

    public PaginaLocations consultarLocationsCadastradas(String dataInicial, String dataFinal, FiltroConsultarLocations filtro, int pagina) throws SdkException {
        if (this.consultarLocationsCadastradas == null) {
            this.consultarLocationsCadastradas = new ConsultarLocationsCadastradas();
        }
        return this.consultarLocationsCadastradas.consultar(this.config, dataInicial, dataFinal, pagina, null, filtro);
    }

    public PaginaLocations consultarLocationsCadastradas(String dataInicial, String dataFinal, FiltroConsultarLocations filtro, int pagina, int tamanhoPagina) throws SdkException {
        if (this.consultarLocationsCadastradas == null) {
            this.consultarLocationsCadastradas = new ConsultarLocationsCadastradas();
        }
        return this.consultarLocationsCadastradas.consultar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public Location recuperarLocation(String id) throws SdkException {
        if (this.recuperarLocation == null) {
            this.recuperarLocation = new RecuperarLocation();
        }
        return this.recuperarLocation.recuperar(this.config, id);
    }

    public Location desvincularLocation(String id) throws SdkException {
        if (this.desvincularLocation == null) {
            this.desvincularLocation = new DesvincularLocation();
        }
        return this.desvincularLocation.desvincular(this.config, id);
    }

    public Pix consultarPix(String e2eId) throws SdkException {
        if (this.consultarPix == null) {
            this.consultarPix = new ConsultarPix();
        }
        return this.consultarPix.consultar(this.config, e2eId);
    }

    public List<Pix> consultarPixRecebidos(String dataInicial, String dataFinal, FiltroConsultarPixRecebidos filtro) throws SdkException {
        if (this.consultarPixRecebidos == null) {
            this.consultarPixRecebidos = new ConsultarPixRecebidos();
        }
        return this.consultarPixRecebidos.consultar(this.config, dataInicial, dataFinal, filtro);
    }

    public PaginaPix consultarPixRecebidos(String dataInicial, String dataFinal, FiltroConsultarPixRecebidos filtro, int pagina) throws SdkException {
        if (this.consultarPixRecebidos == null) {
            this.consultarPixRecebidos = new ConsultarPixRecebidos();
        }
        return this.consultarPixRecebidos.consultar(this.config, dataInicial, dataFinal, pagina, null, filtro);
    }

    public PaginaPix consultarPixRecebidos(String dataInicial, String dataFinal, FiltroConsultarPixRecebidos filtro, int pagina, int tamanhoPagina) throws SdkException {
        if (this.consultarPixRecebidos == null) {
            this.consultarPixRecebidos = new ConsultarPixRecebidos();
        }
        return this.consultarPixRecebidos.consultar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public DevolucaoDetalhada solicitarDevolucao(String e2eId, String id, RequisicaoBodyDevolucao requisicaoBodyDevolucao) throws SdkException {
        if (this.solicitarDevolucao == null) {
            this.solicitarDevolucao = new SolicitarDevolucao();
        }
        return this.solicitarDevolucao.solicitar(this.config, e2eId, id, requisicaoBodyDevolucao);
    }

    public DevolucaoDetalhada consultarDevolucao(String e2eId, String id) throws SdkException {
        if (this.consultarDevolucao == null) {
            this.consultarDevolucao = new ConsultarDevolucao();
        }
        return this.consultarDevolucao.consultar(this.config, e2eId, id);
    }

    public void criarWebhook(String webhookUrl, String chave) throws SdkException {
        if (this.criarWebhook == null) {
            this.criarWebhook = new CriarWebhook();
        }
        this.criarWebhook.criar(this.config, webhookUrl, chave);
    }

    public Webhook obterWebhook(String chave) throws SdkException {
        if (this.obterWebhook == null) {
            this.obterWebhook = new ObterWebhook();
        }
        return this.obterWebhook.obter(this.config, chave);
    }

    public void excluirWebhook(String chave) throws SdkException {
        if (this.excluirWebhook == null) {
            this.excluirWebhook = new ExcluirWebhook();
        }
        this.excluirWebhook.excluir(this.config, chave);
    }

    public List<RespostaBuscarCallbacks> consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, Ordenacao ordenacao) throws SdkException {
        if (this.consultarCallbacks == null) {
            this.consultarCallbacks = new ConsultarCallbacks();
        }
        return this.consultarCallbacks.buscar(this.config, dataHoraInicio, dataHoraFim, filtro);
    }

    public PaginaCallbacks consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, int pagina, Ordenacao ordenacao) throws SdkException {
        if (this.consultarCallbacks == null) {
            this.consultarCallbacks = new ConsultarCallbacks();
        }
        return this.consultarCallbacks.buscar(this.config, dataHoraInicio, dataHoraFim, pagina, null, filtro);
    }
}

