/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.cob;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.CobrancaDetalhada;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarCobrancaImediata {
    private static final Logger log = LoggerFactory.getLogger(ConsultarCobrancaImediata.class);

    public CobrancaDetalhada consultar(Config config, String txId) throws SdkException {
        log.info("ConsultarCobrancaImediata {} txId={}", (Object)config.getClientId(), (Object)txId);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/cob".replace("AMBIENTE", config.getAmbiente()) + "/" + txId;
        String json = HttpUtils.callGet(config, url, "cob.read", "Erro ao consultar cobran\u00e7a imediata");
        try {
            return (CobrancaDetalhada)new ObjectMapper().readValue(json, CobrancaDetalhada.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

