/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.pix;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.Pix;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarPix {
    private static final Logger log = LoggerFactory.getLogger(ConsultarPix.class);

    public Pix consultar(Config config, String e2eId) throws SdkException {
        log.info("ConsultarPix {} e2eId={}", (Object)config.getClientId(), (Object)e2eId);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/pix".replace("AMBIENTE", config.getAmbiente()) + "/" + e2eId;
        String json = HttpUtils.callGet(config, url, "pix.read", "Erro ao consultar pix");
        try {
            return (Pix)new ObjectMapper().readValue(json, Pix.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

