/*
 * Decompiled with CFR 0.152.
 */
package inter.utils;

import inter.exceptions.CertificadoException;
import inter.exceptions.CertificadoExpiradoException;
import inter.exceptions.CertificadoNaoEncontradoException;
import inter.exceptions.SdkException;
import inter.model.Erro;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger log = LoggerFactory.getLogger(SslUtils.class);

    private SslUtils() {
    }

    public static BasicHttpClientConnectionManager buildConnectionManager(String certificate, String password) throws SdkException {
        if (!new File(certificate).exists()) {
            throw new CertificadoNaoEncontradoException(certificate);
        }
        SSLContext sslContext = SslUtils.buildSslContext(certificate, password);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        return new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
    }

    private static SSLContext buildSslContext(String certificate, String password) throws SdkException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            KeyStore keyStore = SslUtils.getKeyStore(certificate, password);
            SslUtils.checkExpiration(keyStore);
            KeyManagerFactory keyManagerFactory = SslUtils.buildKeyManagerFactory(keyStore, password);
            sslContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error("Erro no Certificado!", (Throwable)e);
            throw new CertificadoException(e.getMessage(), Erro.builder().title("Erro no Certificado!").detail(e.getMessage()).build());
        }
    }

    public static KeyStore getKeyStore(String certificate, String password) throws SdkException {
        KeyStore keyStore;
        FileInputStream fileInputStream = new FileInputStream(certificate);
        try {
            keyStore = SslUtils.loadCertificate(fileInputStream, password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
                throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                log.error("Erro no Certificado!", (Throwable)e);
                throw new CertificadoException(e.getMessage(), Erro.builder().title("Erro no Certificado!").detail(e.getMessage()).build());
            }
        }
        fileInputStream.close();
        return keyStore;
    }

    private static KeyStore loadCertificate(FileInputStream fileInputStream, String password) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        keyStore.load(fileInputStream, password.toCharArray());
        return keyStore;
    }

    public static Date isCloseToExpire(String certificate, String password) throws SdkException {
        KeyStore keyStore = SslUtils.getKeyStore(certificate, password);
        return SslUtils.checkExpiration(keyStore);
    }

    private static Date checkExpiration(KeyStore keyStore) throws SdkException {
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            Date notAfter = null;
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                log.info("Certificadoemissor={} expiracao={}", (Object)certificate.getIssuerX500Principal().getName(), (Object)certificate.getNotAfter());
                if (certificate.getNotAfter().before(Date.from(LocalDateTime.now().plusDays(30L).atZone(ZoneId.systemDefault()).toInstant()))) {
                    notAfter = certificate.getNotAfter();
                }
                if (!certificate.getNotAfter().before(new Date())) continue;
                throw new CertificadoExpiradoException(certificate.getNotAfter());
            }
            return notAfter;
        }
        catch (KeyStoreException e) {
            log.error("Erro no Certificado!", (Throwable)e);
            throw new CertificadoException(e.getMessage(), Erro.builder().title("Erro no Certificado!").detail(e.getMessage()).build());
        }
    }

    private static KeyManagerFactory buildKeyManagerFactory(KeyStore keyStrore, String password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStrore, password.toCharArray());
        return keyManagerFactory;
    }
}

