/*
 * Decompiled with CFR 0.152.
 */
package inter;

import inter.banking.BankingSdk;
import inter.cobranca.CobrancaSdk;
import inter.cobranca.model.Pessoa;
import inter.cobrancav3.CobrancaV3Sdk;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.pix.PixSdk;
import inter.utils.SslUtils;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterSdk {
    private static final Logger log = LoggerFactory.getLogger(InterSdk.class);
    private final Config config;
    private BankingSdk bankingSdk;
    private PixSdk pixSdk;
    private CobrancaSdk cobrancaSdk;
    private CobrancaV3Sdk cobrancaV3Sdk;
    private final List<String> avisos;
    public static final String VERSION = "inter-sdk-java v1.0.2";

    public InterSdk(String ambiente, String clientId, String clientSecret, String certificado, String senhaCertificado) throws SdkException {
        this(clientId, clientSecret, certificado, senhaCertificado);
        this.setAmbiente(ambiente);
    }

    public InterSdk(String clientId, String clientSecret, String certificado, String senhaCertificado) throws SdkException {
        String tomorrow;
        this.config = Config.builder().ambiente("bancointer").clientId(clientId).clientSecret(clientSecret).certificado(certificado).senha(senhaCertificado).controleRateLimit(true).build();
        if (!new File("logs").exists()) {
            new File("logs").mkdir();
        }
        if (new File(tomorrow = "logs/inter-sdk-" + LocalDateTime.now().plusDays(1L).format(DateTimeFormatter.ofPattern("EEE")) + ".log").exists()) {
            new File(tomorrow).delete();
        }
        log.info(VERSION);
        this.avisos = new ArrayList<String>();
        Date notAfter = SslUtils.isCloseToExpire(certificado, senhaCertificado);
        if (notAfter != null) {
            this.avisos.add(String.format("Certificado pr\u00f3ximo de expirar. Menos de %d dias. Expira em %s.", 30, notAfter));
        }
    }

    public CobrancaSdk cobranca() {
        Pessoa pessoa = new Pessoa();
        pessoa.setCpfCnpj("");
        if (this.cobrancaSdk == null) {
            this.cobrancaSdk = new CobrancaSdk(this.config);
        }
        return this.cobrancaSdk;
    }

    public CobrancaV3Sdk cobrancaV3() {
        Pessoa pessoa = new Pessoa();
        pessoa.setCpfCnpj("");
        if (this.cobrancaV3Sdk == null) {
            this.cobrancaV3Sdk = new CobrancaV3Sdk(this.config);
        }
        return this.cobrancaV3Sdk;
    }

    public BankingSdk banking() {
        if (this.bankingSdk == null) {
            this.bankingSdk = new BankingSdk(this.config);
        }
        return this.bankingSdk;
    }

    public PixSdk pix() {
        if (this.pixSdk == null) {
            this.pixSdk = new PixSdk(this.config);
        }
        return this.pixSdk;
    }

    public List<String> listaAvisos() {
        return this.avisos;
    }

    public void setDebug(boolean debug) {
        this.config.setDebug(debug);
    }

    public void setAmbiente(String ambiente) {
        this.config.setAmbiente(ambiente);
    }

    public void setControleRateLimit(boolean controle) {
        this.config.setControleRateLimit(controle);
    }

    public void setContaCorrente(String contaCorrente) {
        this.config.setContaCorrente(contaCorrente);
    }

    public String getContaCorrente() {
        return this.config.getContaCorrente();
    }

    public Config getConfig() {
        return this.config;
    }
}

