/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.extrato;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.FiltroConsultarExtratoEnriquecido;
import inter.banking.model.PaginaExtratoEnriquecido;
import inter.banking.model.TransacaoEnriquecida;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarExtratoEnriquecido {
    private static final Logger log = LoggerFactory.getLogger(ConsultarExtratoEnriquecido.class);

    public PaginaExtratoEnriquecido consultar(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarExtratoEnriquecido filtro) throws SdkException {
        log.info("ConsultarExtratoEnriquecido {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        return this.getPage(config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public List<TransacaoEnriquecida> consultar(Config config, String dataInicial, String dataFinal, FiltroConsultarExtratoEnriquecido filtro) throws SdkException {
        PaginaExtratoEnriquecido paginaTransacoes;
        log.info("ConsultarExtratoEnriquecido {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<TransacaoEnriquecida> transacoes = new ArrayList<TransacaoEnriquecida>();
        do {
            paginaTransacoes = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro);
            transacoes.addAll(paginaTransacoes.getTransacoes());
        } while (++pagina < paginaTransacoes.getTotalPaginas());
        return transacoes;
    }

    private PaginaExtratoEnriquecido getPage(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarExtratoEnriquecido filtro) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/extrato/completo".replace("AMBIENTE", config.getAmbiente()) + "?dataInicio=" + dataInicial + "&dataFim=" + dataFinal + "&pagina=" + pagina + (String)(tamanhoPagina != null ? "&tamanhoPagina=" + tamanhoPagina : "") + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "extrato.read", "Erro ao consultar extrato enriquecido");
        try {
            return (PaginaExtratoEnriquecido)new ObjectMapper().readValue(json, PaginaExtratoEnriquecido.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroConsultarExtratoEnriquecido filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getTipoOperacao() != null) {
            filter.append("&tipoOperacao").append("=").append(filtro.getTipoOperacao().toString());
        }
        if (filtro.getTipoTransacao() != null) {
            filter.append("&tipoTransacao").append("=").append(filtro.getTipoTransacao().toString());
        }
        return filter.toString();
    }
}

