/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.pagamento;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.FiltroBuscarPagamentos;
import inter.banking.model.Pagamento;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuscarPagamentos {
    private static final Logger log = LoggerFactory.getLogger(BuscarPagamentos.class);

    public List<Pagamento> buscar(Config config, String dataInicial, String dataFinal, FiltroBuscarPagamentos filtro) throws SdkException {
        log.info("BuscarPagamentos {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pagamento".replace("AMBIENTE", config.getAmbiente()) + "?dataInicio=" + dataInicial + "&dataFim=" + dataFinal + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "pagamento-boleto.read", "Erro ao buscar pagamentos");
        try {
            return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Pagamento>>(){});
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroBuscarPagamentos filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getCodBarraLinhaDigitavel() != null) {
            filter.append("&codBarraLinhaDigitavel").append("=").append(filtro.getCodBarraLinhaDigitavel());
        }
        if (filtro.getCodigoTransacao() != null) {
            filter.append("&codigoTransacao").append("=").append(filtro.getCodigoTransacao());
        }
        if (filtro.getFiltrarDataPor() != null) {
            filter.append("&filtrarDataPor").append("=").append(filtro.getFiltrarDataPor().toString());
        }
        return filter.toString();
    }
}

