/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.pagamento;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.PagamentoBoleto;
import inter.banking.model.RespostaIncluirPagamento;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncluirPagamento {
    private static final Logger log = LoggerFactory.getLogger(IncluirPagamento.class);

    public RespostaIncluirPagamento incluir(Config config, PagamentoBoleto pagamento) throws SdkException {
        log.info("IncluirPagamento {} {}", (Object)config.getClientId(), (Object)pagamento.getCodBarraLinhaDigitavel());
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pagamento".replace("AMBIENTE", config.getAmbiente());
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pagamento);
            json = HttpUtils.callPost(config, url, "pagamento-boleto.write", "Erro ao incluir pagamento", json);
            return (RespostaIncluirPagamento)new ObjectMapper().readValue(json, RespostaIncluirPagamento.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

