/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.pagamento;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.PagamentoDarf;
import inter.banking.model.RespostaIncluirPagamentoDarf;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncluirPagamentoDarf {
    private static final Logger log = LoggerFactory.getLogger(IncluirPagamentoDarf.class);

    public RespostaIncluirPagamentoDarf incluir(Config config, PagamentoDarf pagamento) throws SdkException {
        log.info("IncluirPagamentoDarf {} {}", (Object)config.getClientId(), (Object)pagamento.getCodigoReceita());
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pagamento/darf".replace("AMBIENTE", config.getAmbiente());
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pagamento);
            json = HttpUtils.callPost(config, url, "pagamento-darf.write", "Erro ao incluir pagamento de darf", json);
            return (RespostaIncluirPagamentoDarf)new ObjectMapper().readValue(json, RespostaIncluirPagamentoDarf.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

