/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.pix;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.Pix;
import inter.banking.model.RespostaIncluirPix;
import inter.banking.model.RespostaRecuperarPix;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncluirPix {
    private static final Logger log = LoggerFactory.getLogger(IncluirPix.class);

    public RespostaIncluirPix incluir(Config config, Pix pix) throws SdkException {
        log.info("IncluirPix {} {}", (Object)config.getClientId(), (Object)pix.getDescricao());
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pix".replace("AMBIENTE", config.getAmbiente());
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pix);
            json = HttpUtils.callPost(config, url, "pagamento-pix.write", "Erro ao incluir pix", json);
            return (RespostaIncluirPix)new ObjectMapper().readValue(json, RespostaIncluirPix.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    public RespostaRecuperarPix recuperarTransacaoPix(Config config, String codigoRequisicao) throws SdkException {
        log.info("RecuperarPix {} {}", (Object)config.getClientId(), (Object)codigoRequisicao);
        String url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/pix".replace("AMBIENTE", config.getAmbiente()) + "/" + codigoRequisicao;
        String json = HttpUtils.callGet(config, url, "pagamento-pix.read", "Erro ao recuperar pix");
        try {
            return (RespostaRecuperarPix)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<RespostaRecuperarPix>(){});
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

