/*
 * Decompiled with CFR 0.152.
 */
package inter.banking.saldo;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.banking.model.Saldo;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarSaldo {
    private static final Logger log = LoggerFactory.getLogger(ConsultarSaldo.class);

    public Saldo consultar(Config config, String dataSaldo) throws SdkException {
        log.info("ConsultarSaldo {} {}", (Object)config.getClientId(), (Object)dataSaldo);
        Object url = "https://cdpj.partners.AMBIENTE.com.br/banking/v2/saldo".replace("AMBIENTE", config.getAmbiente());
        if (dataSaldo != null) {
            url = (String)url + "?dataSaldo=" + dataSaldo;
        }
        String json = HttpUtils.callGet(config, (String)url, "extrato.read", "Erro ao consultar saldo");
        try {
            return (Saldo)new ObjectMapper().readValue(json, Saldo.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

