/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca;

import inter.cobranca.boletos.CancelarBoleto;
import inter.cobranca.boletos.EmitirBoleto;
import inter.cobranca.boletos.RecuperarBoletoDetalhado;
import inter.cobranca.boletos.RecuperarBoletoPdf;
import inter.cobranca.boletos.RecuperarBoletos;
import inter.cobranca.boletos.RecuperarSumarioBoletos;
import inter.cobranca.model.Boleto;
import inter.cobranca.model.BoletoDetalhado;
import inter.cobranca.model.FiltroBuscarCallbacks;
import inter.cobranca.model.FiltroRecuperarBoletos;
import inter.cobranca.model.FiltroRecuperarSumarioBoletos;
import inter.cobranca.model.Ordenacao;
import inter.cobranca.model.PaginaBoletos;
import inter.cobranca.model.PaginaCallbacks;
import inter.cobranca.model.RespostaBuscarCallbacks;
import inter.cobranca.model.RespostaEmitirBoleto;
import inter.cobranca.model.Sumario;
import inter.cobranca.model.enums.MotivoCancelamento;
import inter.cobranca.webhook.ConsultarCallbacks;
import inter.cobranca.webhook.CriarWebhook;
import inter.cobranca.webhook.ExcluirWebhook;
import inter.cobranca.webhook.ObterWebhook;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Webhook;
import java.util.List;

public class CobrancaSdk {
    private final Config config;
    private EmitirBoleto emitirBoleto;
    private RecuperarBoletos recuperarBoletos;
    private RecuperarSumarioBoletos recuperarSumarioBoletos;
    private RecuperarBoletoDetalhado recuperarBoletoDetalhado;
    private RecuperarBoletoPdf recuperarBoletoPdf;
    private CancelarBoleto cancelarBoleto;
    private CriarWebhook criarWebhook;
    private ObterWebhook obterWebhook;
    private ExcluirWebhook excluirWebhook;
    private ConsultarCallbacks consultarCallbacks;

    public CobrancaSdk(Config config) {
        this.config = config;
    }

    public RespostaEmitirBoleto emitirBoleto(Boleto boleto) throws SdkException {
        if (this.emitirBoleto == null) {
            this.emitirBoleto = new EmitirBoleto();
        }
        return this.emitirBoleto.emitir(this.config, boleto);
    }

    public List<BoletoDetalhado> recuperarBoletos(String dataInicial, String dataFinal, FiltroRecuperarBoletos filtro, Ordenacao ordenacao) throws SdkException {
        if (this.recuperarBoletos == null) {
            this.recuperarBoletos = new RecuperarBoletos();
        }
        return this.recuperarBoletos.recuperar(this.config, dataInicial, dataFinal, filtro, ordenacao);
    }

    public PaginaBoletos recuperarBoletos(String dataInicial, String dataFinal, FiltroRecuperarBoletos filtro, Ordenacao ordenacao, int pagina) throws SdkException {
        if (this.recuperarBoletos == null) {
            this.recuperarBoletos = new RecuperarBoletos();
        }
        return this.recuperarBoletos.recuperar(this.config, dataInicial, dataFinal, pagina, null, filtro, ordenacao);
    }

    public PaginaBoletos recuperarBoletos(String dataInicial, String dataFinal, FiltroRecuperarBoletos filtro, Ordenacao ordenacao, int pagina, int tamanhoPagina) throws SdkException {
        if (this.recuperarBoletos == null) {
            this.recuperarBoletos = new RecuperarBoletos();
        }
        return this.recuperarBoletos.recuperar(this.config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro, ordenacao);
    }

    public Sumario recuperarSumarioBoletos(String dataInicial, String dataFinal, FiltroRecuperarSumarioBoletos filtro) throws SdkException {
        if (this.recuperarSumarioBoletos == null) {
            this.recuperarSumarioBoletos = new RecuperarSumarioBoletos();
        }
        return this.recuperarSumarioBoletos.recuperar(this.config, dataInicial, dataFinal, filtro);
    }

    public BoletoDetalhado recuperarBoletoDetalhado(String nossoNumero) throws SdkException {
        if (this.recuperarBoletoDetalhado == null) {
            this.recuperarBoletoDetalhado = new RecuperarBoletoDetalhado();
        }
        return this.recuperarBoletoDetalhado.recuperar(this.config, nossoNumero);
    }

    public void recuperarBoletoPdf(String nossoNumero, String arquivo) throws SdkException {
        if (this.recuperarBoletoPdf == null) {
            this.recuperarBoletoPdf = new RecuperarBoletoPdf();
        }
        this.recuperarBoletoPdf.recuperar(this.config, nossoNumero, arquivo);
    }

    public void cancelarBoleto(String nossoNumero, MotivoCancelamento motivoCancelamento) throws SdkException {
        if (this.cancelarBoleto == null) {
            this.cancelarBoleto = new CancelarBoleto();
        }
        this.cancelarBoleto.cancelar(this.config, nossoNumero, motivoCancelamento);
    }

    public void criarWebhook(String webhookUrl) throws SdkException {
        if (this.criarWebhook == null) {
            this.criarWebhook = new CriarWebhook();
        }
        this.criarWebhook.criar(this.config, webhookUrl);
    }

    public Webhook obterWebhook() throws SdkException {
        if (this.obterWebhook == null) {
            this.obterWebhook = new ObterWebhook();
        }
        return this.obterWebhook.obter(this.config);
    }

    public void excluirWebhook() throws SdkException {
        if (this.excluirWebhook == null) {
            this.excluirWebhook = new ExcluirWebhook();
        }
        this.excluirWebhook.excluir(this.config);
    }

    public List<RespostaBuscarCallbacks> consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, Ordenacao ordenacao) throws SdkException {
        if (this.consultarCallbacks == null) {
            this.consultarCallbacks = new ConsultarCallbacks();
        }
        return this.consultarCallbacks.recuperar(this.config, dataHoraInicio, dataHoraFim, filtro);
    }

    public PaginaCallbacks consultarCallbacks(String dataHoraInicio, String dataHoraFim, FiltroBuscarCallbacks filtro, int pagina, Ordenacao ordenacao) throws SdkException {
        if (this.consultarCallbacks == null) {
            this.consultarCallbacks = new ConsultarCallbacks();
        }
        return this.consultarCallbacks.recuperar(this.config, dataHoraInicio, dataHoraFim, pagina, null, filtro);
    }
}

