/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca.boletos;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobranca.model.RequisicaoCancelarBoleto;
import inter.cobranca.model.enums.MotivoCancelamento;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelarBoleto {
    private static final Logger log = LoggerFactory.getLogger(CancelarBoleto.class);

    public void cancelar(Config config, String nossoNumero, MotivoCancelamento motivoCancelamento) throws SdkException {
        log.info("CancelarBoleto {} {} {}", new Object[]{config.getClientId(), nossoNumero, motivoCancelamento});
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v2/boletos".replace("AMBIENTE", config.getAmbiente()) + "/" + nossoNumero + "/cancelar";
        RequisicaoCancelarBoleto request = RequisicaoCancelarBoleto.builder().motivoCancelamento(motivoCancelamento).build();
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
            HttpUtils.callPost(config, url, "boleto-cobranca.write", "Erro ao cancelar boleto", json);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

