/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca.boletos;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobranca.model.BoletoDetalhado;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperarBoletoDetalhado {
    private static final Logger log = LoggerFactory.getLogger(RecuperarBoletoDetalhado.class);

    public BoletoDetalhado recuperar(Config config, String nossoNumero) throws SdkException {
        log.info("RecuperarBoletoDetalhado {} nossoNumero={}", (Object)config.getClientId(), (Object)nossoNumero);
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v2/boletos".replace("AMBIENTE", config.getAmbiente()) + "/" + nossoNumero;
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar boleto detalhado");
        try {
            return (BoletoDetalhado)new ObjectMapper().readValue(json, BoletoDetalhado.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

