/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca.boletos;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobranca.model.BoletoDetalhado;
import inter.cobranca.model.FiltroRecuperarBoletos;
import inter.cobranca.model.Ordenacao;
import inter.cobranca.model.PaginaBoletos;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperarBoletos {
    private static final Logger log = LoggerFactory.getLogger(RecuperarBoletos.class);

    public PaginaBoletos recuperar(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroRecuperarBoletos filtro, Ordenacao ordenacao) throws SdkException {
        log.info("RecuperarBoletos {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        return this.getPage(config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro, ordenacao);
    }

    public List<BoletoDetalhado> recuperar(Config config, String dataInicial, String dataFinal, FiltroRecuperarBoletos filtro, Ordenacao ordenacao) throws SdkException {
        PaginaBoletos paginaBoletos;
        log.info("RecuperarBoletos {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<BoletoDetalhado> boletos = new ArrayList<BoletoDetalhado>();
        do {
            paginaBoletos = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro, ordenacao);
            boletos.addAll(paginaBoletos.getBoletos());
        } while (++pagina < paginaBoletos.getTotalPaginas());
        return boletos;
    }

    private PaginaBoletos getPage(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroRecuperarBoletos filtro, Ordenacao ordenacao) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v2/boletos".replace("AMBIENTE", config.getAmbiente()) + "?dataInicial=" + dataInicial + "&dataFinal=" + dataFinal + "&paginaAtual=" + pagina + (String)(tamanhoPagina != null ? "&itensPorPagina=" + tamanhoPagina : "") + this.addfilters(filtro) + this.addSort(ordenacao);
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar boletos");
        try {
            return (PaginaBoletos)new ObjectMapper().readValue(json, PaginaBoletos.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroRecuperarBoletos filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getFiltrarDataPor() != null) {
            filter.append("&filtrarDataPor").append("=").append(filtro.getFiltrarDataPor().toString());
        }
        if (filtro.getSituacao() != null) {
            filter.append("&situacao").append("=").append(filtro.getSituacao().toString());
        }
        if (filtro.getNome() != null) {
            filter.append("&nome").append("=").append(filtro.getNome());
        }
        if (filtro.getEmail() != null) {
            filter.append("&email").append("=").append(filtro.getEmail());
        }
        if (filtro.getCpfCnpj() != null) {
            filter.append("&cpfCnpj").append("=").append(filtro.getCpfCnpj());
        }
        if (filtro.getNossoNumero() != null) {
            filter.append("&nossoNumero").append("=").append(filtro.getNossoNumero());
        }
        return filter.toString();
    }

    private String addSort(Ordenacao ordenacao) {
        if (ordenacao == null) {
            return "";
        }
        StringBuilder order = new StringBuilder();
        if (ordenacao.getOrdenarPor() != null) {
            order.append("&ordenarPor").append("=").append(ordenacao.getOrdenarPor().toString());
        }
        if (ordenacao.getTipoOrdenacao() != null) {
            order.append("&tipoOrdenacao").append("=").append(ordenacao.getTipoOrdenacao().toString());
        }
        return order.toString();
    }
}

