/*
 * Decompiled with CFR 0.152.
 */
package inter.cobranca.boletos;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobranca.model.FiltroRecuperarSumarioBoletos;
import inter.cobranca.model.Sumario;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperarSumarioBoletos {
    private static final Logger log = LoggerFactory.getLogger(RecuperarSumarioBoletos.class);

    public Sumario recuperar(Config config, String dataInicial, String dataFinal, FiltroRecuperarSumarioBoletos filtro) throws SdkException {
        log.info("RecuperarSumarioBoletos {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v2/boletos/sumario".replace("AMBIENTE", config.getAmbiente()) + "?dataInicial=" + dataInicial + "&dataFinal=" + dataFinal + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar sum\u00e1rio de boletos");
        try {
            return (Sumario)new ObjectMapper().readValue(json, Sumario.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroRecuperarSumarioBoletos filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getFiltrarDataPor() != null) {
            filter.append("&filtrarDataPor").append("=").append(filtro.getFiltrarDataPor().toString());
        }
        if (filtro.getSituacao() != null) {
            filter.append("&situacao").append("=").append(filtro.getSituacao().toString());
        }
        if (filtro.getNome() != null) {
            filter.append("&nome").append("=").append(filtro.getNome());
        }
        if (filtro.getEmail() != null) {
            filter.append("&email").append("=").append(filtro.getEmail());
        }
        if (filtro.getCpfCnpj() != null) {
            filter.append("&cpfCnpj").append("=").append(filtro.getCpfCnpj());
        }
        return filter.toString();
    }
}

