/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.cobranca;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobrancav3.model.RequisicaoCancelarCobranca;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelaCobranca {
    private static final Logger log = LoggerFactory.getLogger(CancelaCobranca.class);

    public void cancelar(Config config, String codigoSolicitacao, String motivoCancelamento) throws SdkException {
        log.info("CancelarCobranca {} {} {}", new Object[]{config.getClientId(), codigoSolicitacao, motivoCancelamento});
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas".replace("AMBIENTE", config.getAmbiente()) + "/" + codigoSolicitacao + "/cancelar";
        RequisicaoCancelarCobranca request = RequisicaoCancelarCobranca.builder().motivoCancelamento(motivoCancelamento).build();
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
            HttpUtils.callPost(config, url, "boleto-cobranca.write", "Erro ao cancelar cobranca", json);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

